/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.includebrowser;

import java.util.ArrayList;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.includebrowser.IBFile;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIndexIncludeValue;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IncludeBrowserServiceFactory;
import org.eclipse.swt.widgets.Display;

public class IBContentProvider
extends AsyncTreeContentProvider {
    private boolean fComputeIncludedBy = true;
    private IncludeBrowserServiceFactory fServiceFactory;

    public IBContentProvider(Display disp) {
        super(disp);
    }

    public Object getParent(Object element) {
        if (element instanceof IBNode) {
            IBNode node = (IBNode)element;
            return node.getParent();
        }
        return super.getParent(element);
    }

    protected Object[] syncronouslyComputeChildren(Object parentElement) {
        IBNode node;
        if (parentElement instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)parentElement;
            return new Object[]{new IBNode(null, new IBFile(tu), null, 0, 0, 0L)};
        }
        if (parentElement instanceof IBNode && ((node = (IBNode)parentElement).isRecursive() || node.getRepresentedIFL() == null)) {
            return NO_CHILDREN;
        }
        return null;
    }

    protected Object[] asyncronouslyComputeChildren(Object parentElement, IProgressMonitor monitor) {
        if (parentElement instanceof IBNode) {
            IIndexIncludeValue[] includes;
            IIncludeBrowserService service;
            IBNode node = (IBNode)parentElement;
            IIndexFileLocation ifl = node.getRepresentedIFL();
            ICProject project = node.getCProject();
            if (ifl == null) {
                return NO_CHILDREN;
            }
            IBFile directiveFile = null;
            IBFile targetFile = null;
            if (this.fServiceFactory == null) {
                this.fServiceFactory = new IncludeBrowserServiceFactory();
            }
            if ((service = this.fServiceFactory.getIncludeBrowserService(project)) == null) {
                return NO_CHILDREN;
            }
            if (this.fComputeIncludedBy) {
                includes = service.findIncludedBy(ifl, project, monitor);
            } else {
                includes = service.findIncludesTo(ifl, project, monitor);
                directiveFile = node.getRepresentedFile();
            }
            if (includes.length > 0) {
                ArrayList<IBNode> result = new ArrayList<IBNode>(includes.length);
                int i = 0;
                while (i < includes.length) {
                    IIndexIncludeValue include = includes[i];
                    try {
                        if (this.fComputeIncludedBy) {
                            directiveFile = targetFile = new IBFile(project, include.getIncludedByLocation());
                        } else {
                            IIndexFileLocation includesPath = include.getIncludesLocation();
                            targetFile = includesPath == null ? new IBFile(include.getFullName()) : new IBFile(project, includesPath);
                        }
                        IBNode newnode = new IBNode(node, targetFile, directiveFile, include.getNameOffset(), include.getNameLength(), include.getIncludedByTimestamp());
                        newnode.setIsActiveCode(include.isActive());
                        newnode.setIsSystemInclude(include.isSystemInclude());
                        result.add(newnode);
                    }
                    catch (CoreException e) {
                        CUIPlugin.log((Throwable)e);
                    }
                    ++i;
                }
                return result.toArray();
            }
        }
        return NO_CHILDREN;
    }

    public void setComputeIncludedBy(boolean value) {
        this.fComputeIncludedBy = value;
    }

    public boolean getComputeIncludedBy() {
        return this.fComputeIncludedBy;
    }

    public IncludeBrowserServiceFactory getServiceFactory() {
        return this.fServiceFactory;
    }
}

