/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchMatchAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class RemoteSearchQueryAdapter
implements ISearchQuery {
    protected ICIndexSubsystem fSubsystem;
    protected RemoteSearchQuery fQuery;
    protected RemoteSearchResult fResult;
    protected Scope fScope;
    private static final MatchesComparator MATCHES_COMPARATOR = new MatchesComparator();

    public RemoteSearchQueryAdapter(ICIndexSubsystem subsystem, Scope scope, RemoteSearchQuery query) {
        this.fSubsystem = subsystem;
        this.fScope = scope;
        this.fQuery = query;
        this.fResult = new RemoteSearchResult(this);
    }

    public boolean canRerun() {
        return this.fQuery.canRerun();
    }

    public boolean canRunInBackground() {
        return this.fQuery.canRunInBackground();
    }

    public String getLabel() {
        String type = (this.fQuery.getFlags() & 4) != 0 ? CSearchMessages.PDOMSearchQuery_refs_label : ((this.fQuery.getFlags() & 1) != 0 ? CSearchMessages.PDOMSearchQuery_decls_label : CSearchMessages.PDOMSearchQuery_defs_label);
        return type;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.fSubsystem.checkAllProjects(monitor);
        RemoteSearchResult result = (RemoteSearchResult)this.getSearchResult();
        result.removeAll();
        List results = this.fSubsystem.runQuery(this.fScope, this.fQuery, monitor);
        if (results.size() > 0) {
            Match[] matches = new Match[results.size()];
            int i = 0;
            try {
                for (RemoteSearchMatch match : results) {
                    matches[i] = new RemoteSearchMatchAdapter(match);
                    ++i;
                }
                Arrays.sort(matches, MATCHES_COMPARATOR);
                this.fResult.addMatches(matches);
            }
            catch (CoreException e) {
                CUIPlugin.log((Throwable)e);
            }
            return new Status(0, "org.eclipse.ptp.rdt.ui", "");
        }
        return new Status(0, "org.eclipse.ptp.rdt.ui", "");
    }

    public RemoteSearchQuery getQuery() {
        return this.fQuery;
    }

    public ICProject[] getProjects() {
        return new ICProject[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatchesComparator
    implements Comparator<Match> {
        private MatchesComparator() {
        }

        @Override
        public int compare(Match m1, Match m2) {
            int diff = 0;
            if (m1 instanceof RemoteSearchMatchAdapter && m2 instanceof RemoteSearchMatchAdapter) {
                RemoteSearchMatchAdapter rm1 = (RemoteSearchMatchAdapter)m1;
                RemoteSearchMatchAdapter rm2 = (RemoteSearchMatchAdapter)m2;
                IIndexFileLocation rm1_loc = rm1.getLocation();
                IIndexFileLocation rm2_loc = rm2.getLocation();
                if (rm1_loc != null && rm2_loc != null) {
                    URI rm1_uri = rm1_loc.getURI();
                    URI rm2_uri = rm2_loc.getURI();
                    if (rm1_uri != null && rm2_uri != null) {
                        diff = rm1_uri.compareTo(rm2_uri);
                    }
                }
            }
            if (diff == 0) {
                diff = m1.getOffset() - m2.getOffset();
            }
            if (diff == 0) {
                diff = m2.getLength() - m1.getLength();
            }
            return diff;
        }
    }
}

