/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.db.cdt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.VPGLog;
import org.eclipse.rephraserengine.internal.core.vpg.db.cdt.InternalCDTDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDTDB<A, T, R extends TokenRef<T>, L extends VPGLog<T, R>>
extends VPGDB<A, T, R, L> {
    private InternalCDTDB db;
    private File lock;
    private InternalCDTDB origDB = null;

    public CDTDB(String filename) {
        this(new File(filename));
    }

    public CDTDB(File file) {
        Assert.isNotNull((Object)file);
        try {
            this.lock = new File(String.valueOf(file.getPath()) + ".lock");
            this.db = new InternalCDTDB(file);
        }
        catch (CoreException e) {
            throw new Error("Unable to create VPG database " + file.getName(), e);
        }
    }

    @Override
    public void setVPG(VPG<A, T, R, ? extends VPGDB<A, T, R, L>, L> vpg) {
        super.setVPG(vpg);
        this.clearDBIfPossiblyCorrupted();
    }

    private void clearDBIfPossiblyCorrupted() {
        if (this.lock.exists()) {
            this.clearDatabase();
        } else {
            try {
                this.lock.createNewFile();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void flush() {
        try {
            this.db.flush();
        }
        catch (CoreException e) {
            throw new Error("Unable to flush VPG database to disk", e);
        }
    }

    @Override
    public void close() {
        try {
            this.lock.delete();
            this.db.close();
        }
        catch (CoreException e) {
            throw new Error("Unable to close VPG database", e);
        }
    }

    @Override
    public void clearDatabase() {
        this.getVPG().log.clear();
        try {
            this.db.clear();
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public void enterHypotheticalMode() throws IOException {
        assert (!this.isInHypotheticalMode());
        try {
            this.db.flush();
            File copy = CDTDB.copyFile(this.db.getFile());
            this.origDB = this.db;
            this.db = new InternalCDTDB(copy);
        }
        catch (CoreException e) {
            throw new Error(e);
        }
    }

    private static File copyFile(File orig) throws IOException {
        File tempFile = File.createTempFile("rephraser-tmp", "db");
        FileChannel from = new FileInputStream(orig).getChannel();
        FileChannel to = new FileOutputStream(tempFile).getChannel();
        to.transferFrom(from, 0L, from.size());
        from.close();
        to.close();
        return tempFile;
    }

    @Override
    public void leaveHypotheticalMode() {
        assert (this.isInHypotheticalMode());
        this.db = this.origDB;
        this.origDB = null;
    }

    @Override
    public boolean isInHypotheticalMode() {
        return this.origDB != null;
    }

    private int ensureEntryForFile(String filename) throws CoreException {
        return this.db.files.ensure(filename);
    }

    @Override
    public void updateModificationStamp(String filename) {
        try {
            this.db.files.setModificationStamp(this.ensureEntryForFile(filename), this.getModificationStamp(filename));
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public boolean isOutOfDate(String filename) {
        try {
            long storedModificationStamp = this.db.files.getModificationStamp(this.ensureEntryForFile(filename));
            return storedModificationStamp < this.getModificationStamp(filename);
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    protected abstract long getModificationStamp(String var1);

    @Override
    public void deleteAllEntriesFor(String filename) {
        try {
            this.db.dependencies.deleteAllIncomingDependenciesTo(filename);
            this.db.dependencies.deleteAllOutgoingDependenciesFrom(filename);
            this.db.edges.deleteAllIncomingEdgesTo(filename);
            this.db.edges.deleteAllOutgoingEdgesFrom(filename);
            this.db.annotations.deleteAllAnnotationsFor(filename);
            this.db.files.delete(filename);
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public void deleteAllEdgesAndAnnotationsFor(String filename) {
        try {
            this.db.edges.deleteAllIncomingEdgesTo(filename);
            this.db.edges.deleteAllOutgoingEdgesFrom(filename);
            this.db.annotations.deleteAllAnnotationsFor(filename);
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public void deleteAllIncomingDependenciesFor(String filename) {
        try {
            this.db.dependencies.deleteAllIncomingDependenciesTo(filename);
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public void deleteAllOutgoingDependenciesFor(String filename) {
        try {
            this.db.dependencies.deleteAllOutgoingDependenciesFrom(filename);
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    private void cleanUp(String filename) {
        try {
            if (this.db.dependencies.hasIncomingDependencyRecords(filename)) {
                return;
            }
            if (this.db.dependencies.hasOutgoingDependencyRecords(filename)) {
                return;
            }
            if (this.db.edges.hasIncomingEdges(filename)) {
                return;
            }
            if (this.db.edges.hasOutgoingEdges(filename)) {
                return;
            }
            if (this.db.annotations.hasAnnotations(filename)) {
                return;
            }
            this.db.files.delete(filename);
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public Iterable<String> listAllFilenames() {
        try {
            return this.db.files.getAllFilenames();
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
            return Collections.emptyList();
        }
    }

    @Override
    public Iterable<String> listAllFilenamesWithDependents() {
        try {
            return this.db.dependencies.listAllFilenamesWithDependents();
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
            return Collections.emptyList();
        }
    }

    @Override
    public Iterable<String> listAllDependentFilenames() {
        try {
            return this.db.dependencies.listAllDependentFilenames();
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
            return Collections.emptyList();
        }
    }

    @Override
    public void ensure(VPGDependency<A, T, R> dependency) {
        try {
            this.db.dependencies.ensure(dependency.getDependentFile(), dependency.getDependsOnFile());
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public void delete(VPGDependency<A, T, R> dependency) {
        try {
            String dependentFile = dependency.getDependentFile();
            String dependsOnFile = dependency.getDependsOnFile();
            this.db.dependencies.delete(dependentFile, dependsOnFile);
            this.cleanUp(dependentFile);
            this.cleanUp(dependsOnFile);
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public Iterable<String> getOutgoingDependenciesFrom(String filename) {
        try {
            final InternalCDTDB.IntVector records = this.db.dependencies.findAllOutgoingDependencyRecordsFrom(filename);
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        private int nextRecord = 0;
                        private int numRecords;
                        {
                            this.numRecords = intVector.size();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextRecord < this.numRecords;
                        }

                        @Override
                        public String next() {
                            try {
                                return ((CDTDB)(this).CDTDB.this).db.files.getFilename(((CDTDB)(this).CDTDB.this).db.dependencies.getDependsOnFileRecordPtr(records.get(this.nextRecord++))).getString();
                            }
                            catch (CoreException e) {
                                ((CDTDB)(this).CDTDB.this).getVPG().log.logError(e);
                                throw new Error(e);
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
            return new LinkedList<String>();
        }
    }

    @Override
    public Iterable<String> getIncomingDependenciesTo(String filename) {
        try {
            final InternalCDTDB.IntVector records = this.db.dependencies.findAllIncomingDependencyRecordsTo(filename);
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        private int nextRecord = 0;
                        private int numRecords;
                        {
                            this.numRecords = intVector.size();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextRecord < this.numRecords;
                        }

                        @Override
                        public String next() {
                            try {
                                return ((CDTDB)(this).CDTDB.this).db.files.getFilename(((CDTDB)(this).CDTDB.this).db.dependencies.getDependentFileRecordPtr(records.get(this.nextRecord++))).getString();
                            }
                            catch (CoreException e) {
                                ((CDTDB)(this).CDTDB.this).getVPG().log.logError(e);
                                throw new Error(e);
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
            return new LinkedList<String>();
        }
    }

    @Override
    public void ensure(VPGEdge<A, T, R> edge) {
        try {
            R source = edge.getSource();
            R sink = edge.getSink();
            this.db.edges.ensure(((TokenRef)source).getFilename(), ((TokenRef)source).getOffset(), ((TokenRef)source).getLength(), ((TokenRef)sink).getFilename(), ((TokenRef)sink).getOffset(), ((TokenRef)sink).getLength(), edge.getType());
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public void delete(VPGEdge<A, T, R> edge) {
        try {
            R source = edge.getSource();
            R sink = edge.getSink();
            this.db.edges.delete(((TokenRef)source).getFilename(), ((TokenRef)source).getOffset(), ((TokenRef)source).getLength(), ((TokenRef)sink).getFilename(), ((TokenRef)sink).getOffset(), ((TokenRef)sink).getLength(), edge.getType());
            this.cleanUp(((TokenRef)source).getFilename());
            this.cleanUp(((TokenRef)sink).getFilename());
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getAllEdgesFor(String filename) {
        try {
            final InternalCDTDB.IntVector inRecords = this.db.edges.findAllIncomingEdgeRecordsTo(filename);
            final InternalCDTDB.IntVector outRecords = this.db.edges.findAllOutgoingEdgeRecordsFrom(filename);
            return new Iterable<VPGEdge<A, T, R>>(){

                @Override
                public Iterator<VPGEdge<A, T, R>> iterator() {
                    return new Iterator<VPGEdge<A, T, R>>(){
                        private int nextRecord = 0;
                        private int numRecords;
                        {
                            this.numRecords = intVector.size() + intVector2.size();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextRecord < this.numRecords;
                        }

                        @Override
                        public VPGEdge<A, T, R> next() {
                            try {
                                InternalCDTDB.IntVector records = this.nextRecord < inRecords.size() ? inRecords : outRecords;
                                int recordNum = this.nextRecord < inRecords.size() ? this.nextRecord : this.nextRecord - inRecords.size();
                                Object fromRef = CDTDB.this.getVPG().createTokenRef(((CDTDB)(this).CDTDB.this).db.files.getFilename(((CDTDB)(this).CDTDB.this).db.edges.getFromFileRecordPtr(records.get(recordNum))).getString(), ((CDTDB)(this).CDTDB.this).db.edges.getFromOffset(records.get(recordNum)), ((CDTDB)(this).CDTDB.this).db.edges.getFromLength(records.get(recordNum)));
                                Object toRef = CDTDB.this.getVPG().createTokenRef(((CDTDB)(this).CDTDB.this).db.files.getFilename(((CDTDB)(this).CDTDB.this).db.edges.getToFileRecordPtr(records.get(recordNum))).getString(), ((CDTDB)(this).CDTDB.this).db.edges.getToOffset(records.get(recordNum)), ((CDTDB)(this).CDTDB.this).db.edges.getToLength(records.get(recordNum)));
                                VPGEdge result = CDTDB.this.getVPG().createEdge(fromRef, toRef, ((CDTDB)(this).CDTDB.this).db.edges.getEdgeType(records.get(recordNum)));
                                ++this.nextRecord;
                                return result;
                            }
                            catch (CoreException e) {
                                ((CDTDB)(this).CDTDB.this).getVPG().log.logError(e);
                                throw new Error(e);
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
            return new LinkedList();
        }
    }

    @Override
    public Iterable<VPGEdge<A, T, R>> getOutgoingEdgesFrom(R tokenRef, int edgeType) {
        try {
            final InternalCDTDB.IntVector records = edgeType == Integer.MIN_VALUE ? this.db.edges.findAllOutgoingEdgeRecordsFrom(((TokenRef)tokenRef).getFilename(), ((TokenRef)tokenRef).getOffset(), ((TokenRef)tokenRef).getLength()) : this.db.edges.findAllOutgoingEdgeRecordsFrom(((TokenRef)tokenRef).getFilename(), ((TokenRef)tokenRef).getOffset(), ((TokenRef)tokenRef).getLength(), edgeType);
            return new Iterable<VPGEdge<A, T, R>>(){

                @Override
                public Iterator<VPGEdge<A, T, R>> iterator() {
                    return new Iterator<VPGEdge<A, T, R>>(){
                        private int nextRecord = 0;
                        private int numRecords;
                        {
                            this.numRecords = intVector.size();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextRecord < this.numRecords;
                        }

                        @Override
                        public VPGEdge<A, T, R> next() {
                            try {
                                Object fromRef = CDTDB.this.getVPG().createTokenRef(((CDTDB)(this).CDTDB.this).db.files.getFilename(((CDTDB)(this).CDTDB.this).db.edges.getFromFileRecordPtr(records.get(this.nextRecord))).getString(), ((CDTDB)(this).CDTDB.this).db.edges.getFromOffset(records.get(this.nextRecord)), ((CDTDB)(this).CDTDB.this).db.edges.getFromLength(records.get(this.nextRecord)));
                                Object toRef = CDTDB.this.getVPG().createTokenRef(((CDTDB)(this).CDTDB.this).db.files.getFilename(((CDTDB)(this).CDTDB.this).db.edges.getToFileRecordPtr(records.get(this.nextRecord))).getString(), ((CDTDB)(this).CDTDB.this).db.edges.getToOffset(records.get(this.nextRecord)), ((CDTDB)(this).CDTDB.this).db.edges.getToLength(records.get(this.nextRecord)));
                                return CDTDB.this.getVPG().createEdge(fromRef, toRef, ((CDTDB)(this).CDTDB.this).db.edges.getEdgeType(records.get(this.nextRecord++)));
                            }
                            catch (CoreException e) {
                                ((CDTDB)(this).CDTDB.this).getVPG().log.logError(e);
                                throw new Error(e);
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
            return new LinkedList<VPGEdge<A, T, R>>();
        }
    }

    @Override
    public Iterable<VPGEdge<A, T, R>> getIncomingEdgesTo(R tokenRef, int edgeType) {
        try {
            final InternalCDTDB.IntVector records = edgeType == Integer.MIN_VALUE ? this.db.edges.findAllIncomingEdgeRecordsTo(((TokenRef)tokenRef).getFilename(), ((TokenRef)tokenRef).getOffset(), ((TokenRef)tokenRef).getLength()) : this.db.edges.findAllIncomingEdgeRecordsTo(((TokenRef)tokenRef).getFilename(), ((TokenRef)tokenRef).getOffset(), ((TokenRef)tokenRef).getLength(), edgeType);
            return new Iterable<VPGEdge<A, T, R>>(){

                @Override
                public Iterator<VPGEdge<A, T, R>> iterator() {
                    return new Iterator<VPGEdge<A, T, R>>(){
                        private int nextRecord = 0;
                        private int numRecords;
                        {
                            this.numRecords = intVector.size();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextRecord < this.numRecords;
                        }

                        @Override
                        public VPGEdge<A, T, R> next() {
                            try {
                                Object fromRef = CDTDB.this.getVPG().createTokenRef(((CDTDB)(this).CDTDB.this).db.files.getFilename(((CDTDB)(this).CDTDB.this).db.edges.getFromFileRecordPtr(records.get(this.nextRecord))).getString(), ((CDTDB)(this).CDTDB.this).db.edges.getFromOffset(records.get(this.nextRecord)), ((CDTDB)(this).CDTDB.this).db.edges.getFromLength(records.get(this.nextRecord)));
                                Object toRef = CDTDB.this.getVPG().createTokenRef(((CDTDB)(this).CDTDB.this).db.files.getFilename(((CDTDB)(this).CDTDB.this).db.edges.getToFileRecordPtr(records.get(this.nextRecord))).getString(), ((CDTDB)(this).CDTDB.this).db.edges.getToOffset(records.get(this.nextRecord)), ((CDTDB)(this).CDTDB.this).db.edges.getToLength(records.get(this.nextRecord)));
                                return CDTDB.this.getVPG().createEdge(fromRef, toRef, ((CDTDB)(this).CDTDB.this).db.edges.getEdgeType(records.get(this.nextRecord++)));
                            }
                            catch (CoreException e) {
                                ((CDTDB)(this).CDTDB.this).getVPG().log.logError(e);
                                throw new Error(e);
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
            return new LinkedList<VPGEdge<A, T, R>>();
        }
    }

    @Override
    public void setAnnotation(R token, int annotationID, Serializable annotation) {
        try {
            this.db.annotations.set(((TokenRef)token).getFilename(), ((TokenRef)token).getOffset(), ((TokenRef)token).getLength(), annotationID, this.serialize(annotation));
        }
        catch (Exception e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public void deleteAnnotation(R token, int annotationID) {
        try {
            this.db.annotations.delete(((TokenRef)token).getFilename(), ((TokenRef)token).getOffset(), ((TokenRef)token).getLength(), annotationID);
            this.cleanUp(((TokenRef)token).getFilename());
        }
        catch (CoreException e) {
            this.getVPG().log.logError(e);
        }
    }

    @Override
    public Serializable getAnnotation(R token, int annotationID) {
        int record;
        block3: {
            try {
                record = this.db.annotations.findRecordFor(((TokenRef)token).getFilename(), ((TokenRef)token).getOffset(), ((TokenRef)token).getLength(), annotationID);
                if (record >= 0) break block3;
                return null;
            }
            catch (Exception e) {
                this.getVPG().log.logError(e);
                return null;
            }
        }
        return this.deserialize(this.db.annotations.getAnnotation(record));
    }

    protected abstract byte[] serialize(Serializable var1) throws IOException;

    protected abstract Serializable deserialize(InputStream var1) throws IOException, ClassNotFoundException;

    @Override
    public void printOn(PrintStream out) {
        try {
            out.println("MODIFICATION STAMPS:");
            out.println();
            out.println(this.db.files.toString());
            out.println();
            out.println();
            out.println("DEPENDENCIES:");
            out.println();
            out.println(this.db.dependencies.toString());
            out.println();
            out.println();
            out.println("EDGES:");
            out.println();
            out.println(this.db.edges.toString());
            out.println();
            out.println();
            out.println("ANNOTATIONS:");
            out.println();
            try {
                out.println(this.db.annotations.toString());
            }
            catch (Exception e) {
                this.getVPG().log.logError(e);
            }
        }
        catch (Exception e) {
            out.print(e.getMessage());
            e.printStackTrace(out);
        }
    }

    @Override
    public void printStatisticsOn(PrintStream out) {
        out.println("(No statistics available)");
    }

    @Override
    public void resetStatistics() {
    }
}

