/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core;

import java.io.File;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.IModelPresentation;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.core.util.DebugUtil;
import org.eclipse.ptp.internal.core.ModelManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PTPCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.core";
    private static PTPCorePlugin plugin;
    private ResourceBundle resourceBundle;
    private ModelManager modelManager;

    public static PTPCorePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getUniqueIdentifier() {
        if (PTPCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        if (DebugUtil.RM_TRACING) {
            System.err.println(msg);
        }
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, Messages.PTPCorePlugin_0, e));
    }

    public PTPCorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.core.ParallelPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public IModelManager getModelManager() {
        return this.modelManager;
    }

    public IModelPresentation getModelPresentation() {
        return this.getModelManager();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public IPUniverse getUniverse() {
        return this.getModelPresentation().getUniverse();
    }

    public String locateFragmentFile(String fragment, String file) {
        Bundle[] frags = Platform.getFragments((Bundle)Platform.getBundle((String)PLUGIN_ID));
        if (frags != null) {
            String os = Platform.getOS();
            String arch = Platform.getOSArch();
            String frag_os_arch = String.valueOf(fragment) + "." + os + "." + arch;
            int i = 0;
            while (i < frags.length) {
                Bundle frag = frags[i];
                URL path = frag.getEntry("/");
                try {
                    String file_path;
                    File f;
                    URL local_path = FileLocator.toFileURL((URL)path);
                    String str_path = local_path.getPath();
                    int idx = str_path.indexOf(frag_os_arch);
                    if (idx > 0 && (f = new File(file_path = String.valueOf(str_path) + "bin/" + file)).exists()) {
                        return file_path;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DebugUtil.configurePluginDebugOptions();
        this.modelManager = new ModelManager();
        this.modelManager.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.modelManager.shutdown();
    }
}

