/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.LinkedHashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPUsingDeclaration
extends PDOMCPPBinding
implements ICPPUsingDeclaration {
    private static final int TARGET_BINDING = 28;
    private static final int NEXT_DELEGATE = 32;
    protected static final int RECORD_SIZE = 36;
    private IBinding[] delegates;

    public PDOMCPPUsingDeclaration(PDOMLinkage linkage, PDOMNode parent, ICPPUsingDeclaration using) throws CoreException {
        super(linkage, parent, using.getNameCharArray());
        Database db = this.getDB();
        char[] name = using.getNameCharArray();
        LinkedHashSet<PDOMBinding> targets = new LinkedHashSet<PDOMBinding>();
        PDOMCPPUsingDeclaration last = null;
        IBinding[] iBindingArray = using.getDelegates();
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding delegate = iBindingArray[n2];
            PDOMBinding target = ((PDOMLinkage)this.getLinkage()).adaptBinding(delegate);
            if (target != null && targets.add(target)) {
                if (last == null) {
                    this.setTargetBinding(linkage, target);
                    last = this;
                } else {
                    PDOMCPPUsingDeclaration next = new PDOMCPPUsingDeclaration(linkage, parent, name);
                    next.setTargetBinding(linkage, target);
                    db.putRecPtr(last.getRecord() + 32L, next.record);
                    last = next;
                }
            }
            ++n2;
        }
    }

    public PDOMCPPUsingDeclaration(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    private PDOMCPPUsingDeclaration(PDOMLinkage linkage, PDOMNode parent, char[] name) throws CoreException {
        super(linkage, parent, name);
    }

    private void setTargetBinding(PDOMLinkage linkage, PDOMBinding delegate) throws CoreException {
        this.getDB().putRecPtr(this.record + 28L, delegate != null ? delegate.getRecord() : 0L);
    }

    protected int getRecordSize() {
        return 36;
    }

    public int getNodeType() {
        return 46;
    }

    public IBinding[] getDelegates() {
        if (this.delegates == null) {
            this.delegates = new IBinding[1];
            int i = 0;
            PDOMCPPUsingDeclaration alias = this;
            try {
                do {
                    IBinding delegate;
                    if ((delegate = alias.getBinding()) == null) continue;
                    this.delegates = (IBinding[])ArrayUtil.append(IBinding.class, this.delegates, i++, delegate);
                } while ((alias = alias.getNext()) != null);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
            this.delegates = (IBinding[])ArrayUtil.trim(IBinding.class, this.delegates);
        }
        return this.delegates;
    }

    private PDOMCPPUsingDeclaration getNext() throws CoreException {
        long nextRecord = this.getDB().getRecPtr(this.record + 32L);
        return nextRecord != 0L ? new PDOMCPPUsingDeclaration((PDOMLinkage)this.getLinkage(), nextRecord) : null;
    }

    private IBinding getBinding() {
        try {
            return (IBinding)((Object)((PDOMLinkage)this.getLinkage()).getNode(this.getPDOM().getDB().getRecPtr(this.record + 28L)));
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }
}

