/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.ArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;

class Cost {
    public static final Cost NO_CONVERSION = new Cost(null, null, Rank.NO_MATCH){

        public void setRank(Rank rank) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void setReferenceBinding(ReferenceBinding binding) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void setAmbiguousUDC(boolean val) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void setDeferredUDC(boolean val) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void setInheritanceDistance(int inheritanceDistance) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void setQualificationAdjustment(int adjustment) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void setUserDefinedConversion(ICPPMethod conv) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void setCouldNarrow() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    };
    IType source;
    IType target;
    private Rank fRank;
    private Rank fSecondStandardConversionRank;
    private boolean fAmbiguousUDC;
    private boolean fDeferredUDC;
    private int fQualificationAdjustments;
    private int fInheritanceDistance;
    private ICPPFunction fUserDefinedConversion;
    private ReferenceBinding fReferenceBinding;
    private boolean fCouldNarrow;

    public Cost(IType s, IType t, Rank rank) {
        this.source = s;
        this.target = t;
        this.fRank = rank;
        this.fReferenceBinding = ReferenceBinding.OTHER;
    }

    public final Rank getRank() {
        return this.fRank;
    }

    public final boolean converts() {
        return this.fRank != Rank.NO_MATCH;
    }

    public void setRank(Rank rank) {
        this.fRank = rank;
    }

    public void setReferenceBinding(ReferenceBinding binding) {
        this.fReferenceBinding = binding;
    }

    public boolean isAmbiguousUDC() {
        return this.fAmbiguousUDC;
    }

    public void setAmbiguousUDC(boolean val) {
        this.fAmbiguousUDC = val;
    }

    public boolean isDeferredUDC() {
        return this.fDeferredUDC;
    }

    public void setDeferredUDC(boolean val) {
        this.fDeferredUDC = val;
    }

    public int getInheritanceDistance() {
        return this.fInheritanceDistance;
    }

    public void setInheritanceDistance(int inheritanceDistance) {
        this.fInheritanceDistance = inheritanceDistance;
    }

    public void setQualificationAdjustment(int adjustment) {
        this.fQualificationAdjustments = adjustment;
    }

    public void setUserDefinedConversion(ICPPMethod conv) {
        this.fUserDefinedConversion = conv;
        this.fSecondStandardConversionRank = this.fRank;
        this.fRank = Rank.USER_DEFINED_CONVERSION;
        this.fCouldNarrow = false;
    }

    public int compareTo(Cost other) {
        int qdiff;
        if (other == null) {
            return -1;
        }
        assert (!this.fDeferredUDC && !other.fDeferredUDC);
        int cmp = this.fRank.compareTo(other.fRank);
        if (cmp != 0) {
            return cmp;
        }
        if (this.fRank == Rank.USER_DEFINED_CONVERSION) {
            if (this.isAmbiguousUDC() || other.isAmbiguousUDC()) {
                return 0;
            }
            if (!(this.fUserDefinedConversion == other.fUserDefinedConversion || this.fUserDefinedConversion != null && this.fUserDefinedConversion.equals(other.fUserDefinedConversion))) {
                return 0;
            }
            cmp = this.fSecondStandardConversionRank.compareTo(other.fSecondStandardConversionRank);
            if (cmp != 0) {
                return cmp;
            }
        }
        if ((cmp = this.fInheritanceDistance - other.fInheritanceDistance) != 0) {
            return cmp;
        }
        if (this.fReferenceBinding == ReferenceBinding.LVALUE_REF) {
            if (other.fReferenceBinding == ReferenceBinding.RVALUE_REF_BINDS_RVALUE) {
                return 1;
            }
        } else if (this.fReferenceBinding == ReferenceBinding.RVALUE_REF_BINDS_RVALUE && other.fReferenceBinding == ReferenceBinding.LVALUE_REF) {
            return -1;
        }
        if ((qdiff = this.fQualificationAdjustments ^ other.fQualificationAdjustments) != 0) {
            if ((this.fQualificationAdjustments & qdiff) == 0) {
                return -1;
            }
            if ((other.fQualificationAdjustments & qdiff) == 0) {
                return 1;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String comma = "";
        buf.append((Object)this.fRank).append('[');
        if (this.fQualificationAdjustments != 0) {
            buf.append(comma).append("qualification=").append(this.fQualificationAdjustments);
            comma = ", ";
        }
        if (this.fInheritanceDistance != 0) {
            buf.append(comma).append("inheritance=").append(this.fInheritanceDistance);
            comma = ", ";
        }
        if (this.fDeferredUDC) {
            buf.append(comma).append("deferred UDC");
            comma = ", ";
        }
        if (this.fAmbiguousUDC) {
            buf.append(comma).append("ambiguous UDC");
            comma = ", ";
        }
        if (this.fSecondStandardConversionRank != null) {
            buf.append(comma).append("2ndConvRank=").append((Object)this.fSecondStandardConversionRank);
        }
        buf.append(']');
        return buf.toString();
    }

    public boolean isNarrowingConversion() {
        if (this.fCouldNarrow) {
            if (this.source instanceof CPPBasicType && this.target instanceof ICPPBasicType) {
                Long l;
                ICPPBasicType basicTarget = (ICPPBasicType)this.target;
                IBasicType.Kind targetKind = basicTarget.getKind();
                if (targetKind != IBasicType.Kind.eInt && targetKind != IBasicType.Kind.eFloat && targetKind != IBasicType.Kind.eDouble) {
                    return true;
                }
                IASTExpression val = ((CPPBasicType)this.source).getCreatedFromExpression();
                if (val instanceof IASTLiteralExpression && (l = Value.create(val, 25).numericalValue()) != null) {
                    long n = l;
                    return !ArithmeticConversion.fitsIntoType(basicTarget, n);
                }
            }
            return true;
        }
        return false;
    }

    public void setCouldNarrow() {
        this.fCouldNarrow = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Rank {
        IDENTITY,
        PROMOTION,
        CONVERSION,
        CONVERSION_PTR_BOOL,
        USER_DEFINED_CONVERSION,
        ELLIPSIS_CONVERSION,
        NO_MATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ReferenceBinding {
        RVALUE_REF_BINDS_RVALUE,
        LVALUE_REF,
        OTHER;

    }
}

