/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;
import org.eclipse.ptp.rdt.core.RDTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteProjectResourcesUtil {
    public static List<ICElement> getCElements(IProject project) {
        final ArrayList<ICElement> elements = new ArrayList<ICElement>();
        IResourceVisitor resourceVisitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                ITranslationUnit tu;
                if (!(resource instanceof IFile)) {
                    return !IRemoteIndexerInfoProvider.EXCLUDED_DIRECTORIES.contains(resource.getName());
                }
                if (!IRemoteIndexerInfoProvider.EXCLUDED_FILES.contains(resource.getName()) && (tu = CoreModelUtil.findTranslationUnit((IFile)((IFile)resource))) != null) {
                    elements.add(tu);
                }
                return true;
            }
        };
        try {
            project.accept(resourceVisitor);
        }
        catch (CoreException e) {
            RDTLog.logError(e);
        }
        return elements;
    }

    public static List<ICElement> filterElements(List<ICElement> elements) {
        ArrayList<ICElement> filteredElements = new ArrayList<ICElement>(elements.size());
        for (ICElement element : elements) {
            IPath path = element.getPath();
            if (path == null || IRemoteIndexerInfoProvider.EXCLUDED_FILES.contains(path.lastSegment())) continue;
            filteredElements.add(element);
        }
        return filteredElements;
    }
}

