/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.remotemake;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.messages.Messages;
import org.eclipse.ptp.rdt.core.resources.RemoteMakeNature;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;

public class PathEntryValidationListener {
    private static IResourceChangeListener invalidPathEntryDeleter = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.cdt.core.pathentry_problem", true);
            if (markerDeltas == null || markerDeltas.length == 0) {
                return;
            }
            MarkerDeletionJob job = new MarkerDeletionJob();
            IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
            int n = markerDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta delta = iMarkerDeltaArray[n2];
                IProject proj = delta.getResource().getProject();
                if (RemoteNature.hasRemoteNature(proj) || RemoteMakeNature.hasNature(proj)) {
                    job.addMarker(delta.getMarker());
                }
                ++n2;
            }
            job.schedule();
        }
    };

    private PathEntryValidationListener() {
    }

    public static void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(invalidPathEntryDeleter, 1);
    }

    public static void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(invalidPathEntryDeleter);
    }

    private static class MarkerDeletionJob
    extends Job {
        private final List<IMarker> markersToDelete = new LinkedList<IMarker>();

        public MarkerDeletionJob() {
            super(Messages.PathEntryValidationListener_jobName);
        }

        public void addMarker(IMarker marker) {
            this.markersToDelete.add(marker);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.PathEntryValidationListener_jobName, this.markersToDelete.size());
            for (IMarker marker : this.markersToDelete) {
                monitor.worked(1);
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    RDTLog.logError(e);
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

