/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConstructorInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTConstructorChainInitializer
extends ASTNode
implements ICPPASTConstructorChainInitializer,
IASTImplicitNameOwner,
IASTCompletionContext {
    private IASTName name;
    private IASTImplicitName[] implicitNames;
    private IASTInitializer initializer;
    private boolean fIsPackExpansion;

    public CPPASTConstructorChainInitializer() {
    }

    public CPPASTConstructorChainInitializer(IASTName id, IASTInitializer initializer) {
        this.setMemberInitializerId(id);
        this.setInitializer(initializer);
    }

    public CPPASTConstructorChainInitializer copy() {
        CPPASTConstructorChainInitializer copy = new CPPASTConstructorChainInitializer();
        copy.setMemberInitializerId(this.name == null ? null : this.name.copy());
        copy.setInitializer(this.initializer == null ? null : this.initializer.copy());
        copy.setOffsetAndLength(this);
        copy.fIsPackExpansion = this.fIsPackExpansion;
        return copy;
    }

    public IASTName getMemberInitializerId() {
        return this.name;
    }

    public void setMemberInitializerId(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(MEMBER_ID);
        }
    }

    public IASTInitializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(IASTInitializer init) {
        this.assertNotFrozen();
        this.initializer = init;
        if (init != null) {
            init.setParent(this);
            init.setPropertyInParent(INITIALIZER);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName implicitName = iASTImplicitNameArray[n2];
                if (!implicitName.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.initializer != null && !this.initializer.accept(action)) {
            return false;
        }
        return !action.shouldVisitInitializers || action.leave(this) != 2;
    }

    public int getRoleForName(IASTName n) {
        if (this.name == n) {
            return 1;
        }
        return 3;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        Object[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseClasses = null;
        int i = 0;
        while (i < bindings.length) {
            if (!(bindings[i] instanceof ICPPField) && !(bindings[i] instanceof ICPPNamespace)) {
                if (bindings[i] instanceof ICPPConstructor) {
                    if (baseClasses == null) {
                        baseClasses = this.getBaseClasses(n);
                    }
                    boolean isBaseClassConstructor = false;
                    if (baseClasses != null) {
                        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] iCPPASTBaseSpecifierArray = baseClasses;
                        int n2 = baseClasses.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            char[] baseName;
                            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier b = iCPPASTBaseSpecifierArray[n3];
                            char[] bindingName = bindings[i].getNameCharArray();
                            if (Arrays.equals(bindingName, baseName = b.getName().getLastName().getSimpleID())) {
                                isBaseClassConstructor = true;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (!isBaseClassConstructor) {
                        bindings[i] = null;
                    }
                } else {
                    bindings[i] = null;
                }
            }
            ++i;
        }
        return (IBinding[])ArrayUtil.removeNulls(IBinding.class, bindings);
    }

    private ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] getBaseClasses(IASTName name) {
        IASTNode parent = name.getParent();
        while (parent != null) {
            if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                ICPPASTCompositeTypeSpecifier specifier = (ICPPASTCompositeTypeSpecifier)parent;
                return specifier.getBaseSpecifiers();
            }
            parent = parent.getParent();
        }
        return null;
    }

    public boolean isPackExpansion() {
        return this.fIsPackExpansion;
    }

    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fIsPackExpansion = val;
    }

    @Deprecated
    public IASTExpression getInitializerValue() {
        if (this.initializer == null || this.initializer instanceof IASTExpression) {
            return (IASTExpression)((Object)this.initializer);
        }
        if (this.initializer instanceof ICPPASTConstructorInitializer) {
            IASTExpression expr = ((ICPPASTConstructorInitializer)this.initializer).getExpression();
            if (expr != null) {
                expr = expr.copy();
                expr.setParent(this);
                expr.setPropertyInParent(INITIALIZER);
            }
            return expr;
        }
        return null;
    }

    @Deprecated
    public void setInitializerValue(IASTExpression expression) {
        this.assertNotFrozen();
        CPPASTConstructorInitializer ctorInit = new CPPASTConstructorInitializer();
        if (expression == null) {
            this.setInitializer(ctorInit);
        } else if (expression instanceof IASTInitializer) {
            this.setInitializer((IASTInitializer)((Object)expression));
        } else {
            ctorInit.setExpression(expression);
            ctorInit.setOffsetAndLength((ASTNode)((Object)expression));
            this.setInitializer(ctorInit);
        }
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPConstructor ctor = CPPSemantics.findImplicitlyCalledConstructor(this);
            if (ctor == null) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName ctorName = new CPPASTImplicitName(ctor.getNameCharArray(), (IASTNode)this);
                ctorName.setBinding(ctor);
                IASTName id = this.name;
                if (id instanceof ICPPASTQualifiedName) {
                    id = ((ICPPASTQualifiedName)id).getLastName();
                }
                ctorName.setOffsetAndLength((ASTNode)((Object)id));
                this.implicitNames = new IASTImplicitName[]{ctorName};
            }
        }
        return this.implicitNames;
    }
}

