/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespaceScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPNamespace
extends PlatformObject
implements ICPPNamespace,
ICPPInternalBinding {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    IASTName[] namespaceDefinitions;
    ICPPNamespaceScope scope;
    ICPPASTTranslationUnit tu;

    public CPPNamespace(ICPPASTNamespaceDefinition nsDef) {
        this.findAllDefinitions(nsDef);
        if (this.namespaceDefinitions.length == 0) {
            this.namespaceDefinitions = new IASTName[]{nsDef.getName()};
        }
    }

    public IASTNode[] getDeclarations() {
        return this.namespaceDefinitions;
    }

    public IASTNode getDefinition() {
        return this.tu != null ? this.tu : this.namespaceDefinitions[0];
    }

    private void findAllDefinitions(ICPPASTNamespaceDefinition namespaceDef) {
        NamespaceCollector collector = new NamespaceCollector(namespaceDef);
        namespaceDef.getTranslationUnit().accept(collector);
        this.namespaceDefinitions = collector.getNamespaces();
        int i = 0;
        while (i < this.namespaceDefinitions.length) {
            this.namespaceDefinitions[i].setBinding(this);
            ++i;
        }
    }

    public IASTName[] getNamespaceDefinitions() {
        return this.namespaceDefinitions;
    }

    public CPPNamespace(CPPASTTranslationUnit unit) {
        this.tu = unit;
    }

    public ICPPNamespaceScope getNamespaceScope() {
        if (this.scope == null) {
            this.scope = this.tu != null ? (ICPPNamespaceScope)this.tu.getScope() : new CPPNamespaceScope(this.namespaceDefinitions[0].getParent());
        }
        return this.scope;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        return this.tu != null ? EMPTY_CHAR_ARRAY : this.namespaceDefinitions[0].getSimpleID();
    }

    public IScope getScope() {
        return this.tu != null ? null : CPPVisitor.getContainingScope(this.namespaceDefinitions[0]);
    }

    public IASTNode getPhysicalNode() {
        return this.tu != null ? this.tu : this.namespaceDefinitions[0];
    }

    public String[] getFullyQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getFullyQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() {
        return true;
    }

    public void addDefinition(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.namespaceDefinitions == null) {
            this.namespaceDefinitions = new IASTName[]{name};
            return;
        }
        this.namespaceDefinitions = this.namespaceDefinitions.length > 0 && ((ASTNode)((Object)name)).getOffset() < ((ASTNode)((Object)this.namespaceDefinitions[0])).getOffset() ? (IASTName[])ArrayUtil.prepend(IASTName.class, this.namespaceDefinitions, name) : (IASTName[])ArrayUtil.append(IASTName.class, this.namespaceDefinitions, name);
    }

    public void addDeclaration(IASTNode node) {
        this.addDefinition(node);
    }

    public IBinding[] getMemberBindings() {
        if (this.namespaceDefinitions != null) {
            NamespaceMemberCollector collector = new NamespaceMemberCollector();
            int i = 0;
            while (i < this.namespaceDefinitions.length) {
                IASTNode parent = this.namespaceDefinitions[i].getParent();
                if (parent instanceof ICPPASTNamespaceDefinition) {
                    IASTDeclaration[] decls = ((ICPPASTNamespaceDefinition)parent).getDeclarations();
                    int j = 0;
                    while (j < decls.length) {
                        decls[j].accept(collector);
                        ++j;
                    }
                }
                ++i;
            }
            return collector.members.keyArray(IBinding.class);
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public String toString() {
        String[] names = this.getQualifiedName();
        if (names.length == 0) {
            return "<unnamed namespace>";
        }
        return ASTStringUtil.join((String[])names, (CharSequence)String.valueOf(Keywords.cpCOLONCOLON));
    }

    public IBinding getOwner() throws DOMException {
        if (this.namespaceDefinitions != null && this.namespaceDefinitions.length > 0) {
            return CPPVisitor.findDeclarationOwner(this.namespaceDefinitions[0], false);
        }
        return null;
    }

    public static class CPPNamespaceProblem
    extends ProblemBinding
    implements ICPPNamespace {
        public CPPNamespaceProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public ICPPNamespaceScope getNamespaceScope() throws DOMException {
            throw new DOMException(this);
        }

        public IBinding[] getMemberBindings() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }
    }

    private static class NamespaceCollector
    extends CPPASTVisitor {
        private ICPPASTNamespaceDefinition namespaceDef = null;
        private IASTName[] namespaces = null;

        public NamespaceCollector(ICPPASTNamespaceDefinition ns) {
            this.shouldVisitNamespaces = true;
            this.shouldVisitDeclarations = true;
            this.namespaceDef = ns;
        }

        public int visit(ICPPASTNamespaceDefinition namespace) {
            ICPPASTNamespaceDefinition orig = this.namespaceDef;
            for (ICPPASTNamespaceDefinition candidate = namespace; candidate != null; candidate = (ICPPASTNamespaceDefinition)candidate.getParent()) {
                if (!CharArrayUtils.equals(orig.getName().getLookupKey(), candidate.getName().getLookupKey())) {
                    return 3;
                }
                if (orig.getParent() instanceof ICPPASTNamespaceDefinition) {
                    if (!(candidate.getParent() instanceof ICPPASTNamespaceDefinition)) {
                        return 3;
                    }
                    orig = (ICPPASTNamespaceDefinition)orig.getParent();
                    continue;
                }
                if (!(candidate.getParent() instanceof ICPPASTNamespaceDefinition)) break;
                return 3;
            }
            this.namespaces = (IASTName[])ArrayUtil.append(IASTName.class, this.namespaces, namespace.getName());
            return 1;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof ICPPASTLinkageSpecification) {
                return 3;
            }
            return 1;
        }

        public IASTName[] getNamespaces() {
            return (IASTName[])ArrayUtil.trim(IASTName.class, this.namespaces);
        }
    }

    private static class NamespaceMemberCollector
    extends CPPASTVisitor {
        public ObjectSet<IBinding> members = new ObjectSet(8);

        public NamespaceMemberCollector() {
            this.shouldVisitNamespaces = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarations = true;
        }

        public int visit(IASTDeclarator declarator) {
            while (declarator.getNestedDeclarator() != null) {
                declarator = declarator.getNestedDeclarator();
            }
            IBinding binding = declarator.getName().resolveBinding();
            if (binding != null && !(binding instanceof IProblemBinding)) {
                this.members.put(binding);
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            IASTNode parent;
            if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                IBinding binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && (parent = declSpec.getParent()) instanceof IASTSimpleDeclaration) {
                if (((IASTSimpleDeclaration)parent).getDeclarators().length > 0) {
                    return 1;
                }
                IBinding binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            return 1;
        }

        public int visit(ICPPASTNamespaceDefinition namespace) {
            IBinding binding = namespace.getName().resolveBinding();
            if (binding != null && !(binding instanceof IProblemBinding)) {
                this.members.put(binding);
            }
            return 1;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof ICPPASTUsingDeclaration) {
                IBinding binding = ((ICPPASTUsingDeclaration)declaration).getName().resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    this.members.put(binding);
                }
                return 1;
            }
            if (declaration instanceof IASTFunctionDefinition) {
                return this.visit(((IASTFunctionDefinition)declaration).getDeclarator());
            }
            return 3;
        }
    }
}

