/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.core.preservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Interval
implements Comparable<Interval> {
    public final int lb;
    public final int ub;

    public Interval(int lb, int ub) {
        if (ub < lb) {
            throw new IllegalArgumentException("An interval [j,k) must have j <= k.  [" + lb + "," + ub + ") is not a valid interval");
        }
        this.lb = lb;
        this.ub = ub;
    }

    public boolean isEmpty() {
        return this.lb == this.ub;
    }

    public boolean contains(int n) {
        return this.lb <= n && n < this.ub;
    }

    public boolean isSubsetOf(Interval other) {
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        return other.lb <= this.lb && this.ub <= other.ub;
    }

    public int cardinality() {
        return this.ub - this.lb;
    }

    public boolean overlaps(Interval that) {
        return !this.doesNotOverlap(that);
    }

    private boolean doesNotOverlap(Interval that) {
        return this.ub <= that.lb || this.lb >= that.ub;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            Interval other = (Interval)o;
            return this.lb == other.lb && this.ub == other.ub;
        }
        return false;
    }

    public int hashCode() {
        return 7919 * this.lb + this.ub;
    }

    @Override
    public int compareTo(Interval that) {
        if (this.lb < that.lb) {
            return -1;
        }
        if (this.lb > that.lb) {
            return 1;
        }
        if (this.ub < that.ub) {
            return -1;
        }
        if (this.ub > that.ub) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[" + this.lb + ", " + this.ub + ")";
    }
}

