/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.osgi.framework.Bundle;

public class MPICH2Defaults {
    public static String LAUNCH_CMD = null;
    public static String DEBUG_CMD = null;
    public static String DISCOVER_CMD = null;
    public static String PERIODIC_CMD = null;
    public static int PERIODIC_TIME = 0;
    public static String PATH = null;
    public static boolean USE_DEFAULTS = false;
    private static String defaultsResourcePath = "/data/defaults.properties";

    public static void loadDefaults() throws CoreException {
        Path defaultsPropertiesPath = new Path(defaultsResourcePath);
        Bundle bundle = MPICH2Plugin.getDefault().getBundle();
        Properties properties = MPICH2Defaults.read(defaultsPropertiesPath, bundle);
        LAUNCH_CMD = MPICH2Defaults.getString(bundle, properties, "LAUNCH_CMD");
        DEBUG_CMD = MPICH2Defaults.getString(bundle, properties, "DEBUG_CMD");
        DISCOVER_CMD = MPICH2Defaults.getString(bundle, properties, "DISCOVER_CMD");
        PERIODIC_CMD = MPICH2Defaults.getString(bundle, properties, "PERIODIC_CMD");
        PERIODIC_TIME = MPICH2Defaults.getInteger(bundle, properties, "PERIODIC_TIME");
        PATH = MPICH2Defaults.getString(bundle, properties, "PATH");
        USE_DEFAULTS = MPICH2Defaults.getBoolean(bundle, properties, "USE_DEFAULTS");
        assert (LAUNCH_CMD != null);
        assert (DEBUG_CMD != null);
        assert (DISCOVER_CMD != null);
        assert (PERIODIC_CMD != null);
        assert (PATH != null);
    }

    public static Properties read(Path defaultsPropertiesPath, Bundle bundle) throws CoreException {
        Properties properties = new Properties();
        try {
            InputStream inStream = FileLocator.openStream((Bundle)bundle, (IPath)defaultsPropertiesPath, (boolean)false);
            properties.load(inStream);
        }
        catch (IOException e) {
            throw MPICH2Plugin.coreErrorException(Messages.MPICH2Defaults_Exception_FailedReadFile, e);
        }
        return properties;
    }

    public static String getString(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)Messages.MPICH2Defaults_MissingValue, (Object)key)));
        }
        return value;
    }

    public static int getInteger(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = MPICH2Defaults.getString(bundle, properties, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)Messages.MPICH2Defaults_FailedParseInteger, (Object)key)));
        }
    }

    public static boolean getBoolean(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = MPICH2Defaults.getString(bundle, properties, key);
        return Boolean.parseBoolean(value);
    }
}

