/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolRMServiceProvider;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2PreferenceManager;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem.IMPICH2ResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem.MPICH2ResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;

public class MPICH2ServiceProvider
extends AbstractToolRMServiceProvider
implements IMPICH2ResourceManagerConfiguration {
    private static final String TAG_VERSION_ID = "versionId";

    public MPICH2ServiceProvider() {
        super(23);
        Preferences prefs = MPICH2PreferenceManager.getPreferences();
        this.setLaunchCmd(prefs.getString("mpich2-launchCmd"));
        this.setDebugCmd(prefs.getString("mpich2-debugCmd"));
        this.setDiscoverCmd(prefs.getString("mpich2-discoverCmd"));
        this.setPeriodicMonitorCmd(prefs.getString("mpich2-periodicMonitorCmd"));
        this.setPeriodicMonitorTime(prefs.getInt("mpich2-periodicMonitorTime"));
        this.setRemoteInstallPath(prefs.getString("mpich2-remoteInstallPath"));
    }

    public MPICH2ServiceProvider(MPICH2ServiceProvider provider) {
        super((AbstractToolRMServiceProvider)provider);
    }

    public IServiceProviderWorkingCopy copy() {
        return new MPICH2ServiceProvider(this);
    }

    public IResourceManagerControl createResourceManager() {
        IPUniverseControl universe = (IPUniverseControl)PTPCorePlugin.getDefault().getUniverse();
        return new MPICH2ResourceManager(universe.getNextResourceManagerId(), universe, (IResourceManagerConfiguration)this);
    }

    public String getResourceManagerId() {
        return this.getId();
    }

    public String getVersionId() {
        return this.getString(TAG_VERSION_ID, "");
    }

    public void setDefaultNameAndDesc() {
        String name = Messages.MPICH2ResourceManagerConfiguration_defaultName;
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription(Messages.MPICH2ResourceManagerConfiguration_defaultDescription);
    }

    public void setVersionId(String versionId) {
        this.putString(TAG_VERSION_ID, versionId);
    }
}

