/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.ui.launch.BaseRMLaunchConfigurationDynamicTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendableRMLaunchConfigurationDynamicTab
extends AbstractRMLaunchConfigurationDynamicTab
implements IRMLaunchConfigurationContentsChangedListener {
    private final List<BaseRMLaunchConfigurationDynamicTab> tabControllers = new ArrayList<BaseRMLaunchConfigurationDynamicTab>();
    private Composite control;

    public RMLaunchValidation canSave(Control control, IResourceManager rm, IPQueue queue) {
        for (BaseRMLaunchConfigurationDynamicTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.canSave(control, rm, queue);
            if (validation.isSuccess()) continue;
            return validation;
        }
        return new RMLaunchValidation(true, null);
    }

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) throws CoreException {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.control.setLayout((Layout)layout);
        TabFolder tabFolder = new TabFolder(this.control, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        for (BaseRMLaunchConfigurationDynamicTab tabControl : this.tabControllers) {
            TabItem simpleTabItem = new TabItem(tabFolder, 0);
            tabControl.createControl((Composite)tabFolder, rm, queue);
            simpleTabItem.setText(tabControl.getText());
            simpleTabItem.setImage(tabControl.getImage());
            simpleTabItem.setControl(tabControl.getControl());
        }
    }

    public IAttribute<?, ?, ?>[] getAttributes(IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration, String mode) throws CoreException {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        for (BaseRMLaunchConfigurationDynamicTab tabControl : this.tabControllers) {
            IAttribute[] attributeArray = tabControl.getAttributes(rm, queue, configuration, mode);
            if (attributeArray == null) continue;
            List<IAttribute> attributesList = Arrays.asList(attributeArray);
            attributes.addAll(attributesList);
        }
        return attributes.toArray(new IAttribute[attributes.size()]);
    }

    public Control getControl() {
        return this.control;
    }

    public void handleContentsChanged(IRMLaunchConfigurationDynamicTab factory) {
        this.fireContentsChanged();
    }

    public RMLaunchValidation initializeFrom(Control control, IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) {
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        for (BaseRMLaunchConfigurationDynamicTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.initializeFrom(control, rm, queue, configuration);
            if (validation.isSuccess()) continue;
            resultValidation = validation;
        }
        return resultValidation;
    }

    public RMLaunchValidation isValid(ILaunchConfiguration launchConfig, IResourceManager rm, IPQueue queue) {
        for (BaseRMLaunchConfigurationDynamicTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.isValid(launchConfig, rm, queue);
            if (validation.isSuccess()) continue;
            return validation;
        }
        return new RMLaunchValidation(true, null);
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        for (BaseRMLaunchConfigurationDynamicTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.performApply(configuration, rm, queue);
            if (validation.isSuccess()) continue;
            resultValidation = validation;
        }
        return resultValidation;
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        for (BaseRMLaunchConfigurationDynamicTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.setDefaults(configuration, rm, queue);
            if (validation.isSuccess()) continue;
            resultValidation = validation;
        }
        return resultValidation;
    }

    public void updateControls() {
        for (BaseRMLaunchConfigurationDynamicTab tabControl : this.tabControllers) {
            tabControl.updateControls();
        }
    }

    protected void addDynamicTab(BaseRMLaunchConfigurationDynamicTab tabController) {
        this.tabControllers.add(tabController);
        tabController.addContentsChangedListener(this);
    }
}

