/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFieldSpecialization
extends PDOMCPPSpecialization
implements ICPPField {
    private static final int TYPE_OFFSET = 40;
    private static final int VALUE_OFFSET = 46;
    protected static final int RECORD_SIZE = 50;

    public PDOMCPPFieldSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPField field, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)field), specialized);
        try {
            Database db = this.getDB();
            linkage.storeType(this.record + 40L, field.getType());
            long rec = PDOMValue.store(db, linkage, field.getInitialValue());
            db.putRecPtr(this.record + 46L, rec);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPFieldSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 50;
    }

    public int getNodeType() {
        return 33;
    }

    private ICPPField getField() {
        return (ICPPField)this.getSpecializedBinding();
    }

    public ICompositeType getCompositeTypeOwner() throws DOMException {
        return this.getClassOwner();
    }

    public IType getType() throws DOMException {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 40L);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public IValue getInitialValue() {
        try {
            Database db = this.getDB();
            long valRec = db.getRecPtr(this.record + 46L);
            return PDOMValue.restore(db, (PDOMLinkage)this.getLinkage(), valRec);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return this.getField().isAuto();
    }

    public boolean isExtern() throws DOMException {
        return this.getField().isExtern();
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return this.getField().isRegister();
    }

    public boolean isStatic() throws DOMException {
        return this.getField().isStatic();
    }

    public ICPPClassType getClassOwner() throws DOMException {
        return (ICPPClassType)((Object)this.getOwner());
    }

    public int getVisibility() throws DOMException {
        return this.getField().getVisibility();
    }

    public boolean isMutable() throws DOMException {
        return this.getField().isMutable();
    }
}

