/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.editorHelp;

import java.net.URL;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpResource;
import org.osgi.framework.Bundle;

public class CHelpResourceDescriptorImpl
implements ICHelpResourceDescriptor {
    ICHelpBook book;
    String name;
    String label;
    String href;
    IHelpResource[] resources;

    public CHelpResourceDescriptorImpl(ICHelpBook helpBook, IFunctionSummary functionSummary, String pluginId) {
        this.book = helpBook;
        this.name = functionSummary.getName();
        StringBuffer buf = new StringBuffer();
        String htmlLocn = this.findHTMLdir(pluginId);
        buf.append("/").append(pluginId).append("/").append(htmlLocn).append("/").append(this.name).append(".html");
        this.href = buf.toString();
        this.label = functionSummary.getPrototype().getPrototypeString(false);
        this.resources = new IHelpResource[1];
        this.resources[0] = new IHelpResource(){

            public String getHref() {
                return CHelpResourceDescriptorImpl.this.href;
            }

            public String getLabel() {
                return CHelpResourceDescriptorImpl.this.label;
            }
        };
    }

    public ICHelpBook getCHelpBook() {
        return this.book;
    }

    public IHelpResource[] getHelpResources() {
        return this.resources;
    }

    public String toString() {
        return String.valueOf(this.name) + " -> " + this.href;
    }

    private String findHTMLdir(String pluginId) {
        String HTML_ALT_DIR = "html2";
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(HTML_ALT_DIR), null);
        if (url != null) {
            return HTML_ALT_DIR;
        }
        return "html";
    }
}

