/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.ppw;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;
import org.eclipse.ptp.etfw.ppw.PPWDataManager;

public class PPWController {
    private final ProcessBuilder ppwpb;
    private final ProcessBuilder ppwconfigpb;
    private final PPWDataManager ppwDataManager;
    private String ppwVersion;
    private boolean ppwSupportsControl;

    public PPWController(PPWDataManager ppwDataManager, String[] args) {
        this.ppwDataManager = ppwDataManager;
        String ppwToolPath = BuildLaunchUtils.getToolPath((String)"ppw");
        String ppw = String.valueOf(ppwToolPath) + File.separator + "ppw";
        String ppwConfig = String.valueOf(ppwToolPath) + File.separator + "ppw-config";
        ArrayList<String> ppwConfigCmd = new ArrayList<String>();
        ppwConfigCmd.add(ppwConfig);
        ppwConfigCmd.add("--version");
        this.ppwconfigpb = new ProcessBuilder(ppwConfigCmd);
        Process ppwconf = null;
        try {
            ppwconf = this.ppwconfigpb.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ppwVersion = null;
        this.ppwSupportsControl = false;
        try {
            InputStreamReader isr = new InputStreamReader(ppwconf.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            this.ppwVersion = br.readLine();
        }
        catch (IOException iOException) {}
        if (this.ppwVersion != null) {
            int vMajor = Integer.parseInt(this.ppwVersion.substring(0, 1));
            String ppwVerRest = this.ppwVersion.substring(2);
            this.ppwSupportsControl = vMajor < 2 ? false : vMajor != 2 || !ppwVerRest.equals("0") && !ppwVerRest.equals("1") && !ppwVerRest.equals("2") && !ppwVerRest.equals("4");
        }
        ArrayList<String> ppwCmd = new ArrayList<String>();
        ppwCmd.add(ppw);
        if (this.ppwSupportsControl) {
            ppwCmd.add("-c");
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ppwCmd.add(s);
            ++n2;
        }
        this.ppwpb = new ProcessBuilder(ppwCmd);
        Process p = null;
        try {
            p = this.ppwpb.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new Thread(new IOWatcher(p.getInputStream())).start();
    }

    class IOWatcher
    implements Runnable {
        InputStream is;

        IOWatcher(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("source")) {
                        String[] split = line.split(" ");
                        String filename = split[1];
                        int linenum = Integer.parseInt(split[2]);
                        PPWController.this.ppwDataManager.highlightSourceLine(filename, linenum);
                        continue;
                    }
                    if (!line.startsWith("exit")) {
                        System.out.println(line);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

