/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import java.net.URI;
import org.eclipse.cdt.core.model.ILanguageMappingChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;

public class LanguageMappingChangeEvent
implements ILanguageMappingChangeEvent {
    private int fType;
    private IProject fProject;
    private IFile fFile;
    private IPath fPath;
    private String fFileName;
    private IContentType[] fContentTypes;

    public IContentType[] getAffectedContentTypes() {
        return this.fContentTypes;
    }

    public IFile getFile() {
        return this.fFile;
    }

    public String getFilename() {
        if (this.fFileName != null) {
            return this.fFileName;
        }
        if (this.fFile != null) {
            IPath location = this.fFile.getLocation();
            if (location != null) {
                return location.toString();
            }
            URI uri = this.fFile.getLocationURI();
            if (uri != null) {
                return uri.toString();
            }
        } else if (this.fPath != null) {
            return this.fPath.toString();
        }
        return null;
    }

    public IPath getPath() {
        if (this.fPath != null) {
            return this.fPath;
        }
        if (this.fFile != null) {
            IPath location = this.fFile.getLocation();
            return location;
        }
        return null;
    }

    public IProject getProject() {
        if (this.fProject != null) {
            return this.fProject;
        }
        if (this.fFile != null) {
            return this.fFile.getProject();
        }
        return null;
    }

    public int getType() {
        return this.fType;
    }

    public void setAffectedContentTypes(IContentType[] affectedContentTypes) {
        this.fContentTypes = affectedContentTypes;
    }

    public void setFile(IFile file) {
        this.fFile = file;
    }

    public void setFileName(String fileName) {
        this.fFileName = fileName;
    }

    public void setPath(IPath path) {
        this.fPath = path;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void setType(int type) {
        this.fType = type;
    }
}

