/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.ptp.remote.core.AbstractRemoteProcess;
import org.eclipse.ptp.remote.core.NullInputStream;
import org.eclipse.rse.services.shells.HostShellOutputStream;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;

public class RSEProcess
extends AbstractRemoteProcess
implements IHostShellOutputListener {
    private final boolean mergeOutput;
    private final IHostShell hostShell;
    private InputStream inputStream = null;
    private InputStream errorStream = null;
    private HostShellOutputStream outputStream = null;
    private PipedOutputStream hostShellInput = null;
    private PipedOutputStream hostShellError = null;

    public RSEProcess(IHostShell hostShell, boolean mergeOutput) throws IOException {
        this.hostShell = hostShell;
        this.mergeOutput = mergeOutput;
        this.hostShellInput = new PipedOutputStream();
        if (mergeOutput) {
            this.hostShellError = this.hostShellInput;
            this.errorStream = new NullInputStream();
        } else {
            this.hostShellError = new PipedOutputStream();
            this.errorStream = new PipedInputStream(this.hostShellError);
        }
        this.inputStream = new PipedInputStream(this.hostShellInput);
        this.outputStream = new HostShellOutputStream(hostShell);
        this.hostShell.getStandardOutputReader().addOutputListener((IHostShellOutputListener)this);
        this.hostShell.getStandardErrorReader().addOutputListener((IHostShellOutputListener)this);
    }

    public synchronized void destroy() {
        this.hostShell.exit();
        ((Object)((Object)this)).notifyAll();
        try {
            this.hostShellInput.close();
            if (!this.mergeOutput) {
                this.hostShellError.close();
            }
            this.inputStream.close();
            this.errorStream.close();
            this.outputStream.close();
        }
        catch (IOException iOException) {}
    }

    public synchronized int exitValue() {
        if (this.hostShell.isActive()) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public synchronized int waitFor() throws InterruptedException {
        this.waitForHostShellTermination();
        try {
            ((Object)((Object)this)).wait(1000L);
            if (this.inputStream.available() != 0 || this.errorStream.available() != 0) {
                throw new InterruptedException();
            }
            this.hostShellInput.close();
            if (!this.mergeOutput) {
                this.hostShellError.close();
            }
            this.inputStream.close();
            this.errorStream.close();
            this.outputStream.close();
        }
        catch (IOException iOException) {}
        return 0;
    }

    public boolean isCompleted() {
        try {
            this.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        PipedOutputStream outputStream;
        IHostOutput[] input = event.getLines();
        PipedOutputStream pipedOutputStream = outputStream = event.isError() ? this.hostShellError : this.hostShellInput;
        if (input.length == 0) {
            this.waitForHostShellTermination();
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            int i = 0;
            while (i < input.length) {
                outputStream.write(input[i].getString().getBytes());
                ((OutputStream)outputStream).write(10);
                ((OutputStream)outputStream).flush();
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    private synchronized void waitForHostShellTermination() {
        while (this.hostShell.isActive()) {
            try {
                ((Object)((Object)this)).wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

