/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.loops;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.parser.ASTDoConstructNode;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLabelDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.parser.IExecutableConstruct;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IObsoleteActionStmt;

public class LoopReplacer {
    private List<ASTDoConstructNode> queue = new LinkedList<ASTDoConstructNode>();

    public static void replaceAllLoopsIn(ScopingNode scope) {
        new LoopReplacer().replaceLoopsFromLastToFirstIn(scope);
    }

    private void replaceLoopsFromLastToFirstIn(ScopingNode scope) {
        this.collectLoopsIn(scope);
        while (!this.queue.isEmpty()) {
            this.replaceLoop(this.queue.remove(0));
        }
    }

    private void collectLoopsIn(ScopingNode scope) {
        scope.accept(new ASTVisitor(){

            public void visitASTDoConstructNode(ASTDoConstructNode node) {
                if (!this.isHeaderForOldStyleLoop(node)) {
                    LoopReplacer.this.queue.add(0, node);
                }
            }

            private boolean isHeaderForOldStyleLoop(ASTDoConstructNode node) {
                return node.getLabelDoStmt().getLblRef() != null;
            }
        });
    }

    private void replaceLoop(ASTDoConstructNode loopToReplace) {
        IASTNode oldParent = loopToReplace.getParent();
        ScopingNode scope = loopToReplace.findNearestAncestor(ScopingNode.class);
        ASTProperLoopConstructNode newLoop = this.buildASTProperLoopConstructNode(loopToReplace, scope);
        loopToReplace.replaceWith(newLoop);
        newLoop.setParent(oldParent);
    }

    private ASTProperLoopConstructNode buildASTProperLoopConstructNode(ASTDoConstructNode loopToReplace, ScopingNode scope) {
        ASTLabelDoStmtNode lastLoopHeader = loopToReplace.getLabelDoStmt();
        ASTProperLoopConstructBuilder nodeBuilder = new ASTProperLoopConstructBuilder(lastLoopHeader);
        scope.accept(nodeBuilder);
        lastLoopHeader.removeFromTree();
        nodeBuilder.result.setLoopHeader(lastLoopHeader);
        return nodeBuilder.result;
    }

    private class ASTProperLoopConstructBuilder
    extends ASTVisitorWithLoops {
        private final ASTProperLoopConstructNode result = new ASTProperLoopConstructNode();
        private final ASTLabelDoStmtNode loopHeader;
        private final IASTNode doConstructNode;
        private final IASTNode listEnclosingDoConstructNode;
        private boolean loopHeaderFound = false;

        public ASTProperLoopConstructBuilder(ASTLabelDoStmtNode loopHeader) {
            this.loopHeader = loopHeader;
            this.doConstructNode = loopHeader.getParent();
            this.listEnclosingDoConstructNode = this.doConstructNode.getParent();
        }

        public void visitASTLabelDoStmtNode(ASTLabelDoStmtNode node) {
            if (node == this.loopHeader) {
                this.loopHeaderFound = true;
            }
            this.traverseChildren(node);
        }

        public void visitIExecutionPartConstruct(IExecutionPartConstruct node) {
            if (this.shouldBeInLoopBody(node)) {
                node.removeFromTree();
                this.result.getBody().add(node);
            }
        }

        public void visitIExecutableConstruct(IExecutableConstruct node) {
            this.visitIExecutionPartConstruct(node);
        }

        public void visitIActionStmt(IActionStmt node) {
            this.visitIExecutionPartConstruct(node);
        }

        public void visitIObsoleteActionStmt(IObsoleteActionStmt node) {
            this.visitIExecutionPartConstruct(node);
        }

        private boolean shouldBeInLoopBody(IExecutionPartConstruct node) {
            return this.loopHeaderFound && !this.endDoStmtFound() && !this.isLoopHeader(node) && this.isCurrentlySiblingOfLoopHeader(node);
        }

        private boolean isCurrentlySiblingOfLoopHeader(IExecutionPartConstruct node) {
            return node.getParent() == this.listEnclosingDoConstructNode;
        }

        private boolean isLoopHeader(IExecutionPartConstruct node) {
            return node == this.loopHeader || node == this.doConstructNode;
        }

        public void visitASTEndDoStmtNode(ASTEndDoStmtNode node) {
            if (this.loopHeaderFound && !this.endDoStmtFound() && !(node.getParent() instanceof ASTProperLoopConstructNode)) {
                node.removeFromTree();
                this.result.setEndDoStmt(node);
            }
            this.traverseChildren(node);
        }

        private boolean endDoStmtFound() {
            return this.result.getEndDoStmt() != null;
        }

        public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
        }
    }
}

