/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.generic.core.rmsystem;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolRMServiceProvider;
import org.eclipse.ptp.rm.generic.core.GenericRMPreferenceManager;
import org.eclipse.ptp.rm.generic.core.messages.Messages;
import org.eclipse.ptp.rm.generic.core.rmsystem.GenericResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;

public class GenericRMServiceProvider
extends AbstractToolRMServiceProvider {
    public static int CAPABILITIES = 17;

    public GenericRMServiceProvider() {
        super(CAPABILITIES);
        Preferences preferences = GenericRMPreferenceManager.getPreferences();
        this.setLaunchCmd(preferences.getString("launchCmd"));
        this.setDebugCmd(preferences.getString("debugCmd"));
        this.setRemoteInstallPath(preferences.getString("remoteInstallPath"));
        this.setUseInstallDefaults(true);
        this.setUseToolDefaults(true);
        this.setCommandsEnabled(false);
        this.setDescription(Messages.GenericRMServiceProvider_defaultDescription);
    }

    public GenericRMServiceProvider(GenericRMServiceProvider provider) {
        super((AbstractToolRMServiceProvider)provider);
    }

    public IServiceProviderWorkingCopy copy() {
        return new GenericRMServiceProvider(this);
    }

    public IResourceManagerControl createResourceManager() {
        IPUniverseControl universe = (IPUniverseControl)PTPCorePlugin.getDefault().getUniverse();
        return new GenericResourceManager(universe.getNextResourceManagerId(), universe, (IResourceManagerConfiguration)this);
    }

    public String getResourceManagerId() {
        return this.getId();
    }

    public void setDefaultNameAndDesc() {
        String name = Messages.GenericRMServiceProvider_defaultName;
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription(Messages.GenericRMServiceProvider_defaultDescription);
    }
}

