/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class RDTPluginImages {
    public static final IPath ICONS_PATH = new Path("$nl$/icons");
    private static ImageRegistry imageRegistry = new ImageRegistry(UIPlugin.getStandardDisplay());
    private static URL fgIconBaseURL;
    private static final String NAME_PREFIX = "org.eclipse.ptp.rdt.ui.";
    private static final int NAME_PREFIX_LENGTH;
    public static final String T_OBJ = "obj16/";
    public static final String T_WIZBAN = "wizban/";
    public static final String T_LCL = "lcl16/";
    public static final String T_DLCL = "dlcl16/";
    public static final String T_ELCL = "elcl16/";
    public static final String T_TOOL = "tool16/";
    public static final String T_VIEW = "view16/";
    public static final String T_OVR = "ovr16/";
    public static final ImageDescriptor DESC_WIZBAN_NEW_REMOTE_C_PROJ;
    public static final ImageDescriptor DESC_WIZBAN_EXPORT_C_SETTINGS;
    public static final ImageDescriptor DESC_WIZBAN_IMPORT_C_SETTINGS;

    static {
        try {
            fgIconBaseURL = new URL(UIPlugin.getDefault().getBundle().getEntry("/"), "icons/");
        }
        catch (MalformedURLException e) {
            UIPlugin.log(e);
        }
        NAME_PREFIX_LENGTH = NAME_PREFIX.length();
        DESC_WIZBAN_NEW_REMOTE_C_PROJ = RDTPluginImages.create(T_WIZBAN, "newremote_proj_wiz.gif");
        DESC_WIZBAN_EXPORT_C_SETTINGS = RDTPluginImages.create(T_WIZBAN, "exportc_settings_wiz.gif");
        DESC_WIZBAN_IMPORT_C_SETTINGS = RDTPluginImages.create(T_WIZBAN, "importc_settings_wiz.gif");
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        return RDTPluginImages.createManaged(imageRegistry, prefix, name);
    }

    private static ImageDescriptor createManaged(ImageRegistry registry, String prefix, String name) {
        ImageDescriptor result = ImageDescriptor.createFromURL((URL)RDTPluginImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
        registry.put(name, result);
        return result;
    }

    public static Image get(String key) {
        return imageRegistry.get(key);
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)RDTPluginImages.makeIconFileURL(prefix, name));
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return RDTPluginImages.createImageDescriptor(UIPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createUnManaged(String prefix, String name) {
        return RDTPluginImages.create(prefix, name, true);
    }

    private static URL makeIconFileURL(String prefix, String name) {
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(name);
        try {
            return new URL(fgIconBaseURL, buffer.toString());
        }
        catch (MalformedURLException e) {
            UIPlugin.log(e);
            return null;
        }
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        RDTPluginImages.setImageDescriptors(action, T_TOOL, iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        RDTPluginImages.setImageDescriptors(action, T_LCL, iconName);
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        if (relPath.startsWith(NAME_PREFIX)) {
            relPath = relPath.substring(NAME_PREFIX_LENGTH);
        }
        action.setDisabledImageDescriptor(RDTPluginImages.create("d" + type, relPath));
        action.setImageDescriptor(RDTPluginImages.create("e" + type, relPath));
    }

    static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }
}

