/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.ui.RMUIPlugin;
import org.eclipse.ptp.rm.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.ptp.rm.ui.wizards.AbstractConfigurationWizardPage;
import org.eclipse.ptp.rm.ui.wizards.WizardPageDataSource;
import org.eclipse.ptp.rm.ui.wizards.WizardPageWidgetListener;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.ptp.utils.ui.swt.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractRemoteResourceManagerConfigurationWizardPage
extends AbstractConfigurationWizardPage {
    public static final String EMPTY_STRING = "";
    private IRemoteUIConnectionManager uiConnectionManager = null;
    protected Button noneButton = null;
    protected Button portForwardingButton = null;
    protected WidgetListener listener = new WidgetListener();
    protected Button newConnectionButton;
    protected Combo remoteCombo;
    protected Combo connectionCombo;
    protected Combo localAddrCombo;
    protected IRemoteServices[] fRemoteServices = null;

    public AbstractRemoteResourceManagerConfigurationWizardPage(IRMConfigurationWizard wizard, String title) {
        super(wizard, title);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        composite.setLayout((Layout)topLayout);
        this.createContents(composite);
        this.setControl((Control)composite);
    }

    public RMDataSource getDataSource() {
        return (RMDataSource)super.getDataSource();
    }

    public void initializeLocalHostCombo() {
        boolean enabled = this.getWidgetListener().isEnabled();
        this.getWidgetListener().disable();
        TreeSet<String> addrs = new TreeSet<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> alladdr = ni.getInetAddresses();
                while (alladdr.hasMoreElements()) {
                    InetAddress ip = alladdr.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    addrs.add(this.fixHostName(ip.getCanonicalHostName()));
                }
            }
        }
        catch (Exception exception) {}
        if (addrs.size() == 0) {
            addrs.add("localhost");
        }
        this.localAddrCombo.removeAll();
        int index = 0;
        int selection = -1;
        for (String addr : addrs) {
            this.localAddrCombo.add(addr);
            if (addr.equals(this.getDataSource().getLocalAddr())) {
                selection = index;
            }
            ++index;
        }
        if (selection < 0) {
            if (!this.getDataSource().getLocalAddr().equals(EMPTY_STRING)) {
                this.localAddrCombo.add(this.getDataSource().getLocalAddr());
            }
            selection = this.localAddrCombo.getItemCount() - 1;
        }
        this.localAddrCombo.select(selection);
        this.getWidgetListener().setEnabled(enabled);
    }

    public void updateControls() {
        boolean enabled = this.getWidgetListener().isEnabled();
        this.getWidgetListener().disable();
        boolean portFwd = this.getDataSource().getPortForward();
        IRemoteServices services = this.getRemoteServices(this.getDataSource().getRemoteServicesId());
        IRemoteConnection connection = this.getRemoteConnection(services, this.getDataSource().getConnectionName());
        boolean supportsPortForwarding = false;
        if (connection != null) {
            supportsPortForwarding = connection.supportsTCPPortForwarding();
        }
        if (this.localAddrCombo != null) {
            this.localAddrCombo.setEnabled(!portFwd);
        }
        if (this.portForwardingButton != null) {
            this.portForwardingButton.setEnabled(supportsPortForwarding);
            this.portForwardingButton.setSelection(supportsPortForwarding ? portFwd : false);
        }
        if (this.noneButton != null) {
            this.noneButton.setSelection(supportsPortForwarding ? !portFwd : true);
        }
        this.getWidgetListener().setEnabled(enabled);
    }

    private void createContents(Composite parent) {
        Composite remoteComp = new Composite(parent, 0);
        GridLayout remoteLayout = new GridLayout();
        remoteLayout.numColumns = 4;
        remoteLayout.marginWidth = 0;
        remoteComp.setLayout((Layout)remoteLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        remoteComp.setLayoutData((Object)gd);
        Label label = new Label(remoteComp, 0);
        label.setText(Messages.AbstractRemoteResourceManagerConfigurationWizardPage_0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.remoteCombo = new Combo(remoteComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.remoteCombo.setLayoutData((Object)gd);
        this.remoteCombo.addModifyListener((ModifyListener)this.getWidgetListener());
        label = new Label(remoteComp, 0);
        label.setText(Messages.AbstractRemoteResourceManagerConfigurationWizardPage_1);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.connectionCombo = new Combo(remoteComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.connectionCombo.setLayoutData((Object)gd);
        this.connectionCombo.addModifyListener((ModifyListener)this.getWidgetListener());
        this.newConnectionButton = SWTUtil.createPushButton((Composite)remoteComp, (String)Messages.AbstractRemoteResourceManagerConfigurationWizardPage_2, null);
        this.newConnectionButton.addSelectionListener((SelectionListener)this.getWidgetListener());
        Group mxGroup = new Group(parent, 16);
        mxGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        mxGroup.setLayoutData((Object)this.spanGridData(768, 2));
        mxGroup.setText(Messages.AbstractRemoteResourceManagerConfigurationWizardPage_3);
        this.noneButton = this.createRadioButton((Composite)mxGroup, Messages.AbstractRemoteResourceManagerConfigurationWizardPage_4, "mxGroup", this.listener);
        this.noneButton.addSelectionListener((SelectionListener)this.getWidgetListener());
        Composite addrComp = new Composite((Composite)mxGroup, 0);
        GridLayout addrLayout = new GridLayout();
        addrLayout.numColumns = 2;
        addrLayout.marginWidth = 0;
        addrLayout.marginLeft = 15;
        addrComp.setLayout((Layout)addrLayout);
        gd = new GridData(768);
        addrComp.setLayoutData((Object)gd);
        label = new Label(addrComp, 0);
        label.setText(Messages.AbstractRemoteResourceManagerConfigurationWizardPage_5);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.localAddrCombo = new Combo(addrComp, 4);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.localAddrCombo.setLayoutData((Object)gd);
        this.localAddrCombo.addModifyListener((ModifyListener)this.getWidgetListener());
        this.localAddrCombo.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.portForwardingButton = this.createRadioButton((Composite)mxGroup, Messages.AbstractRemoteResourceManagerConfigurationWizardPage_6, "mxGroup", this.listener);
        this.portForwardingButton.addSelectionListener((SelectionListener)this.getWidgetListener());
    }

    private String fixHostName(String hostname) {
        try {
            if (hostname.endsWith(".in-addr.arpa")) {
                return InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return hostname;
    }

    private void initializeRemoteServices() {
        if (this.fRemoteServices == null) {
            final ArrayList initializedServices = new ArrayList();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IRemoteServices[] services = PTPRemoteCorePlugin.getDefault().getAllRemoteServices();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)services.length);
                    try {
                        int i = 0;
                        while (i < services.length) {
                            IRemoteServices service = services[i];
                            progress.setTaskName(NLS.bind((String)Messages.AbstractRemoteResourceManagerConfigurationWizardPage_7, (Object)service.getName()));
                            while (!service.isInitialized() && !progress.isCanceled()) {
                                progress.setWorkRemaining(services.length - i);
                                1 var6_6 = this;
                                synchronized (var6_6) {
                                    this.wait(100L);
                                }
                                service.initialize();
                                progress.worked(1);
                            }
                            if (progress.isCanceled()) {
                                throw new InterruptedException();
                            }
                            initializedServices.add(service);
                            ++i;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                if (this.getControl().isVisible()) {
                    this.getContainer().run(true, true, runnable);
                } else {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                }
            }
            catch (InvocationTargetException e) {
                RMUIPlugin.log(e.getMessage());
            }
            catch (InterruptedException interruptedException) {}
            this.fRemoteServices = initializedServices.toArray(new IRemoteServices[0]);
            Arrays.sort(this.fRemoteServices, new Comparator<IRemoteServices>(){

                @Override
                public int compare(IRemoteServices c1, IRemoteServices c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
        }
    }

    protected WizardPageDataSource createDataSource() {
        return new RMDataSource(this);
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected WizardPageWidgetListener createListener() {
        return new WidgetListener();
    }

    protected Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected Composite doCreateContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        contents.setLayout((Layout)layout);
        this.createContents(contents);
        return contents;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected IRemoteConnection getRemoteConnection(IRemoteServices services, String name) {
        IRemoteConnectionManager manager = this.getRemoteConnectionManager(services);
        if (manager != null) {
            return manager.getConnection(name);
        }
        return null;
    }

    protected IRemoteConnectionManager getRemoteConnectionManager(IRemoteServices services) {
        if (services != null) {
            return services.getConnectionManager();
        }
        return null;
    }

    protected IRemoteServices getRemoteServices(String id) {
        if (id != null && !id.equals(EMPTY_STRING)) {
            return PTPRemoteCorePlugin.getDefault().getRemoteServices(id);
        }
        return null;
    }

    protected void handleConnectionSelected(String servicesId) {
        boolean enabled = this.getWidgetListener().isEnabled();
        this.getWidgetListener().disable();
        int currentSelection = this.connectionCombo.getSelectionIndex();
        IRemoteServices services = this.getRemoteServices(servicesId);
        if (currentSelection >= 0 && services != null) {
            String connectionName = this.connectionCombo.getItem(currentSelection);
            this.getDataSource().setConnectionName(connectionName);
        }
        this.getWidgetListener().setEnabled(enabled);
    }

    protected void handleNewRemoteConnectionSelected() {
        if (this.uiConnectionManager != null) {
            this.handleRemoteServiceSelected(this.uiConnectionManager.newConnection(this.getShell()));
        }
        this.resetErrorMessages();
        this.getDataSource().storeAndValidate();
        this.updateControls();
    }

    protected void handleRemoteServiceSelected(IRemoteConnection conn) {
        boolean enabled = this.getWidgetListener().isEnabled();
        this.getWidgetListener().disable();
        int selectionIndex = this.remoteCombo.getSelectionIndex();
        this.newConnectionButton.setEnabled(false);
        if (this.fRemoteServices != null && this.fRemoteServices.length > 0 && selectionIndex >= 0) {
            IRemoteServices remoteServices = this.fRemoteServices[selectionIndex];
            this.getDataSource().setRemoteServicesId(remoteServices.getId());
            IRemoteConnectionManager connectionManager = remoteServices.getConnectionManager();
            IRemoteUIServices remUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(remoteServices);
            if (remUIServices != null) {
                this.uiConnectionManager = remUIServices.getUIConnectionManager();
            }
            IRemoteConnection[] connections = connectionManager.getConnections();
            Arrays.sort(connections, new Comparator<IRemoteConnection>(){

                @Override
                public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
            this.connectionCombo.removeAll();
            int selected = 0;
            int i = 0;
            while (i < connections.length) {
                this.connectionCombo.add(connections[i].getName());
                if (conn != null && connections[i].equals(conn)) {
                    selected = i;
                }
                ++i;
            }
            this.newConnectionButton.setEnabled(this.uiConnectionManager != null);
            if (connections.length > 0) {
                this.connectionCombo.select(selected);
                this.handleConnectionSelected(remoteServices.getId());
            }
        }
        this.getWidgetListener().setEnabled(enabled);
    }

    protected String initializeRemoteServicesCombo(String id) {
        boolean enabled = this.getWidgetListener().isEnabled();
        this.getWidgetListener().disable();
        this.initializeRemoteServices();
        IRemoteServices defServices = id != null ? this.getRemoteServices(id) : PTPRemoteCorePlugin.getDefault().getDefaultServices();
        int defIndex = 0;
        this.remoteCombo.removeAll();
        int i = 0;
        while (i < this.fRemoteServices.length) {
            this.remoteCombo.add(this.fRemoteServices[i].getName());
            if (this.fRemoteServices[i].equals(defServices)) {
                defIndex = i;
            }
            ++i;
        }
        if (this.fRemoteServices.length > 0) {
            this.remoteCombo.select(defIndex);
        }
        this.getWidgetListener().setEnabled(enabled);
        return defServices.getId();
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected class RMDataSource
    extends WizardPageDataSource {
        private String fRemoteServicesId;
        private String fConnectionName;
        private boolean fPortForward;
        private String fLocalAddr;

        protected RMDataSource(AbstractConfigurationWizardPage page) {
            super(page);
            this.fRemoteServicesId = null;
            this.fConnectionName = null;
            this.fPortForward = true;
            this.fLocalAddr = null;
        }

        public String getConnectionName() {
            return this.fConnectionName;
        }

        public String getLocalAddr() {
            return this.fLocalAddr;
        }

        public boolean getPortForward() {
            return this.fPortForward;
        }

        public String getRemoteServicesId() {
            return this.fRemoteServicesId;
        }

        public void setConnectionName(String connName) {
            this.fConnectionName = connName;
        }

        public void setLocalAddr(String addr) {
            this.fLocalAddr = addr;
        }

        public void setPortForward(boolean portFwd) {
            this.fPortForward = portFwd;
        }

        public void setRemoteServicesId(String remServId) {
            this.fRemoteServicesId = remServId;
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            int index;
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.remoteCombo != null && AbstractRemoteResourceManagerConfigurationWizardPage.this.fRemoteServices != null && (index = AbstractRemoteResourceManagerConfigurationWizardPage.this.remoteCombo.getSelectionIndex()) >= 0 && index < AbstractRemoteResourceManagerConfigurationWizardPage.this.fRemoteServices.length) {
                this.fRemoteServicesId = AbstractRemoteResourceManagerConfigurationWizardPage.this.fRemoteServices[index].getId();
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionCombo != null) {
                this.fConnectionName = this.extractText(AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionCombo);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo != null) {
                this.fLocalAddr = this.extractText(AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton != null) {
                this.fPortForward = AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton.getSelection();
            }
        }

        protected void copyToFields() {
            IRemoteServices services = null;
            IRemoteConnection connection = null;
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo != null) {
                this.applyText(AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo, this.fLocalAddr);
            }
            if (this.fRemoteServicesId != null) {
                services = AbstractRemoteResourceManagerConfigurationWizardPage.this.getRemoteServices(this.fRemoteServicesId);
            }
            if (services != null && this.fConnectionName != null) {
                connection = AbstractRemoteResourceManagerConfigurationWizardPage.this.getRemoteConnection(services, this.fConnectionName);
            }
            AbstractRemoteResourceManagerConfigurationWizardPage.this.handleRemoteServiceSelected(connection);
            AbstractRemoteResourceManagerConfigurationWizardPage.this.updateControls();
        }

        protected void copyToStorage() {
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.remoteCombo != null) {
                this.getConfig().setRemoteServicesId(this.fRemoteServicesId);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionCombo != null) {
                this.getConfig().setConnectionName(this.fConnectionName);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo != null) {
                ((IRemoteResourceManagerConfiguration)this.getConfig()).setLocalAddress(this.fLocalAddr);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton != null) {
                int options = ((IRemoteResourceManagerConfiguration)this.getConfig()).getOptions();
                options = this.fPortForward ? (options |= 2) : (options &= 0xFFFFFFFD);
                ((IRemoteResourceManagerConfiguration)this.getConfig()).setOptions(options);
            }
        }

        protected void loadDefault() {
        }

        protected void loadFromStorage() {
            String id = this.getConfig().getRemoteServicesId();
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.remoteCombo != null) {
                this.fRemoteServicesId = AbstractRemoteResourceManagerConfigurationWizardPage.this.initializeRemoteServicesCombo(id);
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionCombo != null) {
                this.fConnectionName = this.getConfig().getConnectionName();
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo != null) {
                this.fLocalAddr = ((IRemoteResourceManagerConfiguration)this.getConfig()).getLocalAddress();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.initializeLocalHostCombo();
            }
            if (AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton != null) {
                boolean bl = this.fPortForward = (((IRemoteResourceManagerConfiguration)this.getConfig()).getOptions() & 2) == 2;
            }
            if (id == null) {
                this.copyToStorage();
            }
        }

        protected void validateGlobal() throws DataSource.ValidationException {
        }

        protected void validateLocal() throws DataSource.ValidationException {
        }
    }

    protected class WidgetListener
    extends WizardPageWidgetListener {
        protected WidgetListener() {
        }

        protected void doModifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.remoteCombo) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.handleRemoteServiceSelected(null);
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updateControls();
            } else if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.connectionCombo) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.handleConnectionSelected(AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().getRemoteServicesId());
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.updateControls();
            } else if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.resetErrorMessages();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else assert (false);
        }

        protected void doWidgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.newConnectionButton) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.handleNewRemoteConnectionSelected();
            } else if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.noneButton || source == AbstractRemoteResourceManagerConfigurationWizardPage.this.portForwardingButton) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.resetErrorMessages();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else if (source == AbstractRemoteResourceManagerConfigurationWizardPage.this.localAddrCombo) {
                AbstractRemoteResourceManagerConfigurationWizardPage.this.resetErrorMessages();
                AbstractRemoteResourceManagerConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else assert (false);
        }
    }
}

