/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

public final class PreservationRule {
    private int edgeTypeToPreserve;
    private boolean preserveIncoming;
    private boolean preserveOutgoing;

    public static final PreservationRule preserveIncoming(int edgeType) {
        return new PreservationRule(edgeType, true, false);
    }

    public static final PreservationRule preserveOutgoing(int edgeType) {
        return new PreservationRule(edgeType, false, true);
    }

    public static final PreservationRule preserveAll(int edgeType) {
        return new PreservationRule(edgeType, true, true);
    }

    private PreservationRule(int edgeType, boolean preserveIncoming, boolean preserveOutgoing) {
        this.edgeTypeToPreserve = edgeType;
        this.preserveIncoming = preserveIncoming;
        this.preserveOutgoing = preserveOutgoing;
    }

    public boolean definitelyShouldNotPreserve(boolean isIncoming, boolean isOutgoing, int edgeType) {
        return edgeType == this.edgeTypeToPreserve && isIncoming && isOutgoing;
    }

    public boolean shouldPreserve(boolean isIncoming, boolean isOutgoing, int edgeType) {
        if (edgeType != this.edgeTypeToPreserve) {
            return false;
        }
        if (isIncoming && isOutgoing) {
            return false;
        }
        if (isIncoming) {
            return this.preserveIncoming;
        }
        if (isOutgoing) {
            return this.preserveOutgoing;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Preserve ");
        if (this.preserveIncoming && this.preserveOutgoing) {
            sb.append("all");
        } else if (this.preserveIncoming) {
            sb.append("incoming");
        } else if (this.preserveOutgoing) {
            sb.append("outgoing");
        }
        sb.append(" edges of type ");
        sb.append(this.edgeTypeToPreserve);
        return sb.toString();
    }
}

