/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileExistsCache {
    private static final Content EMPTY_STRING_ARRAY = new Content(new String[0]);
    private static final boolean CASE_INSENSITIVE = new File("a").equals(new File("A"));
    private static boolean BYPASS_CACHE = Boolean.getBoolean("CDT_INDEXER_BYPASS_FILE_EXISTS_CACHE");
    private Reference<Map<String, Content>> fCache = new SoftReference(new HashMap());

    public boolean isFile(String path) {
        int idx;
        Content avail;
        File file = new File(path);
        if (BYPASS_CACHE) {
            return file.isFile();
        }
        String parent = file.getParent();
        if (parent == null) {
            return false;
        }
        String name = file.getName();
        if (CASE_INSENSITIVE) {
            name = name.toUpperCase();
        }
        if ((avail = this.getExistsCache().get(parent)) == null) {
            Object[] files = new File(parent).list();
            if (files == null || files.length == 0) {
                avail = EMPTY_STRING_ARRAY;
            } else {
                if (CASE_INSENSITIVE) {
                    int i = 0;
                    while (i < files.length) {
                        files[i] = ((String)files[i]).toUpperCase();
                        ++i;
                    }
                }
                Arrays.sort(files);
                avail = new Content((String[])files);
            }
            this.getExistsCache().put(parent, avail);
        }
        if ((idx = Arrays.binarySearch(avail.fNames, name)) < 0) {
            return false;
        }
        BitSet isFileBitset = avail.fIsFile;
        if (isFileBitset.get(idx *= 2)) {
            return true;
        }
        if (isFileBitset.get(idx + 1)) {
            return false;
        }
        if (file.isFile()) {
            isFileBitset.set(idx);
            return true;
        }
        isFileBitset.set(idx + 1);
        return false;
    }

    private Map<String, Content> getExistsCache() {
        Map<String, Content> cache = this.fCache.get();
        if (cache == null) {
            cache = new HashMap<String, Content>();
            this.fCache = new SoftReference<Map<String, Content>>(cache);
        }
        return cache;
    }

    private static class Content {
        public String[] fNames;
        public BitSet fIsFile;

        public Content(String[] names) {
            this.fNames = names;
            this.fIsFile = new BitSet(names.length * 2);
        }
    }
}

