/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring.infrastructure;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.rephraserengine.core.preservation.ResetOffsetLength;
import org.eclipse.rephraserengine.core.util.OffsetLength;

public class ASTNodeAdapterFactory
implements IAdapterFactory {
    private static final OffsetLength EMPTY_OFFSET_LENGTH = new OffsetLength(-1, 0);

    public Class[] getAdapterList() {
        return new Class[]{OffsetLength.class, ResetOffsetLength.class};
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!IASTNode.class.isAssignableFrom(adaptableObject.getClass())) {
            return null;
        }
        IASTNode node = (IASTNode)adaptableObject;
        if (adapterType.equals(OffsetLength.class)) {
            return this.getOffsetLength(node, this.findRoot(node));
        }
        if (adapterType.equals(ResetOffsetLength.class)) {
            return this.reset(node);
        }
        return null;
    }

    private ResetOffsetLength reset(IASTNode node) {
        node.accept(new GenericASTVisitor(){

            public void visitToken(Token token) {
                token.setFileOffset(-1);
            }
        });
        return ResetOffsetLength.RESET;
    }

    private IASTNode findRoot(IASTNode node) {
        IASTNode root = node;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    private OffsetLength getOffsetLength(IASTNode node, IASTNode inAST) {
        Token first = node.findFirstToken();
        Token last = node.findLastToken();
        if (first == null || last == null) {
            return EMPTY_OFFSET_LENGTH;
        }
        Token previous = this.findLastTokenBefore(first, inAST);
        int offset = previous == null ? 0 : previous.getFileOffset() + previous.getLength() + previous.getWhiteAfter().length();
        int length = node.toString().length();
        return new OffsetLength(offset, length);
    }

    private Token findLastTokenBefore(Token target, IASTNode inAST) {
        class TokenFinder
        extends GenericASTVisitor {
            private Token lastToken = null;
            private Token result = null;
            private final /* synthetic */ Token val$target;

            TokenFinder(Token token) {
                this.val$target = token;
            }

            public void visitToken(Token thisToken) {
                if (thisToken == this.val$target) {
                    this.result = this.lastToken;
                }
                if (thisToken.getFileOffset() >= 0) {
                    this.lastToken = thisToken;
                }
            }
        }
        TokenFinder t = new TokenFinder(target);
        inAST.accept(t);
        return t.result;
    }
}

