/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Util {
    private static final int DEFAULT_READING_SIZE = 8192;
    public static HashSet<File> existingExternalFiles = new HashSet();

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block7: {
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    /*
     * Loose catch block
     */
    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        char[] cArray;
        InputStream stream;
        block11: {
            stream = null;
            stream = new BufferedInputStream(new FileInputStream(file));
            cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
            if (stream == null) break block11;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return cArray;
        catch (OutOfMemoryError outOfMemoryError) {
            block12: {
                try {
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = CharOperation.NO_CHAR;
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        File externalFile = new File(path.toOSString());
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (existingExternalFiles.contains(externalFile)) {
            return externalFile;
        }
        if (externalFile.exists()) {
            existingExternalFiles.add(externalFile);
            return externalFile;
        }
        return null;
    }

    public static final boolean isExcluded(IResource resource, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2) {
            path = path.append("*");
        }
        return Util.isExcluded(path, exclusionPatterns);
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        char[][] cArray = exclusionPatterns;
        int n = exclusionPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            char[] exclusionPattern = cArray[n2];
            if (CharOperation.pathMatch((char[])exclusionPattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IStatus createStatus(Throwable t) {
        String msg = t.getMessage();
        if (msg == null) {
            msg = Messages.Util_unexpectedError;
        }
        return new Status(4, "org.eclipse.cdt.core", 0, msg, t);
    }
}

