/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassSpecialization
extends PDOMCPPSpecialization
implements ICPPClassSpecialization,
IPDOMMemberOwner,
IPDOMCPPClassType {
    private static final int FIRSTBASE = 40;
    private static final int MEMBERLIST = 44;
    protected static final int RECORD_SIZE = 48;
    private ICPPClassScope fScope;
    private ObjectMap specializationMap = null;

    public PDOMCPPClassSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPClassType classType, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)classType), specialized);
    }

    public PDOMCPPClassSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 48;
    }

    public int getNodeType() {
        return 37;
    }

    public ICPPClassType getSpecializedBinding() {
        return (ICPPClassType)super.getSpecializedBinding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinding specializeMember(IBinding original) {
        Object key;
        if (this.specializationMap == null) {
            key = this.record + 3L;
            Object cached = this.getPDOM().getCachedResult(key);
            if (cached != null) {
                this.specializationMap = (ObjectMap)cached;
            } else {
                ObjectMap newMap = new ObjectMap(2);
                try {
                    ICPPClassType[] nested;
                    PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
                    PDOMCPPClassScope.acceptViaCache(this, visitor, false);
                    ICPPClassType[] iCPPClassTypeArray = nested = visitor.getNestedClasses();
                    int n = nested.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPClassType classType = iCPPClassTypeArray[n2];
                        if (classType instanceof ICPPSpecialization) {
                            newMap.put(((ICPPSpecialization)((Object)classType)).getSpecializedBinding(), classType);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log((Throwable)e);
                }
                this.specializationMap = (ObjectMap)this.getPDOM().putCachedResult(key, newMap, false);
            }
        }
        key = this.specializationMap;
        synchronized (key) {
            IBinding result = (IBinding)this.specializationMap.get(original);
            if (result != null) {
                return result;
            }
        }
        IBinding newSpec = CPPTemplates.createSpecialization(this, original);
        ObjectMap objectMap = this.specializationMap;
        synchronized (objectMap) {
            IBinding oldSpec = (IBinding)this.specializationMap.put(original, newSpec);
            if (oldSpec != null) {
                this.specializationMap.put(original, oldSpec);
                return oldSpec;
            }
        }
        return newSpec;
    }

    public ICPPClassScope getCompositeScope() {
        if (this.fScope == null) {
            try {
                if (this.hasDefinition()) {
                    this.fScope = new PDOMCPPClassScope(this);
                    return this.fScope;
                }
            }
            catch (CoreException coreException) {}
            this.fScope = new PDOMCPPClassSpecializationScope(this);
        }
        return this.fScope;
    }

    public PDOMCPPBase getFirstBase() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 40L);
        return rec != 0L ? new PDOMCPPBase((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        long rec = base != null ? base.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 40L, rec);
    }

    public void addBase(PDOMCPPBase base) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        PDOMCPPBase firstBase = this.getFirstBase();
        base.setNextBase(firstBase);
        this.setFirstBase(base);
    }

    public void removeBase(PDOMName pdomName) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase predecessor = null;
        long nameRec = pdomName.getRecord();
        while (base != null) {
            PDOMName name = base.getBaseClassSpecifierName();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = base;
            base = base.getNextBase();
        }
        if (base != null) {
            if (predecessor != null) {
                predecessor.setNextBase(base.getNextBase());
            } else {
                this.setFirstBase(base.getNextBase());
            }
            base.delete();
        }
    }

    public ICPPBase[] getBases() throws DOMException {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getBases();
        }
        Long key = this.record + 1L;
        ICPPBase[] bases = (ICPPBase[])this.getPDOM().getCachedResult(key);
        if (bases != null) {
            return bases;
        }
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Collections.reverse(list);
            bases = list.toArray(new ICPPBase[list.size()]);
            this.getPDOM().putCachedResult(key, bases);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getConstructors();
        }
        try {
            PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getConstructors();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getDeclaredMethods();
        }
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            PDOMCPPClassScope.acceptViaCache(this, methods, false);
            return methods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getDeclaredFields();
        }
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPField.EMPTY_CPPFIELD_ARRAY;
        }
    }

    public ICPPClassType[] getNestedClasses() throws DOMException {
        ICPPClassScope scope = this.getCompositeScope();
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getNestedClasses();
        }
        try {
            PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return ICPPClassType.EMPTY_CLASS_ARRAY;
        }
    }

    public IBinding[] getFriends() throws DOMException {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public ICPPMethod[] getMethods() throws DOMException {
        return ClassTypeHelper.getMethods(this);
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        return ClassTypeHelper.getAllDeclaredMethods(this);
    }

    public IField[] getFields() throws DOMException {
        return ClassTypeHelper.getFields(this);
    }

    public IField findField(String name) throws DOMException {
        return ClassTypeHelper.findField(this, name);
    }

    public int getKey() throws DOMException {
        return this.getSpecializedBinding().getKey();
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (!(type instanceof ICPPClassSpecialization)) {
            return false;
        }
        return CPPClassSpecialization.isSameClassSpecialization(this, (ICPPClassSpecialization)type);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void addChild(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 44L);
        list.addMember(member);
    }

    public void acceptUncached(IPDOMVisitor visitor) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 44L);
        list.accept(visitor);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPClassScope.acceptViaCache(this, visitor, false);
    }

    public boolean isAnonymous() {
        return false;
    }
}

