/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.debug.core.model.IPAddressBreakpoint;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPFunctionBreakpoint;
import org.eclipse.ptp.debug.core.model.IPWatchpoint;
import org.eclipse.ptp.debug.internal.ui.propertypages.PBreakpointPreferenceStore;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.UIDebugManager;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBreakpointPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private BooleanFieldEditor enabled;
    private BreakpointStringFieldEditor condition;
    private Text ignoreCountTextControl;
    private BreakpointIntegerFieldEditor ignoreCount;
    private IAdaptable element;
    private final PBreakpointPreferenceStore pBreakpointPreferenceStore;
    private UIDebugManager uiDebugManager = null;

    public PBreakpointPropertyPage() {
        super(1);
        this.noDefaultAndApplyButton();
        this.uiDebugManager = PTPDebugUIPlugin.getUIDebugManager();
        this.pBreakpointPreferenceStore = new PBreakpointPreferenceStore();
    }

    protected void createFieldEditors() {
        IPBreakpoint breakpoint = this.getBreakpoint();
        try {
            this.createTypeSpecificLabelFieldEditors(breakpoint);
            this.createEnabledField(this.getFieldEditorParent());
            IPreferenceStore store = this.getPreferenceStore();
            String condition = breakpoint.getCondition();
            if (condition == null) {
                condition = "";
            }
            store.setValue("CONDITION", condition);
            this.createConditionEditor(this.getFieldEditorParent());
            store.setValue("ENABLED", breakpoint.isEnabled());
            int ignoreCount = breakpoint.getIgnoreCount();
            store.setValue("IGNORE_COUNT", ignoreCount >= 0 ? ignoreCount : 0);
            this.createIgnoreCountEditor(this.getFieldEditorParent());
        }
        catch (CoreException ce) {
            PTPDebugUIPlugin.errorDialog(this.getShell(), Messages.PBreakpointPropertyPage_2, "", ce);
        }
    }

    private void createTypeSpecificLabelFieldEditors(IPBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof IPFunctionBreakpoint) {
            IPFunctionBreakpoint funcBpt = (IPFunctionBreakpoint)breakpoint;
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_4, Messages.PBreakpointPropertyPage_5));
            String function = funcBpt.getFunction();
            if (function != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_6, function));
            }
        } else if (breakpoint instanceof IPAddressBreakpoint) {
            IPAddressBreakpoint addrBpt = (IPAddressBreakpoint)breakpoint;
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_7, Messages.PBreakpointPropertyPage_8));
            String address = addrBpt.getAddress();
            if (address != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_9, address));
            }
        } else if (breakpoint instanceof IPWatchpoint) {
            IPWatchpoint watchpoint = (IPWatchpoint)breakpoint;
            String type = "";
            type = watchpoint.isReadType() && !watchpoint.isWriteType() ? Messages.PBreakpointPropertyPage_11 : (!watchpoint.isReadType() && watchpoint.isWriteType() ? Messages.PBreakpointPropertyPage_12 : Messages.PBreakpointPropertyPage_13);
            String expression = watchpoint.getExpression();
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_14, type));
            String projectName = breakpoint.getMarker().getResource().getLocation().toOSString();
            if (projectName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_15, projectName));
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_16, expression));
        } else if (breakpoint instanceof ILineBreakpoint) {
            ILineBreakpoint lineBpt;
            int lineNumber;
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_17, Messages.PBreakpointPropertyPage_18));
            String fileName = breakpoint.getSourceHandle();
            if (fileName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_19, fileName));
            }
            if ((lineNumber = (lineBpt = (ILineBreakpoint)breakpoint).getLineNumber()) > 0) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_20, String.valueOf(lineNumber)));
            }
        }
        String job_id = breakpoint.getJobId();
        String jobName = breakpoint.getJobName();
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_21, jobName));
        String set_id = breakpoint.getSetId();
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_22, set_id));
        if (!job_id.equals(IPBreakpoint.GLOBAL)) {
            IElementHandler setManager = this.uiDebugManager.getElementHandler(job_id);
            IElementSet elementSet = (IElementSet)setManager.getElementByID(set_id);
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_23, String.valueOf(elementSet.size())));
            String[] setNames = elementSet.getMatchSetIDs();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < setNames.length) {
                buffer.append(setNames[i]);
                if (i < setNames.length - 1) {
                    buffer.append(",");
                }
                ++i;
            }
            if (buffer.length() > 0) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PBreakpointPropertyPage_25, buffer.toString()));
            }
        }
    }

    protected void createEnabledField(Composite parent) {
        this.enabled = new BooleanFieldEditor("ENABLED", Messages.PBreakpointPropertyPage_26, parent);
        this.addField((FieldEditor)this.enabled);
    }

    protected void createConditionEditor(Composite parent) {
        this.condition = new BreakpointStringFieldEditor("CONDITION", Messages.PBreakpointPropertyPage_27, parent);
        this.condition.setEmptyStringAllowed(true);
        this.condition.setErrorMessage(Messages.PBreakpointPropertyPage_28);
        this.addField((FieldEditor)this.condition);
    }

    protected void createIgnoreCountEditor(Composite parent) {
        this.ignoreCount = new BreakpointIntegerFieldEditor("IGNORE_COUNT", Messages.PBreakpointPropertyPage_29, parent);
        this.ignoreCount.setValidRange(0, Integer.MAX_VALUE);
        this.ignoreCountTextControl = this.ignoreCount.getTextControl(parent);
        try {
            this.ignoreCountTextControl.setEnabled(this.getBreakpoint().getIgnoreCount() >= 0);
        }
        catch (CoreException ce) {
            PTPDebugUIPlugin.log(ce);
        }
        this.addField((FieldEditor)this.ignoreCount);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title, String value) {
        return new LabelFieldEditor(parent, title, value);
    }

    protected IPBreakpoint getBreakpoint() {
        IAdaptable element = this.getElement();
        return element instanceof IPBreakpoint ? (IPBreakpoint)element : null;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.pBreakpointPreferenceStore;
    }

    public boolean performOk() {
        final ArrayList<String> changedProperties = new ArrayList<String>(5);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                changedProperties.add(event.getProperty());
            }
        });
        boolean result = super.performOk();
        this.setBreakpointProperties(changedProperties);
        return result;
    }

    protected void setBreakpointProperties(final List<String> changedProperties) {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IPBreakpoint breakpoint = PBreakpointPropertyPage.this.getBreakpoint();
                for (String property : changedProperties) {
                    if (property.equals("ENABLED")) {
                        breakpoint.setEnabled(PBreakpointPropertyPage.this.getPreferenceStore().getBoolean("ENABLED"));
                        continue;
                    }
                    if (property.equals("IGNORE_COUNT")) {
                        breakpoint.setIgnoreCount(PBreakpointPropertyPage.this.getPreferenceStore().getInt("IGNORE_COUNT"));
                        continue;
                    }
                    if (!property.equals("CONDITION")) continue;
                    breakpoint.setCondition(PBreakpointPropertyPage.this.getPreferenceStore().getString("CONDITION"));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException ce) {
            PTPDebugUIPlugin.log(ce);
        }
    }

    class BreakpointIntegerFieldEditor
    extends IntegerFieldEditor {
        public BreakpointIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage(Messages.PBreakpointPropertyPage_0);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointStringFieldEditor
    extends StringFieldEditor {
        public BreakpointStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private Label titleLabel;
        private Label valueLabel;
        private Composite basicComposite;
        private final String value;
        private final String title;

        public LabelFieldEditor(Composite parent, String title, String value) {
            this.value = value;
            this.title = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.basicComposite.getLayoutData()).horizontalSpan = numColumns;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.basicComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            this.basicComposite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            this.basicComposite.setLayoutData((Object)data);
            this.titleLabel = new Label(this.basicComposite, 0);
            this.titleLabel.setText(this.title);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            this.titleLabel.setLayoutData((Object)gd);
            this.valueLabel = new Label(this.basicComposite, 64);
            this.valueLabel.setText(this.value);
            gd = new GridData();
            this.valueLabel.setLayoutData((Object)gd);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

