/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import java.util.Observable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIEventRequestManager;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStopDebuggerRequest;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public class EventRequestManager
extends AbstractPDIManager
implements IPDIEventRequestManager {
    private final EventRequestDispatchJob dispatchJob = new EventRequestDispatchJob();

    public EventRequestManager(IPDISession session) {
        super(session, false);
    }

    public void addEventRequest(IPDIEventRequest request) throws PDIException {
        if (!(request instanceof IPDIStopDebuggerRequest)) {
            if (request.getTasks().isEmpty()) {
                throw new PDIException(request.getTasks(), NLS.bind((String)Messages.EventRequestManager_5, (Object)request.getName()));
            }
            if (this.session.getTaskManager().isAllPending(request.getTasks())) {
                throw new PDIException(request.getTasks(), NLS.bind((String)Messages.EventRequestManager_6, (Object)request.getName()));
            }
            if (this.session.getStatus() == 4 || this.session.getStatus() == 5) {
                throw new PDIException(request.getTasks(), Messages.EventRequestManager_7);
            }
        }
        this.dispatchJob.addEventRequest(request);
    }

    public boolean canExecute(IPDIEventRequest request) {
        return true;
    }

    public void cleanEventRequests() {
        this.session.getEventManager().removeAllRegisteredEventRequests();
        this.dispatchJob.cleanEventRequests();
    }

    public void deleteAllEventRequests() throws PDIException {
        this.dispatchJob.removeEventRequests();
    }

    public void deleteEventRequest(IPDIEventRequest request) throws PDIException {
        this.dispatchJob.removeEventRequest(request);
    }

    public void execute(IPDIEventRequest request) {
        if (request != null) {
            this.session.getEventManager().registerEventRequest(request);
            request.execute(this.session.getDebugger());
            if (request.getStatus() == 1) {
                this.session.getEventManager().notifyEventRequest(request);
            }
        }
    }

    public IPDIEventRequest[] getRequests() {
        return this.dispatchJob.getEventRequests();
    }

    public void shutdown() {
    }

    public void update(TaskSet tasks) throws PDIException {
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof IPDIEventRequest) {
            this.dispatchJob.removeCurrentEventRequest();
        }
    }

    public class EventRequestDispatchJob
    extends Job {
        private Vector<IPDIEventRequest> fRequests;

        public EventRequestDispatchJob() {
            super(Messages.EventRequestManager_0);
            this.fRequests = null;
            this.setSystem(true);
            this.fRequests = new Vector(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEventRequest(IPDIEventRequest request) throws PDIException {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                if (this.containEventRequest(request)) {
                    throw new PDIException(request.getTasks(), NLS.bind((String)Messages.EventRequestManager_1, (Object)request.getName()));
                }
                PDebugUtils.println(NLS.bind((String)Messages.EventRequestManager_2, (Object)request));
                this.fRequests.add(request);
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanEventRequests() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                int end;
                int i = end = this.fRequests.size() - 1;
                while (i >= 0) {
                    IPDIEventRequest request = this.fRequests.get(i);
                    if (request != null && request.getStatus() != 2) {
                        request.cancel();
                        request.done();
                        this.fRequests.remove(i);
                    }
                    --i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containEventRequest(IPDIEventRequest request) {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                return this.fRequests.contains(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPDIEventRequest getCurrentEventRequest() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                block4: {
                    if (!this.fRequests.isEmpty()) break block4;
                    return null;
                }
                return this.fRequests.get(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPDIEventRequest[] getEventRequests() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                return this.fRequests.toArray(new IPDIEventRequest[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCurrentEventRequest() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                if (!this.fRequests.isEmpty()) {
                    this.fRequests.remove(0);
                }
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEventRequest(IPDIEventRequest request) throws PDIException {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                if (request.getStatus() == 2) {
                    throw new PDIException(request.getTasks(), NLS.bind((String)Messages.EventRequestManager_3, (Object)request.getName()));
                }
                if (!this.containEventRequest(request)) {
                    throw new PDIException(request.getTasks(), NLS.bind((String)Messages.EventRequestManager_4, (Object)request.getName()));
                }
                this.fRequests.remove(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEventRequests() throws PDIException {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                int end;
                int i = end = this.fRequests.size() - 1;
                while (i >= 0) {
                    this.removeEventRequest(this.fRequests.get(i));
                    --i;
                }
            }
        }

        public IStatus run(IProgressMonitor monitor) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    PTPDebugCorePlugin.log(exception);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws Exception {
                    IPDIEventRequest request = null;
                    Vector vector = EventRequestDispatchJob.this.fRequests;
                    synchronized (vector) {
                        request = EventRequestDispatchJob.this.getCurrentEventRequest();
                        request.setStatus(2);
                    }
                    EventRequestManager.this.execute(request);
                }
            });
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                return !this.fRequests.isEmpty() && this.getCurrentEventRequest().getStatus() == 5;
            }
        }
    }
}

