/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;

public class CPPASTSimpleDeclSpecifier
extends CPPASTBaseDeclSpecifier
implements ICPPASTSimpleDeclSpecifier,
IASTAmbiguityParent {
    private int type;
    private boolean isSigned;
    private boolean isUnsigned;
    private boolean isShort;
    private boolean isLong;
    private boolean isLonglong;
    private boolean isComplex = false;
    private boolean isImaginary = false;
    private IASTExpression fDeclTypeExpression;

    public CPPASTSimpleDeclSpecifier copy() {
        CPPASTSimpleDeclSpecifier copy = new CPPASTSimpleDeclSpecifier();
        this.copySimpleDeclSpec(copy);
        return copy;
    }

    protected void copySimpleDeclSpec(CPPASTSimpleDeclSpecifier other) {
        this.copyBaseDeclSpec(other);
        other.type = this.type;
        other.isSigned = this.isSigned;
        other.isUnsigned = this.isUnsigned;
        other.isShort = this.isShort;
        other.isLong = this.isLong;
        other.isLonglong = this.isLonglong;
        other.isComplex = this.isComplex;
        other.isImaginary = this.isImaginary;
        if (this.fDeclTypeExpression != null) {
            other.setDeclTypeExpression(this.fDeclTypeExpression.copy());
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.assertNotFrozen();
        this.type = type;
    }

    public void setType(IBasicType.Kind kind) {
        this.setType(this.getType(kind));
    }

    private int getType(IBasicType.Kind kind) {
        switch (kind) {
            case eBoolean: {
                return 6;
            }
            case eChar: {
                return 2;
            }
            case eWChar: {
                return 7;
            }
            case eChar16: {
                return 11;
            }
            case eChar32: {
                return 12;
            }
            case eDouble: {
                return 5;
            }
            case eFloat: {
                return 4;
            }
            case eInt: {
                return 3;
            }
            case eUnspecified: {
                return 0;
            }
            case eVoid: {
                return 1;
            }
        }
        return 0;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isLongLong() {
        return this.isLonglong;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public boolean isImaginary() {
        return this.isImaginary;
    }

    public IASTExpression getDeclTypeExpression() {
        return this.fDeclTypeExpression;
    }

    public void setSigned(boolean value) {
        this.assertNotFrozen();
        this.isSigned = value;
    }

    public void setUnsigned(boolean value) {
        this.assertNotFrozen();
        this.isUnsigned = value;
    }

    public void setLong(boolean value) {
        this.assertNotFrozen();
        this.isLong = value;
    }

    public void setShort(boolean value) {
        this.assertNotFrozen();
        this.isShort = value;
    }

    public void setLongLong(boolean value) {
        this.assertNotFrozen();
        this.isLonglong = value;
    }

    public void setComplex(boolean value) {
        this.assertNotFrozen();
        this.isComplex = value;
    }

    public void setImaginary(boolean value) {
        this.assertNotFrozen();
        this.isImaginary = value;
    }

    public void setDeclTypeExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fDeclTypeExpression = expression;
        if (expression != null) {
            expression.setPropertyInParent(DECLTYPE_EXPRESSION);
            expression.setParent(this);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fDeclTypeExpression != null && !this.fDeclTypeExpression.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fDeclTypeExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fDeclTypeExpression = (IASTExpression)other;
        }
    }
}

