/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTUsingDirective
extends ASTNode
implements ICPPASTUsingDirective,
IASTCompletionContext {
    private IASTName name;

    public CPPASTUsingDirective() {
    }

    public CPPASTUsingDirective(IASTName name) {
        this.setQualifiedName(name);
    }

    public CPPASTUsingDirective copy() {
        CPPASTUsingDirective copy = new CPPASTUsingDirective(this.name == null ? null : this.name.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTName getQualifiedName() {
        return this.name;
    }

    public void setQualifiedName(IASTName qualifiedName) {
        this.assertNotFrozen();
        this.name = qualifiedName;
        if (qualifiedName != null) {
            qualifiedName.setParent(this);
            qualifiedName.setPropertyInParent(QUALIFIED_NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i] instanceof ICPPNamespace) {
                filtered.add(bindings[i]);
            }
            ++i;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }
}

