/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPPPointerType
implements IPointerType,
ITypeContainer,
ISerializableType {
    protected IType type = null;
    private boolean isConst = false;
    private boolean isVolatile = false;

    public CPPPointerType(IType type, IASTPointer operator) {
        this.type = type;
        this.isConst = operator.isConst();
        this.isVolatile = operator.isVolatile();
    }

    public CPPPointerType(IType type, boolean isConst, boolean isVolatile) {
        this.type = type;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
    }

    public CPPPointerType(IType type) {
        this.type = type;
    }

    public IType stripQualifiers() {
        CPPPointerType result = this;
        if (this.isConst || this.isVolatile) {
            result = (CPPPointerType)this.clone();
            result.isConst = false;
            result.isVolatile = false;
        }
        return result;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof IPointerType)) {
            return false;
        }
        if (this instanceof ICPPPointerToMemberType != o instanceof ICPPPointerToMemberType) {
            return false;
        }
        if (this.type == null) {
            return false;
        }
        IPointerType pt = (IPointerType)o;
        if (this.isConst == pt.isConst() && this.isVolatile == pt.isVolatile()) {
            return this.type.isSameType(pt.getType());
        }
        return false;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int firstByte = 2;
        if (this.isConst()) {
            firstByte |= 0x10;
        }
        if (this.isVolatile()) {
            firstByte |= 0x20;
        }
        buffer.putByte((byte)firstByte);
        IType nestedType = this.getType();
        buffer.marshalType(nestedType);
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CPPPointerType(nested, (firstByte & 0x10) != 0, (firstByte & 0x20) != 0);
    }
}

