/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemTypeId;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAmbiguousTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpandable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStaticAssertDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTPointer;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTPointerToMember;
import org.eclipse.cdt.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.AbstractGNUSourceCodeParser;
import org.eclipse.cdt.internal.core.dom.parser.BacktrackException;
import org.eclipse.cdt.internal.core.dom.parser.DeclarationOptions;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguityResolver;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousBinaryVsCastExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousCastVsFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousCondition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNodeFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GNUCPPSourceParser
extends AbstractGNUSourceCodeParser {
    private static final int DEFAULT_PARM_LIST_SIZE = 4;
    private static final int DEFAULT_CATCH_HANDLER_LIST_SIZE = 4;
    private final boolean allowCPPRestrict;
    private final boolean supportExtendedTemplateSyntax;
    private final boolean supportAutoTypeSpecifier;
    private final IIndex index;
    protected ICPPASTTranslationUnit translationUnit;
    private int functionBodyCount = 0;
    private char[] currentClassName;
    private final ICPPNodeFactory nodeFactory;
    private boolean fInTemplateParameterList;
    private static final int INLINE = 1;
    private static final int CONST = 2;
    private static final int RESTRICT = 4;
    private static final int VOLATILE = 8;
    private static final int SHORT = 16;
    private static final int UNSIGNED = 32;
    private static final int SIGNED = 64;
    private static final int COMPLEX = 128;
    private static final int IMAGINARY = 256;
    private static final int VIRTUAL = 512;
    private static final int EXPLICIT = 1024;
    private static final int FRIEND = 2048;
    private static final int FORBID_IN_EMPTY_DECLSPEC = 2558;

    public GNUCPPSourceParser(IScanner scanner, ParserMode mode, IParserLogService log, ICPPParserExtensionConfiguration config) {
        this(scanner, mode, log, config, null);
    }

    public GNUCPPSourceParser(IScanner scanner, ParserMode mode, IParserLogService log, ICPPParserExtensionConfiguration config, IIndex index) {
        super(scanner, log, mode, CPPNodeFactory.getDefault(), config.supportStatementsInExpressions(), config.supportTypeofUnaryExpressions(), config.supportAlignOfUnaryExpression(), config.supportKnRC(), config.supportAttributeSpecifiers(), config.supportDeclspecSpecifiers(), config.getBuiltinBindingsProvider());
        this.allowCPPRestrict = config.allowRestrictPointerOperators();
        this.supportExtendedTemplateSyntax = config.supportExtendedTemplateSyntax();
        this.supportParameterInfoBlock = config.supportParameterInfoBlock();
        this.supportExtendedSizeofOperator = config.supportExtendedSizeofOperator();
        this.supportFunctionStyleAsm = config.supportFunctionStyleAssembler();
        this.functionCallCanBeLValue = true;
        this.supportAutoTypeSpecifier = true;
        this.index = index;
        this.nodeFactory = CPPNodeFactory.getDefault();
        scanner.setSplitShiftROperator(true);
    }

    @Override
    protected IASTName identifier() throws EndOfFileException, BacktrackException {
        switch (this.LT(1)) {
            case 1: 
            case 140: 
            case 141: {
                return this.buildName(-1, this.consume());
            }
        }
        throw this.backtrack;
    }

    private IASTName qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx ctx) throws BacktrackException, EndOfFileException {
        int offset;
        ICPPASTQualifiedName qname = null;
        IASTName name = null;
        int endOffset = offset = this.LA(1).getOffset();
        if (this.LT(1) == 3) {
            endOffset = this.consume().getEndOffset();
            qname = this.nodeFactory.newQualifiedName();
            qname.setFullyQualified(true);
        }
        boolean mustBeLast = false;
        boolean haveName = false;
        block4: while (true) {
            boolean forceTemplate = false;
            if (qname != null && this.LT(1) == 111) {
                this.consume();
                forceTemplate = true;
            }
            int destructorOffset = -1;
            if (this.LT(1) == 34) {
                destructorOffset = this.consume().getOffset();
                mustBeLast = true;
            }
            switch (this.LT(1)) {
                case 1: 
                case 140: 
                case 141: {
                    IToken nt = this.consume();
                    name = this.buildName(destructorOffset, nt);
                    break;
                }
                case 95: {
                    name = this.operatorId();
                    break;
                }
                default: {
                    if (!haveName || destructorOffset >= 0 || forceTemplate) {
                        this.throwBacktrack(this.LA(1));
                    }
                    name = this.nodeFactory.newName(CharArrayUtils.EMPTY);
                    if (qname == null) break block4;
                    qname.addName(name);
                    break block4;
                }
            }
            haveName = true;
            name = this.addTemplateArguments(name, ctx);
            endOffset = this.calculateEndOffset(name);
            if (qname != null) {
                qname.addName(name);
            }
            if (this.LTcatchEOF(1) != 3) break;
            if (mustBeLast) {
                this.throwBacktrack(this.LA(1));
            }
            endOffset = this.consume().getEndOffset();
            if (qname != null) continue;
            qname = this.nodeFactory.newQualifiedName();
            qname.addName(name);
        }
        if (qname == null) {
            return name;
        }
        this.setRange(qname, offset, endOffset);
        return qname;
    }

    private IASTName buildName(int destructorOffset, IToken nt) {
        IASTName name;
        if (destructorOffset < 0) {
            name = this.nodeFactory.newName(nt.getCharImage());
            this.setRange(name, nt.getOffset(), nt.getEndOffset());
        } else {
            char[] nchars = nt.getCharImage();
            int len = nchars.length;
            char[] image = new char[len + 1];
            image[0] = 126;
            System.arraycopy(nchars, 0, image, 1, len);
            name = this.nodeFactory.newName(image);
            this.setRange(name, destructorOffset, nt.getEndOffset());
        }
        switch (nt.getType()) {
            case 140: 
            case 141: {
                this.createCompletionNode(nt).addName(name);
            }
        }
        return name;
    }

    private IASTName addTemplateArguments(IASTName templateName, AbstractGNUSourceCodeParser.CastExprCtx ctx) throws EndOfFileException, BacktrackException {
        boolean isAmbiguous = false;
        switch (this.canBeTemplateArguments(ctx)) {
            case -1: {
                return templateName;
            }
            case 0: {
                isAmbiguous = true;
            }
        }
        IToken secondMark = this.mark();
        this.consume(42);
        try {
            List<IASTNode> list = this.templateArgumentList(isAmbiguous);
            IToken end = this.LA(1);
            switch (end.getType()) {
                case 46: 
                case 5201: {
                    this.consume();
                    break;
                }
                case 141: {
                    break;
                }
                default: {
                    throw this.backtrack;
                }
            }
            return this.buildTemplateID(templateName, end.getEndOffset(), list);
        }
        catch (BacktrackException backtrackException) {
            this.backup(secondMark);
            return templateName;
        }
    }

    private ICPPASTTemplateId buildTemplateID(IASTName templateName, int endOffset, List<IASTNode> args) {
        ICPPASTTemplateId result = this.nodeFactory.newTemplateId(templateName);
        this.setRange(result, ((ASTNode)((Object)templateName)).getOffset(), endOffset);
        for (IASTNode n : args) {
            if (n instanceof IASTTypeId) {
                result.addTemplateArgument((IASTTypeId)n);
                continue;
            }
            if (n instanceof IASTExpression) {
                result.addTemplateArgument((IASTExpression)n);
                continue;
            }
            if (!(n instanceof ICPPASTAmbiguousTemplateArgument)) continue;
            result.addTemplateArgument((ICPPASTAmbiguousTemplateArgument)n);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int canBeTemplateArguments(AbstractGNUSourceCodeParser.CastExprCtx ctx) throws EndOfFileException, BacktrackException {
        if (this.LTcatchEOF(1) != 42) {
            return -1;
        }
        IToken mark = this.mark();
        try {
            this.consume();
            int nk = 0;
            int depth = 0;
            int angleDepth = 0;
            int limit = 10000;
            block24: while (--limit > 0) {
                switch (this.consume().getType()) {
                    case 140: 
                    case 141: {
                        int n = ctx == AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr ? 0 : -1;
                        return n;
                    }
                    case 42: {
                        if (nk != 0) break;
                        ++angleDepth;
                        break;
                    }
                    case 46: 
                    case 5201: {
                        if (nk != 0 || --angleDepth >= 0) continue block24;
                        if (ctx == AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr) {
                            return 1;
                        }
                        int lt1 = this.LTcatchEOF(1);
                        if (lt1 == 5201) {
                            if (ctx != AbstractGNUSourceCodeParser.CastExprCtx.eBExprInTmplID) {
                                return -1;
                            }
                            lt1 = this.LTcatchEOF(2);
                        }
                        switch (lt1) {
                            case 3: 
                            case 8: {
                                return 0;
                            }
                            case 1: 
                            case 2: 
                            case 15: 
                            case 16: 
                            case 18: 
                            case 21: 
                            case 23: 
                            case 30: 
                            case 34: 
                            case 36: 
                            case 60: 
                            case 64: 
                            case 69: 
                            case 72: 
                            case 74: 
                            case 75: 
                            case 81: 
                            case 82: 
                            case 88: 
                            case 89: 
                            case 92: 
                            case 95: 
                            case 102: 
                            case 104: 
                            case 105: 
                            case 107: 
                            case 108: 
                            case 112: 
                            case 114: 
                            case 117: 
                            case 118: 
                            case 120: 
                            case 125: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 133: 
                            case 140: 
                            case 151: 
                            case 5000: 
                            case 5001: 
                            case 5002: 
                            case 5003: 
                            case 5202: 
                            case 5203: {
                                return -1;
                            }
                            case 5: 
                            case 6: 
                            case 9: 
                            case 11: 
                            case 13: 
                            case 48: {
                                return 1;
                            }
                        }
                        return 0;
                    }
                    case 10: {
                        if (nk == 0) {
                            nk = 10;
                            depth = 0;
                            break;
                        }
                        if (nk != 10) break;
                        ++depth;
                        break;
                    }
                    case 11: {
                        if (nk != 10 || --depth >= 0) continue block24;
                        nk = 0;
                        break;
                    }
                    case 8: {
                        if (nk == 0) {
                            nk = 8;
                            depth = 0;
                            break;
                        }
                        if (nk != 8) break;
                        ++depth;
                        break;
                    }
                    case 9: {
                        if (nk != 8 || --depth >= 0) continue block24;
                        nk = 0;
                        break;
                    }
                    case 5: 
                    case 12: 
                    case 13: {
                        if (nk != 0) break;
                        return -1;
                    }
                }
            }
            return 0;
        }
        finally {
            this.backup(mark);
        }
    }

    private List<IASTNode> templateArgumentList(boolean isAmbiguous) throws EndOfFileException, BacktrackException {
        int startingOffset = this.LA(1).getOffset();
        int endOffset = 0;
        ArrayList<IASTNode> list = null;
        BinaryExprCtx exprCtx = isAmbiguous ? BinaryExprCtx.eAmbigTmplID : BinaryExprCtx.eTmplID;
        boolean needComma = false;
        int lt1 = this.LT(1);
        while (lt1 != 46 && lt1 != 5201 && lt1 != 141) {
            if (needComma) {
                if (lt1 != 6) {
                    this.throwBacktrack(startingOffset, endOffset - startingOffset);
                }
                this.consume();
            } else {
                needComma = true;
            }
            IASTNode node = this.templateArgument(exprCtx);
            if (list == null) {
                list = new ArrayList<IASTNode>();
            }
            list.add(node);
            lt1 = this.LT(1);
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private IASTNode templateArgument(BinaryExprCtx exprCtx) throws EndOfFileException, BacktrackException {
        IToken argStart = this.mark();
        ICPPASTTypeId typeId = null;
        int lt1 = 0;
        try {
            typeId = this.typeId(DeclarationOptions.TYPEID);
            lt1 = this.LT(1);
        }
        catch (BacktrackException backtrackException) {}
        if (typeId != null && (lt1 == 6 || lt1 == 46 || lt1 == 5201 || lt1 == 141 || lt1 == 48)) {
            IASTNamedTypeSpecifier namedDeclspec;
            IASTName name;
            IASTDeclSpecifier declspec = typeId.getDeclSpecifier();
            if (declspec instanceof IASTNamedTypeSpecifier && (name = (namedDeclspec = (IASTNamedTypeSpecifier)declspec).getName()).contains(typeId) && !(name.getLastName() instanceof ICPPASTTemplateId)) {
                IToken typeIdEnd = this.mark();
                IASTIdExpression idExpr = this.setRange(this.nodeFactory.newIdExpression(name), name);
                try {
                    boolean isAmbiguous;
                    IASTExpression expression = this.expression(AbstractGNUSourceCodeParser.ExprKind.eAssignment, exprCtx, idExpr);
                    boolean bl = isAmbiguous = expression == idExpr;
                    if (this.LT(1) == 48) {
                        IToken ellipsis = this.consume();
                        if (isAmbiguous) {
                            this.addPackExpansion(typeId, ellipsis);
                        }
                        expression = this.addPackExpansion(expression, ellipsis);
                    }
                    if (isAmbiguous) {
                        ICPPASTAmbiguousTemplateArgument ambiguity = this.createAmbiguousTemplateArgument();
                        ambiguity.addTypeId(typeId);
                        ambiguity.addIdExpression(expression);
                        return ambiguity;
                    }
                    return expression;
                }
                catch (BacktrackException backtrackException) {
                    this.backup(typeIdEnd);
                    namedDeclspec.setName(name);
                }
            }
            if (this.LT(1) == 48) {
                this.addPackExpansion(typeId, this.consume());
            }
            return typeId;
        }
        this.backup(argStart);
        IASTExpression expr = this.expression(AbstractGNUSourceCodeParser.ExprKind.eAssignment, exprCtx, null);
        if (this.LT(1) == 48) {
            expr = this.addPackExpansion(expr, this.consume());
        }
        return expr;
    }

    private void addPackExpansion(ICPPASTTypeId typeId, IToken consume) {
        int endOffset = consume.getEndOffset();
        this.adjustEndOffset(typeId, endOffset);
        typeId.setIsPackExpansion(true);
    }

    private IASTExpression addPackExpansion(IASTExpression expr, IToken ellipsis) {
        ICPPASTPackExpansionExpression result = this.nodeFactory.newPackExpansionExpression(expr);
        return this.setRange(result, expr, ellipsis.getEndOffset());
    }

    private IASTName operatorId() throws BacktrackException, EndOfFileException {
        IASTName name;
        IToken firstToken = this.consume(95);
        int endOffset = firstToken.getEndOffset();
        ICPPASTTypeId typeId = null;
        OverloadableOperator op = null;
        int lt1 = this.LT(1);
        switch (lt1) {
            case 8: {
                op = OverloadableOperator.PAREN;
                this.consume();
                endOffset = this.consume(9).getEndOffset();
                break;
            }
            case 10: {
                op = OverloadableOperator.BRACKET;
                this.consume();
                endOffset = this.consume(11).getEndOffset();
                break;
            }
            case 72: 
            case 92: {
                if (this.LT(2) == 10) {
                    op = lt1 == 92 ? OverloadableOperator.NEW_ARRAY : OverloadableOperator.DELETE_ARRAY;
                    this.consume();
                    this.consume();
                    endOffset = this.consume(11).getEndOffset();
                    break;
                }
                IToken t = this.consume();
                endOffset = t.getEndOffset();
                op = OverloadableOperator.valueOf(t);
                break;
            }
            case 5201: {
                this.consume();
                endOffset = this.consume(5201).getEndOffset();
                op = OverloadableOperator.SHIFTR;
                break;
            }
            default: {
                op = OverloadableOperator.valueOf(this.LA(1));
                if (op == null) break;
                endOffset = this.consume().getEndOffset();
            }
        }
        if (op != null) {
            name = this.nodeFactory.newOperatorName(op.toCharArray());
            this.setRange(name, firstToken.getOffset(), endOffset);
            return name;
        }
        typeId = this.typeId(DeclarationOptions.TYPEID_CONVERSION);
        name = this.nodeFactory.newConversionName(typeId);
        this.setRange(name, firstToken.getOffset(), this.calculateEndOffset(typeId));
        return name;
    }

    @Override
    protected IASTExpression expression() throws BacktrackException, EndOfFileException {
        return this.expression(AbstractGNUSourceCodeParser.ExprKind.eExpression, BinaryExprCtx.eNoTmplID, null);
    }

    @Override
    protected IASTExpression constantExpression() throws BacktrackException, EndOfFileException {
        return this.expression(AbstractGNUSourceCodeParser.ExprKind.eConstant, BinaryExprCtx.eNoTmplID, null);
    }

    private IASTExpression expression(AbstractGNUSourceCodeParser.ExprKind kind, BinaryExprCtx ctx, IASTInitializerClause expr) throws EndOfFileException, BacktrackException {
        int lt1;
        AbstractGNUSourceCodeParser.CastExprCtx castCtx;
        boolean allowComma = kind == AbstractGNUSourceCodeParser.ExprKind.eExpression;
        boolean allowAssignment = kind != AbstractGNUSourceCodeParser.ExprKind.eConstant;
        AbstractGNUSourceCodeParser.CastExprCtx castExprCtx = castCtx = ctx == BinaryExprCtx.eNoTmplID ? AbstractGNUSourceCodeParser.CastExprCtx.eBExpr : AbstractGNUSourceCodeParser.CastExprCtx.eBExprInTmplID;
        if (allowAssignment && this.LT(1) == 113) {
            return this.throwExpression();
        }
        int conditionCount = 0;
        AbstractGNUSourceCodeParser.BinaryOperator lastOperator = null;
        if (expr == null) {
            expr = this.castExpression(castCtx);
        }
        block19: while (true) {
            boolean allowThrow = false;
            boolean allowBraceInitializer = false;
            lt1 = this.LT(1);
            switch (lt1) {
                case 7: {
                    if (ctx == BinaryExprCtx.eAmbigTmplID) {
                        this.throwBacktrack(this.LA(1));
                    }
                    ++conditionCount;
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 25, 0);
                    if (this.LT(2) == 4) {
                        this.consume();
                        expr = null;
                        continue block19;
                    }
                    allowAssignment = true;
                    allowThrow = true;
                    break;
                }
                case 4: {
                    if (--conditionCount < 0) break block19;
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 0, 15);
                    allowAssignment = true;
                    allowThrow = true;
                    break;
                }
                case 6: {
                    allowThrow = true;
                    if (!allowComma && conditionCount == 0) break block19;
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 10, 11);
                    break;
                }
                case 14: 
                case 17: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 31: 
                case 38: 
                case 43: 
                case 47: 
                case 51: {
                    if (!allowAssignment && conditionCount == 0) break block19;
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 21, 20);
                    allowBraceInitializer = true;
                    break;
                }
                case 32: {
                    if (ctx == BinaryExprCtx.eAmbigTmplID) {
                        this.throwBacktrack(this.LA(1));
                    }
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 30, 31);
                    break;
                }
                case 29: {
                    if (ctx == BinaryExprCtx.eAmbigTmplID) {
                        this.throwBacktrack(this.LA(1));
                    }
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 40, 41);
                    break;
                }
                case 33: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 50, 51);
                    break;
                }
                case 27: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 60, 61);
                    break;
                }
                case 30: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 70, 71);
                    break;
                }
                case 35: 
                case 37: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 80, 81);
                    break;
                }
                case 46: {
                    if (ctx != BinaryExprCtx.eNoTmplID) break block19;
                }
                case 41: 
                case 42: 
                case 45: 
                case 152: 
                case 153: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 90, 91);
                    break;
                }
                case 5201: {
                    if (ctx != BinaryExprCtx.eNoTmplID) break block19;
                    if (this.LT(2) != 5201) {
                        this.throwBacktrack(this.LA(1));
                    }
                    lt1 = 44;
                    this.consume();
                }
                case 40: 
                case 44: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 100, 101);
                    break;
                }
                case 16: 
                case 21: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 110, 111);
                    break;
                }
                case 23: 
                case 25: 
                case 52: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 120, 121);
                    break;
                }
                case 19: 
                case 49: {
                    lastOperator = new AbstractGNUSourceCodeParser.BinaryOperator(lastOperator, expr, lt1, 130, 131);
                    break;
                }
                default: {
                    break block19;
                }
            }
            this.consume();
            if (allowThrow && this.LT(1) == 113) {
                expr = this.throwExpression();
            } else if (allowBraceInitializer && this.LT(1) == 12) {
                expr = this.bracedInitList(true);
            } else {
                expr = this.castExpression(castCtx);
                continue;
            }
            if ((lt1 = this.LT(1)) != 4 && lt1 != 6) break;
        }
        if (lt1 != 141 && conditionCount > 0) {
            this.throwBacktrack(this.LA(1));
        }
        return this.buildExpression(lastOperator, expr);
    }

    @Override
    protected IASTExpression buildBinaryExpression(int operator, IASTExpression expr1, IASTInitializerClause expr2, int lastOffset) {
        ICPPASTBinaryExpression result = this.nodeFactory.newBinaryExpression(operator, expr1, expr2);
        int o = ((ASTNode)((Object)expr1)).getOffset();
        ((ASTNode)((Object)result)).setOffsetAndLength(o, lastOffset - o);
        return result;
    }

    private IASTExpression throwExpression() throws EndOfFileException, BacktrackException {
        IToken throwToken = this.consume();
        IASTExpression throwExpression = null;
        try {
            throwExpression = this.expression();
        }
        catch (BacktrackException backtrackException) {
            this.backup(throwToken);
            this.consume();
        }
        int o = throwExpression != null ? this.calculateEndOffset(throwExpression) : throwToken.getEndOffset();
        return this.buildUnaryExpression(12, throwExpression, throwToken.getOffset(), o);
    }

    protected IASTExpression deleteExpression() throws EndOfFileException, BacktrackException {
        int startingOffset = this.LA(1).getOffset();
        boolean global = false;
        if (this.LT(1) == 3) {
            this.consume();
            global = true;
        }
        this.consume(72);
        boolean vectored = false;
        if (this.LT(1) == 10) {
            this.consume();
            this.consume(11);
            vectored = true;
        }
        IASTExpression castExpression = this.castExpression(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
        ICPPASTDeleteExpression deleteExpression = this.nodeFactory.newDeleteExpression(castExpression);
        ((ASTNode)((Object)deleteExpression)).setOffsetAndLength(startingOffset, this.calculateEndOffset(castExpression) - startingOffset);
        deleteExpression.setIsGlobal(global);
        deleteExpression.setIsVectored(vectored);
        return deleteExpression;
    }

    protected IASTExpression newExpression() throws BacktrackException, EndOfFileException {
        boolean isGlobal;
        IToken la = this.LA(1);
        int offset = la.getOffset();
        boolean bl = isGlobal = la.getType() == 3;
        if (isGlobal) {
            this.consume();
        }
        this.consume(92);
        if (this.LT(1) == 8) {
            int endOffset2;
            int lt1;
            this.consume();
            List<IASTInitializerClause> plcmt = null;
            ICPPASTTypeId typeid = null;
            boolean isNewTypeId = true;
            IASTInitializer init = null;
            int endOffset = 0;
            IToken mark = this.mark();
            IToken end = null;
            try {
                plcmt = this.expressionList();
                endOffset = this.consumeOrEOC(9).getEndOffset();
                lt1 = this.LT(1);
                if (lt1 == 141) {
                    return this.newExpression(isGlobal, plcmt, typeid, isNewTypeId, init, offset, endOffset);
                }
                if (lt1 == 8) {
                    isNewTypeId = false;
                    this.consume(8);
                    typeid = this.typeId(DeclarationOptions.TYPEID);
                    endOffset = this.consumeOrEOC(9).getEndOffset();
                } else {
                    typeid = this.typeId(DeclarationOptions.TYPEID_NEW);
                    endOffset = this.calculateEndOffset(typeid);
                }
                end = this.LA(1);
            }
            catch (BacktrackException backtrackException) {
                plcmt = null;
                typeid = null;
            }
            if (typeid != null && plcmt != null) {
                lt1 = this.LT(1);
                if (lt1 == 141) {
                    return this.newExpression(isGlobal, plcmt, typeid, isNewTypeId, init, offset, endOffset);
                }
                if (lt1 == 8 || lt1 == 12) {
                    init = this.bracedOrCtorStyleInitializer();
                    endOffset = this.calculateEndOffset(init);
                    return this.newExpression(isGlobal, plcmt, typeid, isNewTypeId, init, offset, endOffset);
                }
            }
            this.backup(mark);
            ICPPASTTypeId typeid2 = null;
            IASTInitializer init2 = null;
            try {
                typeid2 = this.typeId(DeclarationOptions.TYPEID);
                endOffset2 = this.consumeOrEOC(9).getEndOffset();
                int lt12 = this.LT(1);
                if (lt12 == 141) {
                    return this.newExpression(isGlobal, null, typeid2, false, init2, offset, endOffset2);
                }
                if (lt12 == 8 || lt12 == 12) {
                    if (plcmt != null && ASTQueries.findTypeRelevantDeclarator(typeid2.getAbstractDeclarator()) instanceof IASTArrayDeclarator) {
                        this.throwBacktrack(this.LA(1));
                    }
                    init2 = this.bracedOrCtorStyleInitializer();
                    endOffset2 = this.calculateEndOffset(init2);
                }
            }
            catch (BacktrackException e) {
                if (plcmt == null) {
                    throw e;
                }
                endOffset2 = -1;
            }
            if (plcmt == null || endOffset2 > endOffset) {
                return this.newExpression(isGlobal, null, typeid2, false, init2, offset, endOffset2);
            }
            if (endOffset != endOffset2) {
                this.backup(end);
                return this.newExpression(isGlobal, plcmt, typeid, isNewTypeId, init, offset, endOffset);
            }
            IASTExpression ex1 = this.newExpression(isGlobal, plcmt, typeid, isNewTypeId, init, offset, endOffset);
            IASTExpression ex2 = this.newExpression(isGlobal, null, typeid2, false, init2, offset, endOffset2);
            IASTAmbiguousExpression ambiguity = this.createAmbiguousExpression();
            ambiguity.addExpression(ex1);
            ambiguity.addExpression(ex2);
            ((ASTNode)((Object)ambiguity)).setOffsetAndLength((ASTNode)((Object)ex1));
            return ambiguity;
        }
        ICPPASTTypeId typeid = this.typeId(DeclarationOptions.TYPEID_NEW);
        int endOffset = this.calculateEndOffset(typeid);
        IASTInitializer init = null;
        int lt1 = this.LT(1);
        if (lt1 == 8 || lt1 == 12) {
            init = this.bracedOrCtorStyleInitializer();
            endOffset = this.calculateEndOffset(init);
        }
        return this.newExpression(isGlobal, null, typeid, true, init, offset, endOffset);
    }

    private IASTExpression newExpression(boolean isGlobal, List<IASTInitializerClause> plcmt, IASTTypeId typeid, boolean isNewTypeId, IASTInitializer init, int offset, int endOffset) {
        IASTInitializerClause[] plcmtArray = null;
        if (plcmt != null && !plcmt.isEmpty()) {
            plcmtArray = plcmt.toArray(new IASTInitializerClause[plcmt.size()]);
        }
        ICPPASTNewExpression result = this.nodeFactory.newNewExpression(plcmtArray, init, typeid);
        result.setIsGlobal(isGlobal);
        result.setIsNewTypeId(isNewTypeId);
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, endOffset - offset);
        return result;
    }

    @Override
    protected IASTExpression unaryExpression(AbstractGNUSourceCodeParser.CastExprCtx ctx) throws EndOfFileException, BacktrackException {
        switch (this.LT(1)) {
            case 23: {
                return this.unaryExpression(4, ctx);
            }
            case 30: {
                return this.unaryExpression(5, ctx);
            }
            case 16: {
                return this.unaryExpression(2, ctx);
            }
            case 21: {
                return this.unaryExpression(3, ctx);
            }
            case 36: {
                return this.unaryExpression(7, ctx);
            }
            case 34: {
                return this.unaryExpression(6, ctx);
            }
            case 15: {
                return this.unaryExpression(0, ctx);
            }
            case 18: {
                return this.unaryExpression(1, ctx);
            }
            case 92: {
                return this.newExpression();
            }
            case 72: {
                return this.deleteExpression();
            }
            case 3: {
                switch (this.LT(2)) {
                    case 92: {
                        return this.newExpression();
                    }
                    case 72: {
                        return this.deleteExpression();
                    }
                }
                return this.postfixExpression(ctx);
            }
            case 105: {
                if (this.LTcatchEOF(2) == 48) {
                    int offset = this.consume().getOffset();
                    this.consume();
                    this.consume(8);
                    IASTName id = this.identifier();
                    IASTIdExpression idexpr = this.nodeFactory.newIdExpression(id);
                    this.setRange(idexpr, id);
                    ICPPASTUnaryExpression expr = this.nodeFactory.newUnaryExpression(16, idexpr);
                    int lt1 = this.LT(1);
                    if (lt1 == 141) {
                        this.setRange(expr, offset, this.calculateEndOffset(id));
                    } else {
                        int endOffset = this.consume(9).getEndOffset();
                        this.setRange(expr, offset, endOffset);
                    }
                    return expr;
                }
                return this.parseTypeidInParenthesisOrUnaryExpression(false, this.consume().getOffset(), 0, 8, ctx);
            }
            case 151: {
                return this.parseTypeidInParenthesisOrUnaryExpression(false, this.consume().getOffset(), 2, 15, ctx);
            }
        }
        return this.postfixExpression(ctx);
    }

    private IASTExpression postfixExpression(AbstractGNUSourceCodeParser.CastExprCtx ctx) throws EndOfFileException, BacktrackException {
        IASTExpression firstExpression = null;
        boolean isTemplate = false;
        switch (this.LT(1)) {
            case 75: {
                firstExpression = this.specialCastExpression(1);
                break;
            }
            case 107: {
                firstExpression = this.specialCastExpression(2);
                break;
            }
            case 102: {
                firstExpression = this.specialCastExpression(3);
                break;
            }
            case 69: {
                firstExpression = this.specialCastExpression(4);
                break;
            }
            case 117: {
                int so = this.consume().getOffset();
                firstExpression = this.parseTypeidInParenthesisOrUnaryExpression(true, so, 1, 13, ctx);
                break;
            }
            case 8: {
                IToken m = this.mark();
                try {
                    int offset = this.consume().getOffset();
                    ICPPASTTypeId t = this.typeId(DeclarationOptions.TYPEID);
                    this.consume(9);
                    if (this.LT(1) == 12) {
                        ICPPASTInitializerList i = this.bracedInitList(false);
                        firstExpression = this.nodeFactory.newTypeIdInitializerExpression(t, i);
                        this.setRange(firstExpression, offset, this.calculateEndOffset(i));
                        break;
                    }
                }
                catch (BacktrackException backtrackException) {}
                this.backup(m);
                firstExpression = this.primaryExpression(ctx);
                break;
            }
            case 60: 
            case 64: 
            case 74: 
            case 82: 
            case 88: 
            case 89: 
            case 104: 
            case 108: 
            case 118: 
            case 120: 
            case 123: 
            case 125: 
            case 150: 
            case 5202: 
            case 5203: 
            case 5204: {
                firstExpression = this.simpleTypeConstructorExpression(this.simpleTypeSpecifier());
                break;
            }
            default: {
                firstExpression = this.primaryExpression(ctx);
                if (!(firstExpression instanceof IASTIdExpression) || this.LT(1) != 12) break;
                IASTName name = ((IASTIdExpression)firstExpression).getName();
                ICPPASTNamedTypeSpecifier declSpec = this.nodeFactory.newTypedefNameSpecifier(name);
                firstExpression = this.simpleTypeConstructorExpression(this.setRange(declSpec, name));
            }
        }
        block19: while (true) {
            switch (this.LT(1)) {
                case 10: {
                    this.consume(10);
                    IASTInitializerClause expression = this.LT(1) == 12 ? this.bracedInitList(false) : this.expression();
                    int endOffset = this.consumeOrEOC(11).getEndOffset();
                    ICPPASTArraySubscriptExpression s = this.nodeFactory.newArraySubscriptExpression(firstExpression, expression);
                    firstExpression = this.setRange(s, firstExpression, endOffset);
                    continue block19;
                }
                case 8: {
                    IASTInitializerClause[] initArray;
                    this.consume(8);
                    if (this.LT(1) == 9) {
                        initArray = IASTExpression.EMPTY_EXPRESSION_ARRAY;
                    } else {
                        List<IASTInitializerClause> exprList = this.expressionList();
                        initArray = exprList.toArray(new IASTInitializerClause[exprList.size()]);
                    }
                    int endOffset = this.consumeOrEOC(9).getEndOffset();
                    ICPPASTFunctionCallExpression fce = this.nodeFactory.newFunctionCallExpression(firstExpression, initArray);
                    firstExpression = this.setRange(fce, firstExpression, endOffset);
                    continue block19;
                }
                case 15: {
                    int endOffset = this.consume().getEndOffset();
                    firstExpression = this.buildUnaryExpression(9, firstExpression, ((ASTNode)((Object)firstExpression)).getOffset(), endOffset);
                    continue block19;
                }
                case 18: {
                    int endOffset = this.consume().getEndOffset();
                    firstExpression = this.buildUnaryExpression(10, firstExpression, ((ASTNode)((Object)firstExpression)).getOffset(), endOffset);
                    continue block19;
                }
                case 50: {
                    IASTName name;
                    IToken dot = this.consume();
                    if (this.LT(1) == 111) {
                        this.consume();
                        isTemplate = true;
                    }
                    if ((name = this.qualifiedName(ctx)) == null) {
                        this.throwBacktrack(((ASTNode)((Object)firstExpression)).getOffset(), ((ASTNode)((Object)firstExpression)).getLength() + dot.getLength());
                    }
                    ICPPASTFieldReference fieldReference = this.nodeFactory.newFieldReference(name, firstExpression);
                    fieldReference.setIsPointerDereference(false);
                    fieldReference.setIsTemplate(isTemplate);
                    ((ASTNode)((Object)fieldReference)).setOffsetAndLength(((ASTNode)((Object)firstExpression)).getOffset(), this.calculateEndOffset(name) - ((ASTNode)((Object)firstExpression)).getOffset());
                    firstExpression = fieldReference;
                    continue block19;
                }
                case 20: {
                    IASTName name;
                    IToken arrow = this.consume();
                    if (this.LT(1) == 111) {
                        this.consume();
                        isTemplate = true;
                    }
                    if ((name = this.qualifiedName(ctx)) == null) {
                        this.throwBacktrack(((ASTNode)((Object)firstExpression)).getOffset(), ((ASTNode)((Object)firstExpression)).getLength() + arrow.getLength());
                    }
                    ICPPASTFieldReference fieldReference = this.nodeFactory.newFieldReference(name, firstExpression);
                    fieldReference.setIsPointerDereference(true);
                    fieldReference.setIsTemplate(isTemplate);
                    ((ASTNode)((Object)fieldReference)).setOffsetAndLength(((ASTNode)((Object)firstExpression)).getOffset(), this.calculateEndOffset(name) - ((ASTNode)((Object)firstExpression)).getOffset());
                    firstExpression = fieldReference;
                    continue block19;
                }
            }
            break;
        }
        return firstExpression;
    }

    @Override
    protected IASTAmbiguousExpression createAmbiguousExpression() {
        return new CPPASTAmbiguousExpression(new IASTExpression[0]);
    }

    @Override
    protected IASTAmbiguousExpression createAmbiguousBinaryVsCastExpression(IASTBinaryExpression binary, IASTCastExpression castExpr) {
        return new CPPASTAmbiguousBinaryVsCastExpression(binary, castExpr);
    }

    @Override
    protected IASTAmbiguousExpression createAmbiguousCastVsFunctionCallExpression(IASTCastExpression castExpr, IASTFunctionCallExpression funcCall) {
        return new CPPASTAmbiguousCastVsFunctionCallExpression(castExpr, funcCall);
    }

    protected ICPPASTAmbiguousTemplateArgument createAmbiguousTemplateArgument() {
        return new CPPASTAmbiguousTemplateArgument(new IASTNode[0]);
    }

    private IASTExpression simpleTypeConstructorExpression(ICPPASTDeclSpecifier declSpec) throws EndOfFileException, BacktrackException {
        IASTInitializer initializer = this.bracedOrCtorStyleInitializer();
        ICPPASTSimpleTypeConstructorExpression result = this.nodeFactory.newSimpleTypeConstructorExpression(declSpec, initializer);
        return this.setRange(result, declSpec, this.calculateEndOffset(initializer));
    }

    @Override
    protected IASTExpression primaryExpression(AbstractGNUSourceCodeParser.CastExprCtx ctx) throws EndOfFileException, BacktrackException {
        IToken t = null;
        ICPPASTLiteralExpression literalExpression = null;
        switch (this.LT(1)) {
            case 2: {
                t = this.consume();
                literalExpression = this.nodeFactory.newLiteralExpression(0, t.getImage());
                ((ASTNode)((Object)literalExpression)).setOffsetAndLength(t.getOffset(), t.getEndOffset() - t.getOffset());
                return literalExpression;
            }
            case 129: {
                t = this.consume();
                literalExpression = this.nodeFactory.newLiteralExpression(1, t.getImage());
                ((ASTNode)((Object)literalExpression)).setOffsetAndLength(t.getOffset(), t.getEndOffset() - t.getOffset());
                return literalExpression;
            }
            case 130: 
            case 131: 
            case 5000: 
            case 5001: {
                return this.stringLiteral();
            }
            case 132: 
            case 133: 
            case 5002: 
            case 5003: {
                t = this.consume();
                literalExpression = this.nodeFactory.newLiteralExpression(2, t.getImage());
                ((ASTNode)((Object)literalExpression)).setOffsetAndLength(t.getOffset(), t.getEndOffset() - t.getOffset());
                return literalExpression;
            }
            case 81: {
                t = this.consume();
                literalExpression = this.nodeFactory.newLiteralExpression(6, t.getImage());
                ((ASTNode)((Object)literalExpression)).setOffsetAndLength(t.getOffset(), t.getEndOffset() - t.getOffset());
                return literalExpression;
            }
            case 114: {
                t = this.consume();
                literalExpression = this.nodeFactory.newLiteralExpression(5, t.getImage());
                ((ASTNode)((Object)literalExpression)).setOffsetAndLength(t.getOffset(), t.getEndOffset() - t.getOffset());
                return literalExpression;
            }
            case 112: {
                t = this.consume();
                literalExpression = this.nodeFactory.newLiteralExpression(4, t.getImage());
                ((ASTNode)((Object)literalExpression)).setOffsetAndLength(t.getOffset(), t.getEndOffset() - t.getOffset());
                return literalExpression;
            }
            case 8: {
                if (this.supportStatementsInExpressions && this.LT(2) == 12) {
                    return this.compoundStatementExpression();
                }
                t = this.consume();
                int finalOffset = 0;
                IASTExpression lhs = this.expression(AbstractGNUSourceCodeParser.ExprKind.eExpression, BinaryExprCtx.eNoTmplID, null);
                switch (this.LT(1)) {
                    case 9: 
                    case 141: {
                        finalOffset = this.consume().getEndOffset();
                        break;
                    }
                    default: {
                        this.throwBacktrack(this.LA(1));
                    }
                }
                return this.buildUnaryExpression(11, lhs, t.getOffset(), finalOffset);
            }
            case 1: 
            case 3: 
            case 34: 
            case 95: 
            case 140: {
                IASTName name = this.qualifiedName(ctx);
                IASTIdExpression idExpression = this.nodeFactory.newIdExpression(name);
                ((ASTNode)((Object)idExpression)).setOffsetAndLength(((ASTNode)((Object)name)).getOffset(), ((ASTNode)((Object)name)).getOffset() + ((ASTNode)((Object)name)).getLength() - ((ASTNode)((Object)name)).getOffset());
                return idExpression;
            }
        }
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        this.throwBacktrack(startingOffset, la.getLength());
        return null;
    }

    private ICPPASTLiteralExpression stringLiteral() throws EndOfFileException, BacktrackException {
        switch (this.LT(1)) {
            case 130: 
            case 131: 
            case 5000: 
            case 5001: {
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        IToken t = this.consume();
        ICPPASTLiteralExpression r = this.nodeFactory.newLiteralExpression(3, t.getImage());
        this.setRange(r, t.getOffset(), t.getEndOffset());
        return r;
    }

    protected IASTExpression specialCastExpression(int kind) throws EndOfFileException, BacktrackException {
        int operator;
        int offset = this.LA(1).getOffset();
        int optype = this.consume().getType();
        this.consume(42);
        ICPPASTTypeId typeID = this.typeId(DeclarationOptions.TYPEID);
        this.consumeOrEOC(46);
        this.consumeOrEOC(8);
        IASTExpression operand = null;
        if (this.LT(1) != 141) {
            operand = this.expression();
        }
        int endOffset = this.consumeOrEOC(9).getEndOffset();
        switch (optype) {
            case 75: {
                operator = 1;
                break;
            }
            case 107: {
                operator = 2;
                break;
            }
            case 102: {
                operator = 3;
                break;
            }
            case 69: {
                operator = 4;
                break;
            }
            default: {
                operator = 0;
            }
        }
        return this.buildCastExpression(operator, typeID, operand, offset, endOffset);
    }

    protected IASTDeclaration usingClause() throws EndOfFileException, BacktrackException {
        int offset = this.consume().getOffset();
        if (this.LT(1) == 91) {
            int endOffset = this.consume().getEndOffset();
            IASTName name = null;
            switch (this.LT(1)) {
                case 1: 
                case 3: 
                case 140: {
                    name = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
                    break;
                }
                default: {
                    this.throwBacktrack(offset, endOffset - offset);
                }
            }
            switch (this.LT(1)) {
                case 5: 
                case 141: {
                    endOffset = this.consume().getEndOffset();
                    break;
                }
                default: {
                    throw this.backtrack;
                }
            }
            ICPPASTUsingDirective astUD = this.nodeFactory.newUsingDirective(name);
            ((ASTNode)((Object)astUD)).setOffsetAndLength(offset, endOffset - offset);
            return astUD;
        }
        ICPPASTUsingDeclaration result = this.usingDeclaration(offset);
        return result;
    }

    private ICPPASTUsingDeclaration usingDeclaration(int offset) throws EndOfFileException, BacktrackException {
        int end;
        boolean typeName = false;
        if (this.LT(1) == 118) {
            typeName = true;
            this.consume();
        }
        IASTName name = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
        switch (this.LT(1)) {
            case 5: 
            case 141: {
                end = this.consume().getEndOffset();
                break;
            }
            default: {
                throw this.backtrack;
            }
        }
        ICPPASTUsingDeclaration result = this.nodeFactory.newUsingDeclaration(name);
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, end - offset);
        result.setIsTypename(typeName);
        return result;
    }

    private ICPPASTStaticAssertDeclaration staticAssertDeclaration() throws EndOfFileException, BacktrackException {
        int offset = this.consume(5205).getOffset();
        this.consume(8);
        IASTExpression e = this.constantExpression();
        int endOffset = this.calculateEndOffset(e);
        ICPPASTLiteralExpression lit = null;
        if (this.LT(1) != 141) {
            this.consume(6);
            lit = this.stringLiteral();
            this.consume(9);
            endOffset = this.consume(5).getEndOffset();
        }
        ICPPASTStaticAssertDeclaration assertion = this.nodeFactory.newStaticAssertion(e, lit);
        return this.setRange(assertion, offset, endOffset);
    }

    protected ICPPASTLinkageSpecification linkageSpecification() throws EndOfFileException, BacktrackException {
        int offset = this.consume().getOffset();
        String spec = this.consume().getImage();
        ICPPASTLinkageSpecification linkage = this.nodeFactory.newLinkageSpecification(spec);
        if (this.LT(1) == 12) {
            this.declarationListInBraces(linkage, offset, DeclarationOptions.GLOBAL);
            return linkage;
        }
        IASTDeclaration d = this.declaration(DeclarationOptions.GLOBAL);
        linkage.addDeclaration(d);
        this.setRange(linkage, offset, this.calculateEndOffset(d));
        return linkage;
    }

    protected IASTDeclaration templateDeclaration(DeclarationOptions option) throws EndOfFileException, BacktrackException {
        int offset = this.LA(1).getOffset();
        boolean exported = false;
        int explicitInstMod = 0;
        switch (this.LT(1)) {
            case 79: {
                exported = true;
                this.consume();
                break;
            }
            case 80: {
                this.consume();
                explicitInstMod = 3;
                break;
            }
            case 106: {
                this.consume();
                explicitInstMod = 1;
                break;
            }
            case 87: {
                this.consume();
                explicitInstMod = 2;
            }
        }
        this.consume(111);
        if (this.LT(1) != 42) {
            IASTDeclaration d = this.declaration(option);
            ICPPASTExplicitTemplateInstantiation ti = this.nodeFactory.newExplicitTemplateInstantiation(d);
            ti.setModifier(explicitInstMod);
            this.setRange(ti, offset, this.calculateEndOffset(d));
            return ti;
        }
        if (explicitInstMod != 0) {
            this.throwBacktrack(this.LA(1));
        }
        this.consume(42);
        if (this.LT(1) == 46) {
            this.consume();
            IASTDeclaration d = this.declaration(option);
            ICPPASTTemplateSpecialization templateSpecialization = this.nodeFactory.newTemplateSpecialization(d);
            this.setRange(templateSpecialization, offset, this.calculateEndOffset(d));
            return templateSpecialization;
        }
        List<ICPPASTTemplateParameter> parms = this.templateParameterList();
        this.consume(46, 5201);
        IASTDeclaration d = this.declaration(option);
        ICPPASTTemplateDeclaration templateDecl = this.nodeFactory.newTemplateDeclaration(d);
        this.setRange(templateDecl, offset, this.calculateEndOffset(d));
        templateDecl.setExported(exported);
        int i = 0;
        while (i < parms.size()) {
            ICPPASTTemplateParameter parm = parms.get(i);
            templateDecl.addTemplateParameter(parm);
            ++i;
        }
        return templateDecl;
    }

    protected List<ICPPASTTemplateParameter> templateParameterList() throws BacktrackException, EndOfFileException {
        ArrayList<ICPPASTTemplateParameter> returnValue = new ArrayList<ICPPASTTemplateParameter>(4);
        int lt1;
        while ((lt1 = this.LT(1)) != 46 && lt1 != 141 && lt1 != 5201) {
            ICPPASTTemplateParameter tpar;
            int endOffset;
            int offset = this.LA(1).getOffset();
            if (lt1 == 65 || lt1 == 118) {
                int type = lt1 == 65 ? 1 : 2;
                boolean parameterPack = false;
                IASTName identifierName = null;
                ICPPASTTypeId defaultValue = null;
                endOffset = this.consume().getEndOffset();
                if (this.LT(1) == 48) {
                    parameterPack = true;
                    endOffset = this.consume().getOffset();
                }
                if (this.LT(1) == 1) {
                    identifierName = this.identifier();
                    endOffset = this.calculateEndOffset(identifierName);
                    if (this.LT(1) == 38) {
                        if (parameterPack) {
                            throw this.backtrack;
                        }
                        this.consume();
                        defaultValue = this.typeId(DeclarationOptions.TYPEID);
                        endOffset = this.calculateEndOffset(defaultValue);
                    }
                } else {
                    identifierName = this.nodeFactory.newName();
                }
                tpar = this.nodeFactory.newSimpleTypeTemplateParameter(type, identifierName, defaultValue);
                tpar.setIsParameterPack(parameterPack);
                this.setRange(tpar, offset, endOffset);
                returnValue.add(tpar);
                continue;
            }
            if (lt1 == 111) {
                boolean parameterPack = false;
                IASTName identifierName = null;
                IASTExpression defaultValue = null;
                this.consume();
                this.consume(42);
                List<ICPPASTTemplateParameter> tparList = this.templateParameterList();
                this.consume(46, 5201);
                endOffset = this.consume(65).getEndOffset();
                if (this.LT(1) == 48) {
                    parameterPack = true;
                    endOffset = this.consume().getOffset();
                }
                if (this.LT(1) == 1) {
                    identifierName = this.identifier();
                    endOffset = this.calculateEndOffset(identifierName);
                    if (this.LT(1) == 38) {
                        if (parameterPack) {
                            throw this.backtrack;
                        }
                        this.consume();
                        defaultValue = this.primaryExpression(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
                        endOffset = this.calculateEndOffset(defaultValue);
                    }
                } else {
                    identifierName = this.nodeFactory.newName();
                }
                tpar = this.nodeFactory.newTemplatedTypeTemplateParameter(identifierName, defaultValue);
                tpar.setIsParameterPack(parameterPack);
                this.setRange(tpar, offset, endOffset);
                int i = 0;
                while (i < tparList.size()) {
                    ICPPASTTemplateParameter p = tparList.get(i);
                    tpar.addTemplateParamter(p);
                    ++i;
                }
                returnValue.add(tpar);
                continue;
            }
            if (lt1 == 6) {
                this.consume();
                continue;
            }
            boolean inTParList = this.fInTemplateParameterList;
            try {
                this.fInTemplateParameterList = true;
                ICPPASTParameterDeclaration parm = this.parameterDeclaration();
                returnValue.add(parm);
                continue;
            }
            finally {
                this.fInTemplateParameterList = inTParList;
                continue;
            }
            break;
        }
        return returnValue;
    }

    @Override
    protected IASTDeclaration declaration(DeclarationOptions option) throws EndOfFileException, BacktrackException {
        switch (this.LT(1)) {
            case 56: {
                return this.asmDeclaration();
            }
            case 91: {
                return this.namespaceDefinitionOrAlias();
            }
            case 121: {
                return this.usingClause();
            }
            case 5205: {
                return this.staticAssertDeclaration();
            }
            case 79: 
            case 111: {
                return this.templateDeclaration(option);
            }
            case 80: {
                if (this.LT(2) == 130) {
                    return this.linkageSpecification();
                }
                if (this.LT(2) != 111) break;
                return this.templateDeclaration(option);
            }
            case 87: 
            case 106: {
                if (!this.supportExtendedTemplateSyntax || this.LT(2) != 111) break;
                return this.templateDeclaration(option);
            }
            case 5: {
                IToken t = this.consume();
                ICPPASTSimpleDeclSpecifier declspec = this.nodeFactory.newSimpleDeclSpecifier();
                IASTSimpleDeclaration decl = this.nodeFactory.newSimpleDeclaration(declspec);
                ((ASTNode)((Object)declspec)).setOffsetAndLength(t.getOffset(), 0);
                ((ASTNode)((Object)decl)).setOffsetAndLength(t.getOffset(), t.getLength());
                return decl;
            }
            case 98: 
            case 99: 
            case 100: {
                if (option != DeclarationOptions.CPP_MEMBER) break;
                IToken t = this.consume();
                int key = t.getType();
                int endOffset = this.consume(4).getEndOffset();
                ICPPASTVisibilityLabel label = this.nodeFactory.newVisibilityLabel(this.token2Visibility(key));
                this.setRange(label, t.getOffset(), endOffset);
                return label;
            }
        }
        try {
            return this.simpleDeclaration(option);
        }
        catch (BacktrackException e) {
            if (option != DeclarationOptions.CPP_MEMBER || this.declarationMark == null) {
                throw e;
            }
            BacktrackException orig = new BacktrackException(e);
            IToken mark = this.mark();
            this.backup(this.declarationMark);
            try {
                return this.usingDeclaration(this.declarationMark.getOffset());
            }
            catch (BacktrackException backtrackException) {
                this.backup(mark);
                throw orig;
            }
        }
    }

    protected IASTDeclaration namespaceDefinitionOrAlias() throws BacktrackException, EndOfFileException {
        int endOffset;
        int offset = this.consume().getOffset();
        IASTName name = null;
        if (this.LT(1) == 1) {
            name = this.identifier();
            endOffset = this.calculateEndOffset(name);
        } else {
            name = this.nodeFactory.newName();
        }
        this.__attribute_decl_seq(true, false);
        if (this.LT(1) == 12) {
            ICPPASTNamespaceDefinition ns = this.nodeFactory.newNamespaceDefinition(name);
            this.declarationListInBraces(ns, offset, DeclarationOptions.GLOBAL);
            return ns;
        }
        if (this.LT(1) == 38) {
            endOffset = this.consume().getEndOffset();
            if (name.toString() == null) {
                this.throwBacktrack(offset, endOffset - offset);
                return null;
            }
            IASTName qualifiedName = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
            endOffset = this.consume(5).getEndOffset();
            ICPPASTNamespaceAlias alias = this.nodeFactory.newNamespaceAlias(name, qualifiedName);
            ((ASTNode)((Object)alias)).setOffsetAndLength(offset, endOffset - offset);
            return alias;
        }
        this.throwBacktrack(this.LA(1));
        return null;
    }

    @Override
    protected boolean isLegalWithoutDtor(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof IASTElaboratedTypeSpecifier) {
            return ((IASTElaboratedTypeSpecifier)declSpec).getKind() != 0;
        }
        return super.isLegalWithoutDtor(declSpec);
    }

    protected IASTDeclaration simpleDeclaration(DeclarationOptions declOption) throws BacktrackException, EndOfFileException {
        IASTSimpleDeclaration simpleDeclaration;
        boolean isAmbiguous;
        int firstOffset;
        if (this.LT(1) == 12) {
            this.throwBacktrack(this.LA(1));
        }
        int endOffset = firstOffset = this.LA(1).getOffset();
        boolean insertSemi = false;
        IASTDeclSpecifier declSpec = null;
        IASTDeclarator dtor = null;
        IASTDeclSpecifier altDeclSpec = null;
        IASTDeclarator altDtor = null;
        IToken markBeforDtor = null;
        try {
            AbstractGNUSourceCodeParser.Decl decl = this.declSpecifierSequence_initDeclarator(declOption, true);
            markBeforDtor = decl.fDtorToken1;
            declSpec = decl.fDeclSpec1;
            dtor = decl.fDtor1;
            altDeclSpec = decl.fDeclSpec2;
            altDtor = decl.fDtor2;
        }
        catch (AbstractGNUSourceCodeParser.FoundAggregateInitializer lie) {
            declSpec = lie.fDeclSpec;
            this.declarationMark = null;
            dtor = this.addInitializer(lie, declOption);
        }
        catch (BacktrackException e) {
            IASTNode node = e.getNodeBeforeProblem();
            if (node instanceof IASTDeclSpecifier && this.isLegalWithoutDtor((IASTDeclSpecifier)node)) {
                IASTSimpleDeclaration d = this.nodeFactory.newSimpleDeclaration((IASTDeclSpecifier)node);
                this.setRange(d, node);
                this.throwBacktrack(e.getProblem(), d);
            }
            throw e;
        }
        Object[] declarators = IASTDeclarator.EMPTY_DECLARATOR_ARRAY;
        if (dtor != null) {
            declarators = new IASTDeclarator[]{dtor};
            while (this.LTcatchEOF(1) == 6) {
                this.consume();
                try {
                    dtor = this.initDeclarator(declSpec, declOption);
                }
                catch (AbstractGNUSourceCodeParser.FoundAggregateInitializer e) {
                    this.declarationMark = null;
                    markBeforDtor = null;
                    dtor = this.addInitializer(e, declOption);
                }
                declarators = (IASTDeclarator[])ArrayUtil.append(IASTDeclarator.class, declarators, dtor);
            }
            declarators = (IASTDeclarator[])ArrayUtil.removeNulls(IASTDeclarator.class, declarators);
        }
        int lt1 = this.LTcatchEOF(1);
        switch (lt1) {
            case 141: {
                endOffset = this.figureEndOffset(declSpec, (IASTDeclarator[])declarators);
                break;
            }
            case 5: {
                endOffset = this.consume().getEndOffset();
                break;
            }
            case 4: 
            case 12: 
            case 115: {
                if (declarators.length != 1) {
                    this.throwBacktrack(this.LA(1));
                }
                dtor = declarators[0];
                if (altDeclSpec != null && altDtor != null && dtor != null && !(ASTQueries.findTypeRelevantDeclarator(dtor) instanceof IASTFunctionDeclarator)) {
                    declSpec = altDeclSpec;
                    dtor = altDtor;
                }
                return this.functionDefinition(firstOffset, declSpec, dtor);
            }
            default: {
                if (declOption != DeclarationOptions.LOCAL) {
                    insertSemi = true;
                    if (this.isLegalWithoutDtor(declSpec) && markBeforDtor != null && !this.isOnSameLine(this.calculateEndOffset(declSpec), markBeforDtor.getOffset())) {
                        this.backup(markBeforDtor);
                        declarators = IASTDeclarator.EMPTY_DECLARATOR_ARRAY;
                        endOffset = this.calculateEndOffset(declSpec);
                        break;
                    }
                    endOffset = this.figureEndOffset(declSpec, (IASTDeclarator[])declarators);
                    if (lt1 == 0 || !this.isOnSameLine(endOffset, this.LA(1).getOffset()) || declarators.length == 1 && declarators[0] instanceof IASTFunctionDeclarator) break;
                }
                this.throwBacktrack(this.LA(1));
            }
        }
        boolean bl = isAmbiguous = altDeclSpec != null && altDtor != null && declarators.length == 1;
        if (isAmbiguous) {
            simpleDeclaration = this.nodeFactory.newSimpleDeclaration(altDeclSpec);
            simpleDeclaration.addDeclarator(altDtor);
        } else {
            simpleDeclaration = this.nodeFactory.newSimpleDeclaration(declSpec);
            Object[] objectArray = declarators;
            int n = declarators.length;
            int n2 = 0;
            while (n2 < n) {
                Object declarator = objectArray[n2];
                simpleDeclaration.addDeclarator((IASTDeclarator)declarator);
                ++n2;
            }
        }
        this.setRange(simpleDeclaration, firstOffset, endOffset);
        if (isAmbiguous) {
            simpleDeclaration = new CPPASTAmbiguousSimpleDeclaration(simpleDeclaration, declSpec, dtor);
            this.setRange(simpleDeclaration, firstOffset, endOffset);
        }
        if (insertSemi) {
            IASTProblem problem = this.createProblem(0x4000001, endOffset, 0);
            this.throwBacktrack(problem, simpleDeclaration);
        }
        return simpleDeclaration;
    }

    private IASTDeclaration functionDefinition(int firstOffset, IASTDeclSpecifier declSpec, IASTDeclarator outerDtor) throws EndOfFileException, BacktrackException {
        ICPPASTFunctionDefinition fdef;
        IASTDeclarator dtor = ASTQueries.findTypeRelevantDeclarator(outerDtor);
        if (!(dtor instanceof ICPPASTFunctionDeclarator)) {
            this.throwBacktrack(firstOffset, this.LA(1).getEndOffset() - firstOffset);
        }
        if (this.LT(1) == 115) {
            this.consume();
            fdef = this.nodeFactory.newFunctionTryBlock(declSpec, (ICPPASTFunctionDeclarator)dtor, null);
        } else {
            fdef = this.nodeFactory.newFunctionDefinition(declSpec, (ICPPASTFunctionDeclarator)dtor, null);
        }
        if (this.LT(1) == 4) {
            this.ctorInitializer(fdef);
        }
        try {
            IASTStatement body = this.handleFunctionBody();
            fdef.setBody(body);
            this.setRange(fdef, firstOffset, this.calculateEndOffset(body));
        }
        catch (BacktrackException bt) {
            IASTNode n = bt.getNodeBeforeProblem();
            if (n instanceof IASTCompoundStatement && !(fdef instanceof ICPPASTFunctionWithTryBlock)) {
                fdef.setBody((IASTCompoundStatement)n);
                this.setRange(fdef, firstOffset, this.calculateEndOffset(n));
                this.throwBacktrack(bt.getProblem(), fdef);
            }
            throw bt;
        }
        if (fdef instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTFunctionWithTryBlock tryblock = (ICPPASTFunctionWithTryBlock)fdef;
            ArrayList<ICPPASTCatchHandler> handlers = new ArrayList<ICPPASTCatchHandler>(4);
            this.catchHandlerSequence(handlers);
            ICPPASTCatchHandler last = null;
            for (ICPPASTCatchHandler catchHandler : handlers) {
                tryblock.addCatchHandler(catchHandler);
                last = catchHandler;
            }
            if (last != null) {
                this.adjustLength(tryblock, last);
            }
        }
        return fdef;
    }

    protected void ctorInitializer(ICPPASTFunctionDefinition fdef) throws EndOfFileException, BacktrackException {
        this.consume(4);
        while (true) {
            int endOffset;
            IASTInitializer init;
            int offset = this.LA(1).getOffset();
            IASTName name = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
            if (this.LT(1) != 141) {
                init = this.bracedOrCtorStyleInitializer();
                endOffset = this.calculateEndOffset(init);
            } else {
                init = null;
                endOffset = this.calculateEndOffset(name);
            }
            ICPPASTConstructorChainInitializer ctorInitializer = this.nodeFactory.newConstructorChainInitializer(name, init);
            if (this.LT(1) == 48) {
                ctorInitializer.setIsPackExpansion(true);
                endOffset = this.consume().getEndOffset();
            }
            fdef.addMemberInitializer(this.setRange(ctorInitializer, offset, endOffset));
            if (this.LT(1) != 6) break;
            this.consume();
        }
    }

    protected ICPPASTParameterDeclaration parameterDeclaration() throws BacktrackException, EndOfFileException {
        IASTDeclarator declarator;
        int startOffset = this.LA(1).getOffset();
        if (this.LT(1) == 10 && this.supportParameterInfoBlock) {
            this.skipBrackets(10, 11);
        }
        IASTDeclSpecifier declSpec = null;
        try {
            AbstractGNUSourceCodeParser.Decl decl = this.declSpecifierSequence_initDeclarator(DeclarationOptions.PARAMETER, false);
            declSpec = decl.fDeclSpec1;
            declarator = decl.fDtor1;
        }
        catch (AbstractGNUSourceCodeParser.FoundAggregateInitializer lie) {
            declSpec = lie.fDeclSpec;
            declarator = this.addInitializer(lie, DeclarationOptions.PARAMETER);
        }
        ICPPASTParameterDeclaration parm = this.nodeFactory.newParameterDeclaration(declSpec, declarator);
        int endOffset = this.figureEndOffset(declSpec, declarator);
        this.setRange(parm, startOffset, endOffset);
        return parm;
    }

    @Override
    protected AbstractGNUSourceCodeParser.Decl declSpecifierSeq(DeclarationOptions option) throws BacktrackException, EndOfFileException {
        return this.declSpecifierSeq(option, false);
    }

    private ICPPASTDeclSpecifier simpleTypeSpecifier() throws BacktrackException, EndOfFileException {
        AbstractGNUSourceCodeParser.Decl d = this.declSpecifierSeq(null, true);
        return (ICPPASTDeclSpecifier)d.fDeclSpec1;
    }

    private ICPPASTDeclSpecifier simpleTypeSpecifierSequence() throws BacktrackException, EndOfFileException {
        AbstractGNUSourceCodeParser.Decl d = this.declSpecifierSeq(null, false);
        return (ICPPASTDeclSpecifier)d.fDeclSpec1;
    }

    private AbstractGNUSourceCodeParser.Decl declSpecifierSeq(DeclarationOptions option, boolean single) throws BacktrackException, EndOfFileException {
        int storageClass = 0;
        int simpleType = 0;
        int options = 0;
        int isLong = 0;
        IToken returnToken = null;
        ICPPASTDeclSpecifier result = null;
        ICPPASTDeclSpecifier altResult = null;
        try {
            int offset;
            IASTName identifier = null;
            IASTExpression typeofExpression = null;
            IASTProblem problem = null;
            boolean isTypename = false;
            boolean encounteredRawType = false;
            boolean encounteredTypename = false;
            int endOffset = offset = this.LA(1).getOffset();
            block45: do {
                int lt1 = this.LTcatchEOF(1);
                switch (lt1) {
                    case 0: {
                        break block45;
                    }
                    case 57: {
                        if (this.supportAutoTypeSpecifier) {
                            if (encounteredTypename) break block45;
                            simpleType = 10;
                            encounteredRawType = true;
                            endOffset = this.consume().getEndOffset();
                            break;
                        }
                        storageClass = 4;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 101: {
                        storageClass = 5;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 106: {
                        storageClass = 3;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 80: {
                        storageClass = 2;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 90: {
                        storageClass = 6;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 116: {
                        storageClass = 1;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 87: {
                        options |= 1;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 122: {
                        options |= 0x200;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 78: {
                        options |= 0x400;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 84: {
                        options |= 0x800;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 67: {
                        options |= 2;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 124: {
                        options |= 8;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 137: {
                        options |= 4;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 108: {
                        if (encounteredTypename) break block45;
                        options |= 0x40;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 120: {
                        if (encounteredTypename) break block45;
                        options |= 0x20;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 104: {
                        if (encounteredTypename) break block45;
                        options |= 0x10;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 89: {
                        if (encounteredTypename) break block45;
                        ++isLong;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 135: {
                        if (encounteredTypename) break block45;
                        options |= 0x80;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 136: {
                        if (encounteredTypename) break block45;
                        options |= 0x100;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 64: {
                        if (encounteredTypename) break block45;
                        simpleType = 2;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 125: {
                        if (encounteredTypename) break block45;
                        simpleType = 7;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 5202: {
                        if (encounteredTypename) break block45;
                        simpleType = 11;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 5203: {
                        if (encounteredTypename) break block45;
                        simpleType = 12;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 60: {
                        if (encounteredTypename) break block45;
                        simpleType = 6;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 88: {
                        if (encounteredTypename) break block45;
                        simpleType = 3;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 82: {
                        if (encounteredTypename) break block45;
                        simpleType = 4;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 74: {
                        if (encounteredTypename) break block45;
                        simpleType = 5;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 123: {
                        if (encounteredTypename) break block45;
                        simpleType = 1;
                        encounteredRawType = true;
                        endOffset = this.consume().getEndOffset();
                        break;
                    }
                    case 118: {
                        if (encounteredTypename || encounteredRawType) break block45;
                        this.consume();
                        identifier = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
                        endOffset = this.calculateEndOffset(identifier);
                        isTypename = true;
                        encounteredTypename = true;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 34: 
                    case 140: {
                        if (encounteredRawType || encounteredTypename) break block45;
                        if (option != null && option.fAllowEmptySpecifier && this.LT(1) != 140 && (options & 0x9FE) == 0 && storageClass == 0) {
                            altResult = this.buildSimpleDeclSpec(storageClass, simpleType, options, isLong, typeofExpression, offset, endOffset);
                            returnToken = this.mark();
                        }
                        if ((identifier = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr)).getLookupKey().length == 0 && this.LT(1) != 141) {
                            this.throwBacktrack(this.LA(1));
                        }
                        endOffset = this.calculateEndOffset(identifier);
                        encounteredTypename = true;
                        break;
                    }
                    case 65: 
                    case 109: 
                    case 119: {
                        if (encounteredTypename || encounteredRawType) break block45;
                        try {
                            result = this.classSpecifier();
                        }
                        catch (BacktrackException backtrackException) {
                            result = this.elaboratedTypeSpecifier();
                        }
                        endOffset = this.calculateEndOffset(result);
                        encounteredTypename = true;
                        break;
                    }
                    case 77: {
                        if (encounteredTypename || encounteredRawType) break block45;
                        try {
                            result = this.enumDeclaration(option != null && option.fAllowOpaqueEnum);
                        }
                        catch (BacktrackException bt) {
                            if (bt.getNodeBeforeProblem() instanceof ICPPASTDeclSpecifier) {
                                result = (ICPPASTDeclSpecifier)bt.getNodeBeforeProblem();
                                problem = bt.getProblem();
                                break block45;
                            }
                            throw bt;
                        }
                        endOffset = this.calculateEndOffset(result);
                        encounteredTypename = true;
                        break;
                    }
                    case 154: {
                        if (!this.supportAttributeSpecifiers) {
                            this.throwBacktrack(this.LA(1));
                        }
                        this.__attribute_decl_seq(true, false);
                        break;
                    }
                    case 155: {
                        if (identifier != null || !this.supportDeclspecSpecifiers) {
                            this.throwBacktrack(this.LA(1));
                        }
                        this.__attribute_decl_seq(false, true);
                        break;
                    }
                    case 150: {
                        if (encounteredRawType || encounteredTypename) {
                            this.throwBacktrack(this.LA(1));
                        }
                        simpleType = 8;
                        this.consume(150);
                        typeofExpression = this.parseTypeidInParenthesisOrUnaryExpression(false, this.LA(1).getOffset(), 3, -1, AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
                        encounteredTypename = true;
                        endOffset = this.calculateEndOffset(typeofExpression);
                        break;
                    }
                    case 5204: {
                        if (encounteredRawType || encounteredTypename) {
                            this.throwBacktrack(this.LA(1));
                        }
                        simpleType = 9;
                        this.consume(5204);
                        this.consume(8);
                        typeofExpression = this.unaryExpression(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
                        endOffset = this.consumeOrEOC(9).getEndOffset();
                        encounteredTypename = true;
                        break;
                    }
                    default: {
                        if (lt1 < 243 || lt1 > 253) break block45;
                        this.handleOtherDeclSpecModifier();
                        endOffset = this.LA(1).getOffset();
                    }
                }
                if (!encounteredRawType || !encounteredTypename) continue;
                this.throwBacktrack(this.LA(1));
            } while (!single);
            if (!(encounteredRawType || encounteredTypename || this.LT(1) == 141 || option != null && option.fAllowEmptySpecifier)) {
                this.throwBacktrack(this.LA(1));
            }
            if (result != null) {
                this.configureDeclSpec(result, storageClass, options);
                this.setRange(result, offset, endOffset);
                if (problem != null) {
                    this.throwBacktrack(problem, result);
                }
            } else {
                result = identifier != null ? this.buildNamedTypeSpecifier(identifier, isTypename, storageClass, options, offset, endOffset) : this.buildSimpleDeclSpec(storageClass, simpleType, options, isLong, typeofExpression, offset, endOffset);
            }
        }
        catch (BacktrackException e) {
            if (returnToken != null) {
                this.backup(returnToken);
                result = altResult;
                altResult = null;
                returnToken = null;
            }
            throw e;
        }
        AbstractGNUSourceCodeParser.Decl target = new AbstractGNUSourceCodeParser.Decl();
        target.fDeclSpec1 = result;
        target.fDeclSpec2 = altResult;
        target.fDtorToken1 = returnToken;
        return target;
    }

    private ICPPASTNamedTypeSpecifier buildNamedTypeSpecifier(IASTName name, boolean isTypename, int storageClass, int options, int offset, int endOffset) {
        ICPPASTNamedTypeSpecifier declSpec = this.nodeFactory.newTypedefNameSpecifier(name);
        declSpec.setIsTypename(isTypename);
        this.configureDeclSpec(declSpec, storageClass, options);
        ((ASTNode)((Object)declSpec)).setOffsetAndLength(offset, endOffset - offset);
        return declSpec;
    }

    private ICPPASTSimpleDeclSpecifier buildSimpleDeclSpec(int storageClass, int simpleType, int options, int isLong, IASTExpression typeofExpression, int offset, int endOffset) {
        ICPPASTSimpleDeclSpecifier declSpec = this.nodeFactory.newSimpleDeclSpecifier();
        this.configureDeclSpec(declSpec, storageClass, options);
        declSpec.setType(simpleType);
        declSpec.setLong(isLong == 1);
        declSpec.setLongLong(isLong > 1);
        declSpec.setShort((options & 0x10) != 0);
        declSpec.setUnsigned((options & 0x20) != 0);
        declSpec.setSigned((options & 0x40) != 0);
        declSpec.setComplex((options & 0x80) != 0);
        declSpec.setImaginary((options & 0x100) != 0);
        declSpec.setDeclTypeExpression(typeofExpression);
        ((ASTNode)((Object)declSpec)).setOffsetAndLength(offset, endOffset - offset);
        return declSpec;
    }

    private void configureDeclSpec(ICPPASTDeclSpecifier declSpec, int storageClass, int options) {
        declSpec.setStorageClass(storageClass);
        declSpec.setConst((options & 2) != 0);
        declSpec.setVolatile((options & 8) != 0);
        declSpec.setInline((options & 1) != 0);
        declSpec.setFriend((options & 0x800) != 0);
        declSpec.setVirtual((options & 0x200) != 0);
        declSpec.setExplicit((options & 0x400) != 0);
        declSpec.setRestrict((options & 4) != 0);
    }

    private ICPPASTDeclSpecifier enumDeclaration(boolean allowOpaque) throws BacktrackException, EndOfFileException {
        boolean isOpaque;
        int lt1;
        IToken mark = this.mark();
        int offset = this.consume(77).getOffset();
        int endOffset = 0;
        boolean isScoped = false;
        IASTName name = null;
        ICPPASTDeclSpecifier baseType = null;
        try {
            lt1 = this.LT(1);
            if (lt1 == 65 || lt1 == 109) {
                isScoped = true;
                this.consume();
            }
            this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
            if (isScoped || this.LT(1) == 1) {
                name = this.identifier();
                endOffset = this.calculateEndOffset(name);
            }
            if (this.LT(1) == 4) {
                this.consume();
                baseType = this.simpleTypeSpecifierSequence();
                endOffset = this.calculateEndOffset(baseType);
            }
        }
        catch (BacktrackException backtrackException) {
            this.backup(mark);
            return this.elaboratedTypeSpecifier();
        }
        lt1 = this.LT(1);
        boolean isDef = lt1 == 12 || lt1 == 141 && baseType != null;
        boolean bl = isOpaque = !isDef && allowOpaque && lt1 == 5;
        if (!isDef && !isOpaque) {
            this.backup(mark);
            return this.elaboratedTypeSpecifier();
        }
        mark = null;
        if (isOpaque && !isScoped && baseType == null) {
            this.throwBacktrack(this.LA(1));
        }
        if (name == null) {
            if (isOpaque) {
                this.throwBacktrack(this.LA(1));
            }
            name = this.nodeFactory.newName();
        }
        ICPPASTEnumerationSpecifier result = this.nodeFactory.newEnumerationSpecifier(isScoped, name, baseType);
        result.setIsOpaque(isOpaque);
        if (lt1 == 12) {
            endOffset = this.enumBody(result);
        }
        assert (endOffset != 0);
        return this.setRange(result, offset, endOffset);
    }

    protected ICPPASTElaboratedTypeSpecifier elaboratedTypeSpecifier() throws BacktrackException, EndOfFileException {
        int lt1 = this.LT(1);
        int eck = 0;
        switch (lt1) {
            case 65: {
                eck = 3;
                break;
            }
            case 109: {
                eck = 1;
                break;
            }
            case 119: {
                eck = 2;
                break;
            }
            case 77: {
                eck = 0;
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        int offset = this.consume().getOffset();
        this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
        IASTName name = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
        return this.setRange(this.nodeFactory.newElaboratedTypeSpecifier(eck, name), offset, this.calculateEndOffset(name));
    }

    @Override
    protected IASTDeclarator initDeclarator(IASTDeclSpecifier declspec, DeclarationOptions option) throws EndOfFileException, BacktrackException, AbstractGNUSourceCodeParser.FoundAggregateInitializer {
        IToken mark = this.mark();
        IASTDeclarator dtor1 = null;
        IToken end1 = null;
        IASTDeclarator dtor2 = null;
        BacktrackException bt = null;
        try {
            dtor1 = this.initDeclarator(DtorStrategy.PREFER_FUNCTION, declspec, option);
            this.verifyDtor(declspec, dtor1, option);
            int lt1 = this.LTcatchEOF(1);
            switch (lt1) {
                case 0: {
                    return dtor1;
                }
                case 12: {
                    if (option.fCanBeFollowedByBrace || ASTQueries.findTypeRelevantDeclarator(dtor1) instanceof IASTFunctionDeclarator) {
                        return dtor1;
                    }
                    dtor1 = null;
                    this.throwBacktrack(this.LA(1));
                    break;
                }
                case 4: {
                    if (option != DeclarationOptions.CPP_MEMBER && option != DeclarationOptions.GLOBAL) break;
                }
                case 20: 
                case 67: 
                case 113: 
                case 115: 
                case 124: {
                    if (ASTQueries.findTypeRelevantDeclarator(dtor1) instanceof IASTFunctionDeclarator) {
                        return dtor1;
                    }
                    dtor1 = null;
                    this.throwBacktrack(this.LA(1));
                }
            }
            if (!(dtor1 instanceof IASTFunctionDeclarator)) {
                return dtor1;
            }
            end1 = this.LA(1);
        }
        catch (BacktrackException e) {
            bt = e;
        }
        if (!option.fAllowCtorStyleInitializer || !this.canHaveConstructorInitializer(declspec, dtor1)) {
            if (bt != null) {
                throw bt;
            }
            return dtor1;
        }
        this.backup(mark);
        try {
            dtor2 = this.initDeclarator(DtorStrategy.PREFER_NESTED, declspec, option);
            if (dtor1 == null) {
                return dtor2;
            }
        }
        catch (BacktrackException e) {
            if (dtor1 != null) {
                this.backup(end1);
                return dtor1;
            }
            throw e;
        }
        if (end1 != null && this.LA(1).getEndOffset() != end1.getEndOffset()) {
            this.backup(end1);
            return dtor1;
        }
        if (this.functionBodyCount != 0) {
            IASTDeclarator h = dtor1;
            dtor1 = dtor2;
            dtor2 = h;
        }
        CPPASTAmbiguousDeclarator dtor = new CPPASTAmbiguousDeclarator(dtor1, dtor2);
        dtor.setOffsetAndLength((ASTNode)((Object)dtor1));
        return dtor;
    }

    private void verifyDtor(IASTDeclSpecifier declspec, IASTDeclarator dtor, DeclarationOptions opt) throws BacktrackException {
        if (CPPVisitor.doesNotSpecifyType(declspec)) {
            if (ASTQueries.findTypeRelevantDeclarator(dtor) instanceof IASTFunctionDeclarator) {
                boolean isQualified = false;
                IASTName name = ASTQueries.findInnermostDeclarator(dtor).getName();
                if (name instanceof ICPPASTQualifiedName) {
                    isQualified = true;
                    name = name.getLastName();
                }
                if (name instanceof ICPPASTTemplateId) {
                    name = ((ICPPASTTemplateId)name).getTemplateName();
                }
                if (name instanceof ICPPASTConversionName) {
                    return;
                }
                char[] nchars = name.getLookupKey();
                if (nchars.length > 0 && nchars[0] == '~') {
                    return;
                }
                if (opt == DeclarationOptions.CPP_MEMBER ? CharArrayUtils.equals(nchars, this.currentClassName) : isQualified) {
                    return;
                }
            }
            ASTNode node = (ASTNode)((Object)dtor);
            this.throwBacktrack(node.getOffset(), node.getLength());
        }
    }

    private boolean canHaveConstructorInitializer(IASTDeclSpecifier declspec, IASTDeclarator dtor) {
        if (declspec instanceof ICPPASTDeclSpecifier) {
            ICPPASTDeclSpecifier cppspec = (ICPPASTDeclSpecifier)declspec;
            if (cppspec.isFriend()) {
                return false;
            }
            if (cppspec.getStorageClass() == 1) {
                return false;
            }
        }
        if (declspec instanceof ICPPASTSimpleDeclSpecifier) {
            ICPPASTSimpleDeclSpecifier sspec = (ICPPASTSimpleDeclSpecifier)declspec;
            if (CPPVisitor.doesNotSpecifyType(declspec)) {
                return false;
            }
            if (sspec.getType() == 1 && dtor != null && dtor.getPointerOperators().length == 0 && dtor.getNestedDeclarator() == null) {
                return false;
            }
        }
        if (dtor != null) {
            IASTName name = ASTQueries.findInnermostDeclarator(dtor).getName().getLastName();
            if (name instanceof ICPPASTTemplateId) {
                name = ((ICPPASTTemplateId)name).getTemplateName();
            }
            if (name instanceof ICPPASTOperatorName || name instanceof ICPPASTConversionName) {
                return false;
            }
        }
        return true;
    }

    private IASTDeclarator initDeclarator(DtorStrategy strategy, IASTDeclSpecifier declspec, DeclarationOptions option) throws EndOfFileException, BacktrackException, AbstractGNUSourceCodeParser.FoundAggregateInitializer {
        IASTDeclarator dtor = this.declarator(strategy, option);
        if (option.fAllowInitializer) {
            IASTDeclarator typeRelevantDtor = ASTQueries.findTypeRelevantDeclarator(dtor);
            if (option != DeclarationOptions.PARAMETER && typeRelevantDtor instanceof IASTFunctionDeclarator) {
                if (option == DeclarationOptions.CPP_MEMBER && this.LTcatchEOF(1) == 38 && this.LTcatchEOF(2) == 2) {
                    this.consume();
                    IToken t = this.consume();
                    char[] image = t.getCharImage();
                    if (image.length != 1 || image[0] != '0') {
                        this.throwBacktrack(t);
                    }
                    ((ICPPASTFunctionDeclarator)typeRelevantDtor).setPureVirtual(true);
                    this.adjustEndOffset(dtor, t.getEndOffset());
                }
            } else {
                if (this.LTcatchEOF(1) == 38 && this.LTcatchEOF(2) == 12) {
                    throw new AbstractGNUSourceCodeParser.FoundAggregateInitializer(declspec, dtor);
                }
                IASTInitializer initializer = this.optionalInitializer(option);
                if (initializer != null) {
                    if (initializer instanceof IASTInitializerList && ((IASTInitializerList)initializer).getSize() == 0) {
                        switch (this.LTcatchEOF(1)) {
                            case 5: 
                            case 6: 
                            case 9: {
                                break;
                            }
                            case 0: {
                                throw this.backtrack;
                            }
                            default: {
                                this.throwBacktrack(this.LA(1));
                            }
                        }
                    }
                    dtor.setInitializer(initializer);
                    this.adjustLength(dtor, initializer);
                }
            }
        }
        return dtor;
    }

    @Override
    protected IASTInitializer optionalInitializer(DeclarationOptions option) throws EndOfFileException, BacktrackException {
        int lt1 = this.LTcatchEOF(1);
        if (lt1 == 38) {
            int offset = this.consume().getOffset();
            IASTInitializerClause initClause = this.initClause(this.LT(1) == 12);
            IASTEqualsInitializer initExpr = this.nodeFactory.newEqualsInitializer(initClause);
            return this.setRange(initExpr, offset, this.calculateEndOffset(initClause));
        }
        if (option.fAllowBracedInitializer && lt1 == 12) {
            return this.bracedInitList(false);
        }
        if (option.fAllowCtorStyleInitializer && lt1 == 8) {
            return this.ctorStyleInitializer(false);
        }
        return null;
    }

    private IASTInitializer bracedOrCtorStyleInitializer() throws EndOfFileException, BacktrackException {
        int lt1 = this.LT(1);
        if (lt1 == 8) {
            return this.ctorStyleInitializer(true);
        }
        return this.bracedInitList(false);
    }

    private ICPPASTConstructorInitializer ctorStyleInitializer(boolean optionalExpressionList) throws EndOfFileException, BacktrackException {
        IASTInitializerClause[] initArray;
        int offset = this.consume(8).getOffset();
        if (optionalExpressionList && this.LT(1) == 9) {
            initArray = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        } else {
            List<IASTInitializerClause> exprList = this.expressionList();
            initArray = exprList.toArray(new IASTInitializerClause[exprList.size()]);
        }
        int endOffset = this.consumeOrEOC(9).getEndOffset();
        return this.setRange(this.nodeFactory.newConstructorInitializer(initArray), offset, endOffset);
    }

    private List<IASTInitializerClause> expressionList() throws EndOfFileException, BacktrackException {
        return this.initializerList(false);
    }

    private IASTInitializerClause initClause(boolean allowSkipping) throws EndOfFileException, BacktrackException {
        if (this.LT(1) == 12) {
            return this.bracedInitList(allowSkipping);
        }
        BinaryExprCtx ctx = this.fInTemplateParameterList ? BinaryExprCtx.eTmplID : BinaryExprCtx.eNoTmplID;
        IASTExpression assignmentExpression = this.expression(AbstractGNUSourceCodeParser.ExprKind.eAssignment, ctx, null);
        if (allowSkipping && this.skipTrivialExpressionsInAggregateInitializers && !ASTQueries.canContainName(assignmentExpression)) {
            return null;
        }
        return assignmentExpression;
    }

    private ICPPASTInitializerList bracedInitList(boolean allowSkipping) throws EndOfFileException, BacktrackException {
        int offset = this.consume(12).getOffset();
        if (this.LT(1) == 13) {
            return this.setRange(this.nodeFactory.newInitializerList(), offset, this.consume().getEndOffset());
        }
        List<IASTInitializerClause> initList = this.initializerList(allowSkipping);
        if (this.LT(1) == 6) {
            this.consume();
        }
        int endOffset = this.consumeOrEOC(13).getEndOffset();
        ICPPASTInitializerList result = this.nodeFactory.newInitializerList();
        for (IASTInitializerClause init : initList) {
            result.addClause(init);
        }
        return this.setRange(result, offset, endOffset);
    }

    private List<IASTInitializerClause> initializerList(boolean allowSkipping) throws EndOfFileException, BacktrackException {
        ArrayList<IASTInitializerClause> result = null;
        block3: while (true) {
            IASTInitializerClause clause = this.initClause(allowSkipping);
            if (this.LT(1) == 48) {
                int endOffset = this.consume(48).getEndOffset();
                if (clause instanceof ICPPASTPackExpandable) {
                    ((ICPPASTPackExpandable)((Object)clause)).setIsPackExpansion(true);
                    this.adjustEndOffset(clause, endOffset);
                } else if (clause instanceof IASTExpression) {
                    ICPPASTPackExpansionExpression packExpansion = this.nodeFactory.newPackExpansionExpression((IASTExpression)clause);
                    clause = this.setRange(packExpansion, clause, endOffset);
                }
            }
            if (result == null) {
                result = new ArrayList<IASTInitializerClause>();
            }
            result.add(clause);
            if (this.LT(1) != 6) break;
            switch (this.LT(2)) {
                case 9: 
                case 13: 
                case 141: {
                    break block3;
                }
                default: {
                    this.consume(6);
                    continue block3;
                }
            }
            break;
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    protected ICPPASTTypeId typeId(DeclarationOptions option) throws EndOfFileException, BacktrackException {
        if (!this.canBeTypeSpecifier()) {
            this.throwBacktrack(this.LA(1));
        }
        int offset = this.LA().getOffset();
        IASTDeclSpecifier declSpecifier = null;
        IASTDeclarator declarator = null;
        try {
            AbstractGNUSourceCodeParser.Decl decl = this.declSpecifierSequence_initDeclarator(option, false);
            declSpecifier = decl.fDeclSpec1;
            declarator = decl.fDtor1;
        }
        catch (AbstractGNUSourceCodeParser.FoundAggregateInitializer lie) {
            this.throwBacktrack(lie.fDeclarator);
        }
        ICPPASTTypeId result = this.nodeFactory.newTypeId(declSpecifier, declarator);
        this.setRange(result, offset, this.figureEndOffset(declSpecifier, declarator));
        return result;
    }

    protected IASTDeclarator declarator(DtorStrategy strategy, DeclarationOptions option) throws EndOfFileException, BacktrackException {
        int startingOffset;
        int endOffset = startingOffset = this.LA(1).getOffset();
        List<? extends IASTPointerOperator> pointerOps = this.consumePointerOperators();
        if (pointerOps != null) {
            endOffset = this.calculateEndOffset(pointerOps.get(pointerOps.size() - 1));
        }
        this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
        boolean hasEllipsis = false;
        if (option.fAllowParameterPacks && this.LT(1) == 48) {
            this.consume();
            hasEllipsis = true;
        }
        int lt1 = this.LT(1);
        switch (lt1) {
            case 1: 
            case 3: 
            case 34: 
            case 95: 
            case 140: {
                if (option.fRequireAbstract) {
                    this.throwBacktrack(this.LA(1));
                }
                IASTName declaratorName = !option.fRequireSimpleName ? this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr) : this.identifier();
                endOffset = this.calculateEndOffset(declaratorName);
                return this.declarator(pointerOps, hasEllipsis, declaratorName, null, startingOffset, endOffset, strategy, option);
            }
        }
        if (lt1 == 8) {
            IToken cand1End;
            IASTDeclarator cand1;
            block20: {
                cand1 = null;
                cand1End = null;
                if (option.fAllowAbstract && option.fAllowFunctions) {
                    IToken mark = this.mark();
                    try {
                        cand1 = this.declarator(pointerOps, hasEllipsis, this.nodeFactory.newName(), null, startingOffset, endOffset, strategy, option);
                        if (option.fRequireAbstract || !option.fAllowNested || hasEllipsis) {
                            return cand1;
                        }
                        cand1End = this.LA(1);
                    }
                    catch (BacktrackException backtrackException) {}
                    this.backup(mark);
                }
                if (!option.fAllowNested || hasEllipsis) {
                    if (option.fAllowAbstract) {
                        return this.declarator(pointerOps, hasEllipsis, this.nodeFactory.newName(), null, startingOffset, endOffset, strategy, option);
                    }
                    this.throwBacktrack(this.LA(1));
                }
                try {
                    this.consume();
                    if (this.LT(1) == 9) {
                        this.throwBacktrack(this.LA(1));
                    }
                    IASTDeclarator nested = this.declarator(DtorStrategy.PREFER_FUNCTION, option);
                    endOffset = this.consume(9).getEndOffset();
                    IASTDeclarator cand2 = this.declarator(pointerOps, hasEllipsis, this.nodeFactory.newName(), nested, startingOffset, endOffset, strategy, option);
                    if (cand1 == null || cand1End == null) {
                        return cand2;
                    }
                    IToken cand2End = this.LA(1);
                    if (cand1End == cand2End) {
                        CPPASTAmbiguousDeclarator result = new CPPASTAmbiguousDeclarator(cand1, cand2);
                        result.setOffsetAndLength((ASTNode)((Object)cand1));
                        return result;
                    }
                    if (cand1End.getOffset() < cand2End.getOffset()) {
                        return cand2;
                    }
                }
                catch (BacktrackException e) {
                    if (cand1 != null) break block20;
                    throw e;
                }
            }
            this.backup(cand1End);
            return cand1;
        }
        if (!(option.fAllowAbstract || option.fAllowBitField && this.LT(1) == 4)) {
            this.throwBacktrack(this.LA(1));
        }
        return this.declarator(pointerOps, hasEllipsis, this.nodeFactory.newName(), null, startingOffset, endOffset, strategy, option);
    }

    private List<? extends IASTPointerOperator> consumePointerOperators() throws EndOfFileException, BacktrackException {
        ArrayList<IASTPointer> result = null;
        while (true) {
            IASTPointer pointer;
            this.__attribute_decl_seq(this.supportAttributeSpecifiers, false);
            int lt1 = this.LT(1);
            if (lt1 == 30 || lt1 == 29) {
                IToken endToken = this.consume();
                int offset = endToken.getOffset();
                if (this.allowCPPRestrict && this.LT(1) == 137) {
                    endToken = this.consume();
                }
                ICPPASTReferenceOperator refOp = this.nodeFactory.newReferenceOperator(lt1 == 29);
                this.setRange(refOp, offset, endToken.getEndOffset());
                if (result != null) {
                    result.add((IASTPointer)((Object)refOp));
                    return result;
                }
                return Collections.singletonList(refOp);
            }
            IToken mark = this.mark();
            int startOffset = mark.getOffset();
            boolean isConst = false;
            boolean isVolatile = false;
            boolean isRestrict = false;
            IASTName name = null;
            int coloncolon = this.LT(1) == 3 ? 1 : 0;
            block12: while (this.LTcatchEOF(coloncolon + 1) == 1) {
                switch (this.LTcatchEOF(coloncolon + 2)) {
                    case 3: {
                        coloncolon += 2;
                        break;
                    }
                    case 42: {
                        coloncolon = 1;
                        break block12;
                    }
                    default: {
                        coloncolon = 0;
                        break block12;
                    }
                }
            }
            if (coloncolon != 0) {
                try {
                    name = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
                    if (name.getLookupKey().length != 0) {
                        this.backup(mark);
                        return result;
                    }
                }
                catch (BacktrackException backtrackException) {
                    this.backup(mark);
                    return result;
                }
            }
            if (this.LTcatchEOF(1) != 23) {
                this.backup(mark);
                return result;
            }
            int endOffset = this.consume().getEndOffset();
            block13: while (true) {
                switch (this.LTcatchEOF(1)) {
                    case 67: {
                        endOffset = this.consume().getEndOffset();
                        isConst = true;
                        continue block13;
                    }
                    case 124: {
                        endOffset = this.consume().getEndOffset();
                        isVolatile = true;
                        continue block13;
                    }
                    case 137: {
                        if (!this.allowCPPRestrict) {
                            this.throwBacktrack(this.LA(1));
                        }
                        endOffset = this.consume().getEndOffset();
                        isRestrict = true;
                        continue block13;
                    }
                }
                break;
            }
            if (name != null) {
                if (isRestrict) {
                    IGPPASTPointerToMember gppp2m = this.nodeFactory.newPointerToMemberGPP(name);
                    gppp2m.setRestrict(true);
                    pointer = gppp2m;
                } else {
                    pointer = this.nodeFactory.newPointerToMember(name);
                }
            } else if (isRestrict) {
                IGPPASTPointer gpppo = this.nodeFactory.newPointerGPP();
                gpppo.setRestrict(true);
                pointer = gpppo;
            } else {
                pointer = this.nodeFactory.newPointer();
            }
            pointer.setConst(isConst);
            pointer.setVolatile(isVolatile);
            this.setRange(pointer, startOffset, endOffset);
            if (result == null) {
                result = new ArrayList<IASTPointer>(4);
            }
            result.add(pointer);
        }
    }

    private IASTDeclarator declarator(List<? extends IASTPointerOperator> pointerOps, boolean hasEllipsis, IASTName declaratorName, IASTDeclarator nestedDeclarator, int startingOffset, int endOffset, DtorStrategy strategy, DeclarationOptions option) throws EndOfFileException, BacktrackException {
        ICPPASTDeclarator result = null;
        block7: while (true) {
            int n = this.LTcatchEOF(1);
            switch (n) {
                case 8: {
                    if (!option.fAllowFunctions || strategy != DtorStrategy.PREFER_FUNCTION) break block7;
                    result = this.functionDeclarator();
                    this.setDeclaratorID(result, hasEllipsis, declaratorName, nestedDeclarator);
                    break block7;
                }
                case 10: {
                    result = this.arrayDeclarator(option);
                    this.setDeclaratorID(result, hasEllipsis, declaratorName, nestedDeclarator);
                    break block7;
                }
                case 4: {
                    if (!option.fAllowBitField || nestedDeclarator != null) break block7;
                    result = this.bitFieldDeclarator();
                    this.setDeclaratorID(result, hasEllipsis, declaratorName, nestedDeclarator);
                    break block7;
                }
                case 154: {
                    if (!this.supportAttributeSpecifiers) {
                        this.throwBacktrack(this.LA(1));
                    }
                    this.__attribute_decl_seq(true, this.supportDeclspecSpecifiers);
                    continue block7;
                }
                case 155: {
                    if (!this.supportDeclspecSpecifiers) {
                        this.throwBacktrack(this.LA(1));
                    }
                    this.__attribute_decl_seq(this.supportAttributeSpecifiers, true);
                    continue block7;
                }
            }
            break;
        }
        this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
        if (result == null) {
            result = this.nodeFactory.newDeclarator(null);
            this.setDeclaratorID(result, hasEllipsis, declaratorName, nestedDeclarator);
        } else {
            endOffset = this.calculateEndOffset(result);
        }
        if (this.LTcatchEOF(1) == 56) {
            this.consume();
            endOffset = this.asmExpression(null).getEndOffset();
            this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
        }
        if (pointerOps != null) {
            for (IASTPointerOperator iASTPointerOperator : pointerOps) {
                result.addPointerOperator(iASTPointerOperator);
            }
        }
        ((ASTNode)((Object)result)).setOffsetAndLength(startingOffset, endOffset - startingOffset);
        return result;
    }

    private void setDeclaratorID(ICPPASTDeclarator declarator, boolean hasEllipsis, IASTName declaratorName, IASTDeclarator nestedDeclarator) {
        if (nestedDeclarator != null) {
            declarator.setNestedDeclarator(nestedDeclarator);
            declarator.setName(this.nodeFactory.newName());
        } else {
            declarator.setName(declaratorName);
        }
        declarator.setDeclaresParameterPack(hasEllipsis);
    }

    private ICPPASTDeclarator functionDeclarator() throws EndOfFileException, BacktrackException {
        ICPPASTDeclarator dtor;
        IToken last = this.consume(8);
        int startOffset = last.getOffset();
        int endOffset = last.getEndOffset();
        ICPPASTFunctionDeclarator fc = this.nodeFactory.newFunctionDeclarator(null);
        ICPPASTParameterDeclaration pd = null;
        block15: while (true) {
            switch (this.LT(1)) {
                case 9: 
                case 141: {
                    endOffset = this.consume().getEndOffset();
                    break block15;
                }
                case 48: {
                    this.consume();
                    endOffset = this.consume(9).getEndOffset();
                    fc.setVarArgs(true);
                    break block15;
                }
                case 6: {
                    if (pd == null) {
                        this.throwBacktrack(this.LA(1));
                    }
                    endOffset = this.consume().getEndOffset();
                    pd = null;
                    continue block15;
                }
                default: {
                    if (pd != null) {
                        this.throwBacktrack(startOffset, endOffset - startOffset);
                    }
                    pd = this.parameterDeclaration();
                    fc.addParameterDeclaration(pd);
                    endOffset = this.calculateEndOffset(pd);
                    continue block15;
                }
            }
            break;
        }
        if (pd != null && (dtor = pd.getDeclarator()) != null && !(dtor instanceof IASTAmbiguousDeclarator) && dtor.declaresParameterPack() && dtor.getNestedDeclarator() == null && dtor.getInitializer() == null && dtor.getName().getSimpleID().length == 0) {
            ((IASTAmbiguityParent)((Object)fc)).replace(pd, new CPPASTAmbiguousParameterDeclaration(pd));
        }
        this.__attribute_decl_seq(this.supportAttributeSpecifiers, false);
        block16: while (true) {
            switch (this.LT(1)) {
                case 67: {
                    fc.setConst(true);
                    endOffset = this.consume().getEndOffset();
                    continue block16;
                }
                case 124: {
                    fc.setVolatile(true);
                    endOffset = this.consume().getEndOffset();
                    continue block16;
                }
            }
            break;
        }
        if (this.LT(1) == 113) {
            fc.setEmptyExceptionSpecification();
            this.consume();
            this.consume(8);
            block17: while (true) {
                switch (this.LT(1)) {
                    case 9: 
                    case 141: {
                        endOffset = this.consume().getEndOffset();
                        break block17;
                    }
                    case 6: {
                        this.consume();
                        continue block17;
                    }
                    default: {
                        int thoffset = this.LA(1).getOffset();
                        try {
                            ICPPASTTypeId typeId = this.typeId(DeclarationOptions.TYPEID);
                            if (this.LT(1) == 48) {
                                typeId.setIsPackExpansion(true);
                                this.adjustEndOffset(typeId, this.consume().getEndOffset());
                            }
                            fc.addExceptionSpecificationTypeId(typeId);
                        }
                        catch (BacktrackException backtrackException) {
                            int thendoffset = this.LA(1).getOffset();
                            if (thoffset == thendoffset) {
                                thendoffset = this.consume().getEndOffset();
                            }
                            IASTProblem p = this.createProblem(0x4000001, thoffset, thendoffset - thoffset);
                            IASTProblemTypeId typeIdProblem = this.nodeFactory.newProblemTypeId(p);
                            ((ASTNode)((Object)typeIdProblem)).setOffsetAndLength((ASTNode)((Object)p));
                            fc.addExceptionSpecificationTypeId(typeIdProblem);
                        }
                        continue block17;
                    }
                }
                break;
            }
            this.__attribute_decl_seq(this.supportAttributeSpecifiers, false);
        }
        if (this.LT(1) == 20) {
            this.consume();
            ICPPASTTypeId typeId = this.typeId(DeclarationOptions.TYPEID_TRAILING_RETURN_TYPE);
            fc.setTrailingReturnType(typeId);
            endOffset = this.calculateEndOffset(typeId);
        }
        this.setRange(fc, startOffset, endOffset);
        return fc;
    }

    private ICPPASTArrayDeclarator arrayDeclarator(DeclarationOptions option) throws EndOfFileException, BacktrackException {
        ArrayList<IASTArrayModifier> arrayMods = new ArrayList<IASTArrayModifier>(4);
        int start = this.LA(1).getOffset();
        this.consumeArrayModifiers(option, arrayMods);
        if (arrayMods.isEmpty()) {
            this.throwBacktrack(this.LA(1));
        }
        int endOffset = this.calculateEndOffset(arrayMods.get(arrayMods.size() - 1));
        ICPPASTArrayDeclarator d = this.nodeFactory.newArrayDeclarator(null);
        for (IASTArrayModifier m : arrayMods) {
            d.addArrayModifier(m);
        }
        ((ASTNode)((Object)d)).setOffsetAndLength(start, endOffset - start);
        return d;
    }

    private ICPPASTFieldDeclarator bitFieldDeclarator() throws EndOfFileException, BacktrackException {
        int start = this.consume(4).getOffset();
        IASTExpression bitField = this.constantExpression();
        int endOffset = this.calculateEndOffset(bitField);
        ICPPASTFieldDeclarator d = this.nodeFactory.newFieldDeclarator(null, bitField);
        ((ASTNode)((Object)d)).setOffsetAndLength(start, endOffset - start);
        return d;
    }

    protected ICPPASTCompositeTypeSpecifier classSpecifier() throws BacktrackException, EndOfFileException {
        int classKind = 0;
        IToken mark = this.mark();
        int offset = mark.getOffset();
        switch (this.LT(1)) {
            case 65: {
                this.consume();
                classKind = 3;
                break;
            }
            case 109: {
                this.consume();
                classKind = 1;
                break;
            }
            case 119: {
                this.consume();
                classKind = 2;
                break;
            }
            default: {
                this.throwBacktrack(mark);
                return null;
            }
        }
        this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
        IASTName name = null;
        name = this.LT(1) == 1 ? this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr) : this.nodeFactory.newName();
        this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
        ICPPASTCompositeTypeSpecifier astClassSpecifier = this.nodeFactory.newCompositeTypeSpecifier(classKind, name);
        if (this.LT(1) == 4) {
            this.baseClause(astClassSpecifier);
            if (this.LT(1) == 141) {
                return astClassSpecifier;
            }
        }
        if (this.LT(1) != 12) {
            IToken errorPoint = this.LA(1);
            this.backup(mark);
            this.throwBacktrack(errorPoint);
        }
        mark = null;
        char[] outerName = this.currentClassName;
        this.currentClassName = name.getLookupKey();
        try {
            this.declarationListInBraces(astClassSpecifier, offset, DeclarationOptions.CPP_MEMBER);
        }
        finally {
            this.currentClassName = outerName;
        }
        return astClassSpecifier;
    }

    protected int token2Visibility(int type) {
        switch (type) {
            case 100: {
                return 1;
            }
            case 99: {
                return 2;
            }
            case 98: {
                return 3;
            }
        }
        return 0;
    }

    private void baseClause(ICPPASTCompositeTypeSpecifier astClassSpec) throws EndOfFileException, BacktrackException {
        this.consume(4);
        while (true) {
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpec = this.baseSpecifier();
            astClassSpec.addBaseSpecifier(baseSpec);
            if (this.LT(1) == 48) {
                baseSpec.setIsPackExpansion(true);
                this.adjustEndOffset(baseSpec, this.consume().getEndOffset());
            }
            if (this.LT(1) != 6) {
                return;
            }
            this.consume();
        }
    }

    private ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier() throws EndOfFileException, BacktrackException {
        int startOffset = this.LA(1).getOffset();
        boolean isVirtual = false;
        int visibility = 0;
        IASTName name = null;
        block6: while (true) {
            switch (this.LT(1)) {
                case 122: {
                    isVirtual = true;
                    this.consume();
                    continue block6;
                }
                case 100: {
                    visibility = 1;
                    this.consume();
                    continue block6;
                }
                case 99: {
                    visibility = 2;
                    this.consume();
                    continue block6;
                }
                case 98: {
                    visibility = 3;
                    this.consume();
                    continue block6;
                }
            }
            break;
        }
        name = this.qualifiedName(AbstractGNUSourceCodeParser.CastExprCtx.eNotBExpr);
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpec = this.nodeFactory.newBaseSpecifier(name, visibility, isVirtual);
        this.setRange(baseSpec, startOffset, this.calculateEndOffset(name));
        return baseSpec;
    }

    protected void catchHandlerSequence(List<ICPPASTCatchHandler> collection) throws EndOfFileException, BacktrackException {
        if (this.LT(1) == 141) {
            return;
        }
        if (this.LT(1) != 63) {
            this.throwBacktrack(this.LA(1));
        }
        int lt1 = this.LT(1);
        while (lt1 == 63) {
            int startOffset = this.consume().getOffset();
            this.consume(8);
            boolean isEllipsis = false;
            IASTDeclaration decl = null;
            try {
                if (this.LT(1) == 48) {
                    this.consume(48);
                    isEllipsis = true;
                } else {
                    decl = this.simpleSingleDeclaration(DeclarationOptions.EXCEPTION);
                }
                if (this.LT(1) != 141) {
                    this.consume(9);
                }
            }
            catch (BacktrackException bte) {
                this.failParse();
                IASTProblem p = this.createProblem(bte);
                IASTProblemDeclaration pd = this.nodeFactory.newProblemDeclaration(p);
                ((ASTNode)((Object)pd)).setOffsetAndLength((ASTNode)((Object)p));
                decl = pd;
            }
            ICPPASTCatchHandler handler = this.nodeFactory.newCatchHandler(decl, null);
            if (this.LT(1) != 141) {
                IASTStatement compoundStatement = this.catchBlockCompoundStatement();
                ((ASTNode)((Object)handler)).setOffsetAndLength(startOffset, this.calculateEndOffset(compoundStatement) - startOffset);
                handler.setIsCatchAll(isEllipsis);
                if (compoundStatement != null) {
                    handler.setCatchBody(compoundStatement);
                }
            }
            collection.add(handler);
            lt1 = this.LTcatchEOF(1);
        }
    }

    private IASTSimpleDeclaration simpleSingleDeclaration(DeclarationOptions options) throws BacktrackException, EndOfFileException {
        IASTDeclarator declarator;
        IASTDeclSpecifier declSpec;
        int startOffset = this.LA(1).getOffset();
        try {
            AbstractGNUSourceCodeParser.Decl decl = this.declSpecifierSequence_initDeclarator(options, true);
            declSpec = decl.fDeclSpec1;
            declarator = decl.fDtor1;
        }
        catch (AbstractGNUSourceCodeParser.FoundAggregateInitializer lie) {
            declSpec = lie.fDeclSpec;
            declarator = this.addInitializer(lie, options);
        }
        int endOffset = this.figureEndOffset(declSpec, declarator);
        IASTSimpleDeclaration decl = this.nodeFactory.newSimpleDeclaration(declSpec);
        if (declarator != null) {
            decl.addDeclarator(declarator);
        }
        ((ASTNode)((Object)decl)).setOffsetAndLength(startOffset, endOffset - startOffset);
        return decl;
    }

    protected IASTStatement catchBlockCompoundStatement() throws BacktrackException, EndOfFileException {
        if (this.mode == ParserMode.QUICK_PARSE || this.mode == ParserMode.STRUCTURAL_PARSE || !this.isActiveCode()) {
            int offset = this.LA(1).getOffset();
            IToken last = this.skipOverCompoundStatement();
            IASTCompoundStatement cs = this.nodeFactory.newCompoundStatement();
            this.setRange(cs, offset, last.getEndOffset());
            return cs;
        }
        if (this.mode == ParserMode.COMPLETION_PARSE || this.mode == ParserMode.SELECTION_PARSE) {
            if (this.scanner.isOnTopContext()) {
                return this.compoundStatement();
            }
            int offset = this.LA(1).getOffset();
            IToken last = this.skipOverCompoundStatement();
            IASTCompoundStatement cs = this.nodeFactory.newCompoundStatement();
            this.setRange(cs, offset, last.getEndOffset());
            return cs;
        }
        return this.compoundStatement();
    }

    @Override
    protected void setupTranslationUnit() throws DOMException {
        this.translationUnit = this.nodeFactory.newTranslationUnit(this.scanner);
        this.translationUnit.setIndex(this.index);
        if (this.builtinBindingsProvider != null) {
            IBinding[] bindings;
            IScope tuScope = this.translationUnit.getScope();
            IBinding[] iBindingArray = bindings = this.builtinBindingsProvider.getBuiltinBindings(tuScope);
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding binding = iBindingArray[n2];
                ASTInternal.addBinding(tuScope, binding);
                ++n2;
            }
        }
    }

    private void consumeArrayModifiers(DeclarationOptions option, List<IASTArrayModifier> collection) throws EndOfFileException, BacktrackException {
        boolean allowExpression = option == DeclarationOptions.TYPEID_NEW;
        while (this.LT(1) == 10) {
            int l;
            int o = this.consume().getOffset();
            IASTExpression exp = null;
            if (this.LT(1) != 11 && this.LT(1) != 141) {
                exp = allowExpression ? this.expression() : this.constantExpression();
                allowExpression = false;
            }
            switch (this.LT(1)) {
                case 11: 
                case 141: {
                    l = this.consume().getEndOffset();
                    break;
                }
                default: {
                    throw this.backtrack;
                }
            }
            IASTArrayModifier arrayMod = this.nodeFactory.newArrayModifier(exp);
            ((ASTNode)((Object)arrayMod)).setOffsetAndLength(o, l - o);
            collection.add(arrayMod);
        }
    }

    @Override
    protected IASTTranslationUnit getTranslationUnit() {
        return this.translationUnit;
    }

    @Override
    protected IASTStatement statement() throws EndOfFileException, BacktrackException {
        switch (this.LT(1)) {
            case 62: {
                return this.parseCaseStatement();
            }
            case 71: {
                return this.parseDefaultStatement();
            }
            case 12: {
                return this.parseCompoundStatement();
            }
            case 86: {
                return this.parseIfStatement();
            }
            case 110: {
                return this.parseSwitchStatement();
            }
            case 126: {
                return this.parseWhileStatement();
            }
            case 73: {
                return this.parseDoStatement();
            }
            case 83: {
                return this.parseForStatement();
            }
            case 61: {
                return this.parseBreakStatement();
            }
            case 70: {
                return this.parseContinueStatement();
            }
            case 103: {
                return this.parseReturnStatement();
            }
            case 85: {
                return this.parseGotoStatement();
            }
            case 5: {
                return this.parseNullStatement();
            }
            case 115: {
                return this.parseTryStatement();
            }
        }
        if (this.LT(1) == 1 && this.LT(2) == 4) {
            return this.parseLabelStatement();
        }
        return this.parseDeclarationOrExpressionStatement(DeclarationOptions.LOCAL);
    }

    protected IASTStatement parseTryStatement() throws EndOfFileException, BacktrackException {
        int startO = this.consume().getOffset();
        IASTCompoundStatement tryBlock = this.compoundStatement();
        ArrayList<ICPPASTCatchHandler> catchHandlers = new ArrayList<ICPPASTCatchHandler>(4);
        this.catchHandlerSequence(catchHandlers);
        ICPPASTTryBlockStatement tryStatement = this.nodeFactory.newTryBlockStatement(tryBlock);
        ((ASTNode)((Object)tryStatement)).setOffset(startO);
        int i = 0;
        while (i < catchHandlers.size()) {
            ICPPASTCatchHandler handler = (ICPPASTCatchHandler)catchHandlers.get(i);
            tryStatement.addCatchHandler(handler);
            ((ASTNode)((Object)tryStatement)).setLength(this.calculateEndOffset(handler) - startO);
            ++i;
        }
        return tryStatement;
    }

    @Override
    protected void nullifyTranslationUnit() {
        this.translationUnit = null;
    }

    @Override
    protected IASTStatement parseWhileStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        this.consume(8);
        IASTNode while_condition = this.cppStyleCondition(9);
        switch (this.LT(1)) {
            case 9: {
                this.consume();
                break;
            }
            case 141: {
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        IASTStatement while_body = null;
        if (this.LT(1) != 141) {
            while_body = this.statement();
        }
        ICPPASTWhileStatement while_statement = while_condition instanceof IASTExpression ? this.nodeFactory.newWhileStatement((IASTExpression)while_condition, while_body) : this.nodeFactory.newWhileStatement((IASTDeclaration)while_condition, while_body);
        ((ASTNode)((Object)while_statement)).setOffsetAndLength(startOffset, (while_body != null ? this.calculateEndOffset(while_body) : this.LA(1).getEndOffset()) - startOffset);
        return while_statement;
    }

    protected IASTNode cppStyleCondition(int expectToken) throws BacktrackException, EndOfFileException {
        IToken end;
        IASTSimpleDeclaration decl;
        block10: {
            IASTExpression e = null;
            decl = null;
            end = null;
            IToken mark = this.mark();
            try {
                decl = this.simpleSingleDeclaration(DeclarationOptions.CONDITION);
                end = this.LA(1);
                int la = end.getType();
                if (la != expectToken && la != 141) {
                    end = null;
                    decl = null;
                }
            }
            catch (BacktrackException backtrackException) {}
            this.backup(mark);
            try {
                int endOffset2;
                e = this.expression();
                IToken end2 = this.LA(1);
                int la = end2.getType();
                if (la != expectToken && la != 141) {
                    this.throwBacktrack(end2);
                }
                if (end == null) {
                    return e;
                }
                int endOffset = end.getOffset();
                if (endOffset == (endOffset2 = end2.getOffset())) {
                    CPPASTAmbiguousCondition ambig = new CPPASTAmbiguousCondition(e, decl);
                    this.setRange(ambig, e);
                    return ambig;
                }
                if (endOffset < endOffset2) {
                    return e;
                }
            }
            catch (BacktrackException bt) {
                if (end != null) break block10;
                if (expectToken == 9) {
                    this.backup(mark);
                    return this.skipProblemConditionInParenthesis(mark.getOffset());
                }
                throw bt;
            }
        }
        this.backup(end);
        return decl;
    }

    @Override
    protected ASTVisitor createAmbiguityNodeVisitor() {
        return new CPPASTAmbiguityResolver();
    }

    @Override
    protected IASTAmbiguousStatement createAmbiguousStatement() {
        return new CPPASTAmbiguousStatement(new IASTStatement[0]);
    }

    protected IASTStatement parseIfStatement() throws EndOfFileException, BacktrackException {
        IASTIfStatement result;
        block22: {
            ICPPASTIfStatement new_if_statement;
            IASTStatement thenClause;
            int start;
            IASTIfStatement if_statement;
            block21: {
                result = null;
                if_statement = null;
                start = this.LA(1).getOffset();
                while (true) {
                    int so = this.consume(86).getOffset();
                    this.consume(8);
                    IASTNode condition = this.cppStyleCondition(9);
                    if (this.LT(1) == 141) {
                        ICPPASTIfStatement new_if = this.nodeFactory.newIfStatement();
                        if (condition instanceof IASTExpression) {
                            new_if.setConditionExpression((IASTExpression)condition);
                        } else if (condition instanceof IASTDeclaration) {
                            new_if.setConditionDeclaration((IASTDeclaration)condition);
                        }
                        if (if_statement != null) {
                            if_statement.setElseClause(new_if);
                        }
                        return result != null ? result : new_if;
                    }
                    this.consume(9);
                    thenClause = this.statement();
                    new_if_statement = this.nodeFactory.newIfStatement();
                    ((ASTNode)((Object)new_if_statement)).setOffset(so);
                    if (condition != null && (condition instanceof IASTExpression || condition instanceof IASTDeclaration)) {
                        if (condition instanceof IASTExpression) {
                            new_if_statement.setConditionExpression((IASTExpression)condition);
                        } else if (condition instanceof IASTDeclaration) {
                            new_if_statement.setConditionDeclaration((IASTDeclaration)condition);
                        }
                    }
                    if (thenClause != null) {
                        new_if_statement.setThenClause(thenClause);
                        ((ASTNode)((Object)new_if_statement)).setLength(this.calculateEndOffset(thenClause) - ((ASTNode)((Object)new_if_statement)).getOffset());
                    }
                    if (this.LT(1) != 76) break block21;
                    this.consume();
                    if (this.LT(1) != 86) break;
                    if (if_statement != null) {
                        if_statement.setElseClause(new_if_statement);
                        ((ASTNode)((Object)if_statement)).setLength(this.calculateEndOffset(new_if_statement) - ((ASTNode)((Object)if_statement)).getOffset());
                    }
                    if (result == null && if_statement != null) {
                        result = if_statement;
                    }
                    if (result == null) {
                        result = new_if_statement;
                    }
                    if_statement = new_if_statement;
                }
                IASTStatement elseStatement = this.statement();
                new_if_statement.setElseClause(elseStatement);
                if (if_statement != null) {
                    if_statement.setElseClause(new_if_statement);
                    ((ASTNode)((Object)if_statement)).setLength(this.calculateEndOffset(new_if_statement) - ((ASTNode)((Object)if_statement)).getOffset());
                } else {
                    if (result == null) {
                        result = new_if_statement;
                    }
                    if_statement = new_if_statement;
                }
                break block22;
            }
            if (thenClause != null) {
                ((ASTNode)((Object)new_if_statement)).setLength(this.calculateEndOffset(thenClause) - start);
            }
            if (if_statement != null) {
                if_statement.setElseClause(new_if_statement);
                ((ASTNode)((Object)new_if_statement)).setLength(this.calculateEndOffset(new_if_statement) - start);
            }
            if (result == null && if_statement != null) {
                result = if_statement;
            }
            if (result == null) {
                result = new_if_statement;
            }
            if_statement = new_if_statement;
        }
        this.reconcileLengths(result);
        return result;
    }

    @Override
    protected IASTStatement functionBody() throws EndOfFileException, BacktrackException {
        ++this.functionBodyCount;
        IASTStatement s = super.functionBody();
        --this.functionBodyCount;
        return s;
    }

    protected IASTStatement parseSwitchStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        this.consume(8);
        IASTNode switch_condition = this.cppStyleCondition(9);
        switch (this.LT(1)) {
            case 9: {
                this.consume();
                break;
            }
            case 141: {
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        IASTStatement switch_body = this.parseSwitchBody();
        ICPPASTSwitchStatement switch_statement = this.nodeFactory.newSwitchStatement();
        ((ASTNode)((Object)switch_statement)).setOffsetAndLength(startOffset, (switch_body != null ? this.calculateEndOffset(switch_body) : this.LA(1).getEndOffset()) - startOffset);
        if (switch_condition instanceof IASTExpression) {
            switch_statement.setControllerExpression((IASTExpression)switch_condition);
        } else if (switch_condition instanceof IASTDeclaration) {
            switch_statement.setControllerDeclaration((IASTDeclaration)switch_condition);
        }
        if (switch_body != null) {
            switch_statement.setBody(switch_body);
        }
        return switch_statement;
    }

    protected IASTStatement parseForStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        this.consume(8);
        IASTStatement init = this.forInitStatement(DeclarationOptions.LOCAL);
        IASTNode for_condition = null;
        switch (this.LT(1)) {
            case 5: 
            case 141: {
                break;
            }
            default: {
                for_condition = this.cppStyleCondition(5);
            }
        }
        switch (this.LT(1)) {
            case 5: {
                this.consume();
                break;
            }
            case 141: {
                break;
            }
            default: {
                throw this.backtrack;
            }
        }
        IASTExpression iterationExpression = null;
        switch (this.LT(1)) {
            case 9: 
            case 141: {
                break;
            }
            default: {
                iterationExpression = this.expression();
            }
        }
        switch (this.LT(1)) {
            case 9: {
                this.consume();
                break;
            }
            case 141: {
                break;
            }
            default: {
                throw this.backtrack;
            }
        }
        ICPPASTForStatement for_statement = this.nodeFactory.newForStatement();
        IASTStatement for_body = null;
        if (this.LT(1) != 141) {
            for_body = this.statement();
            ((ASTNode)((Object)for_statement)).setOffsetAndLength(startOffset, this.calculateEndOffset(for_body) - startOffset);
        }
        for_statement.setInitializerStatement(init);
        if (for_condition != null) {
            if (for_condition instanceof IASTExpression) {
                for_statement.setConditionExpression((IASTExpression)for_condition);
            } else if (for_condition instanceof IASTDeclaration) {
                for_statement.setConditionDeclaration((IASTDeclaration)for_condition);
            }
        }
        if (iterationExpression != null) {
            for_statement.setIterationExpression(iterationExpression);
        }
        if (for_body != null) {
            for_statement.setBody(for_body);
        }
        return for_statement;
    }

    @Override
    protected IASTStatement parseReturnStatement() throws EndOfFileException, BacktrackException {
        int offset = this.consume(103).getOffset();
        IASTInitializerClause expr = null;
        int lt1 = this.LT(1);
        if (lt1 == 12) {
            expr = this.bracedInitList(true);
        } else if (lt1 != 5) {
            expr = this.expression();
        }
        int endOffset = this.consumeOrEOC(5).getEndOffset();
        return this.setRange(this.nodeFactory.newReturnStatement(expr), offset, endOffset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BinaryExprCtx {
        eTmplID,
        eAmbigTmplID,
        eNoTmplID;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DtorStrategy {
        PREFER_FUNCTION,
        PREFER_NESTED;

    }
}

