/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBase;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypedef;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPBase
implements ICPPBase,
ICPPInternalBase {
    private static final int BASECLASS_SPECIFIER = 0;
    private static final int NEXTBASE = 4;
    private static final int FLAGS = 8;
    protected static final int RECORD_SIZE = 9;
    private final PDOMLinkage linkage;
    private final long record;
    private PDOMBinding fCachedBaseClass;

    public PDOMCPPBase(PDOMLinkage linkage, long record) {
        this.linkage = linkage;
        this.record = record;
    }

    public PDOMCPPBase(PDOMLinkage linkage, PDOMName baseClassSpec, boolean isVirtual, int visibility) throws CoreException {
        this.linkage = linkage;
        Database db = this.getDB();
        this.record = db.malloc(9);
        long baserec = baseClassSpec != null ? baseClassSpec.getRecord() : 0L;
        db.putRecPtr(this.record + 0L, baserec);
        byte flags = (byte)(visibility | (isVirtual ? 4 : 0));
        db.putByte(this.record + 8L, flags);
    }

    private Database getDB() {
        return this.linkage.getDB();
    }

    public long getRecord() {
        return this.record;
    }

    public void setNextBase(PDOMCPPBase nextBase) throws CoreException {
        long rec = nextBase != null ? nextBase.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 4L, rec);
    }

    public PDOMCPPBase getNextBase() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 4L);
        return rec != 0L ? new PDOMCPPBase(this.linkage, rec) : null;
    }

    private int getFlags() throws CoreException {
        return this.getDB().getByte(this.record + 8L);
    }

    public PDOMName getBaseClassSpecifierName() {
        try {
            long rec = this.getDB().getRecPtr(this.record + 0L);
            if (rec != 0L) {
                return new PDOMName(this.linkage, rec);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return null;
    }

    public IBinding getBaseClass() {
        if (this.fCachedBaseClass != null) {
            return this.fCachedBaseClass;
        }
        try {
            PDOMName name = this.getBaseClassSpecifierName();
            if (name != null) {
                PDOMBinding b = name.getBinding();
                while (b instanceof PDOMCPPTypedef && ((PDOMCPPTypedef)b).getType() instanceof PDOMBinding) {
                    b = (PDOMBinding)((Object)((PDOMCPPTypedef)b).getType());
                }
                this.fCachedBaseClass = b;
                return this.fCachedBaseClass;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return null;
    }

    public int getVisibility() {
        try {
            return this.getFlags() & 3;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return 0;
        }
    }

    public boolean isVirtual() {
        try {
            return (this.getFlags() & 4) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return false;
        }
    }

    public void delete() throws CoreException {
        this.getDB().free(this.record);
    }

    public void setBaseClass(IBinding binding) {
        throw new PDOMNotImplementedError();
    }

    public ICPPBase clone() {
        return new PDOMCPPBaseClone(this);
    }

    private static class PDOMCPPBaseClone
    implements ICPPBase,
    ICPPInternalBase {
        private ICPPBase base;
        private IBinding baseClass = null;

        public PDOMCPPBaseClone(ICPPBase base) {
            this.base = base;
        }

        public IBinding getBaseClass() throws DOMException {
            if (this.baseClass == null) {
                return this.base.getBaseClass();
            }
            return this.baseClass;
        }

        public IName getBaseClassSpecifierName() {
            return this.base.getBaseClassSpecifierName();
        }

        public int getVisibility() throws DOMException {
            return this.base.getVisibility();
        }

        public boolean isVirtual() throws DOMException {
            return this.base.isVirtual();
        }

        public void setBaseClass(IBinding binding) {
            this.baseClass = binding;
        }

        public ICPPBase clone() {
            return new PDOMCPPBaseClone(this);
        }
    }
}

