/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPTemplateParameterMap {
    private static final int TYPE_OFFSET = 0;
    private static final int VALUE_OFFSET = 6;
    private static final int NODE_SIZE = 10;

    public static long putMap(PDOMNode parent, ICPPTemplateParameterMap map) throws CoreException {
        long block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        Integer[] keys = map.getAllParameterPositions();
        int keyLen = 0;
        int dataSize = 2;
        Integer[] integerArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Integer key = integerArray[n2];
            int delta = 16;
            ICPPTemplateArgument[] packExpansion = map.getPackExpansion(key);
            if (packExpansion != null) {
                delta += (packExpansion.length - 1) * 10;
            }
            if (dataSize + delta > 4094) break;
            dataSize += delta;
            ++keyLen;
            ++n2;
        }
        long p = block = db.malloc(dataSize);
        db.putShort(p, (short)keyLen);
        p += 2L;
        Integer[] integerArray2 = keys;
        int n3 = keys.length;
        int n4 = 0;
        while (n4 < n3) {
            Integer paramId = integerArray2[n4];
            if (--keyLen < 0) break;
            db.putInt(p, paramId);
            p += 4L;
            ICPPTemplateArgument arg = map.getArgument(paramId);
            if (arg != null) {
                db.putShort(p, (short)-1);
                PDOMCPPTemplateParameterMap.storeArgument(db, linkage, p += 2L, arg);
                p += 10L;
            } else {
                ICPPTemplateArgument[] args = map.getPackExpansion(paramId);
                db.putShort(p, (short)args.length);
                p += 2L;
                ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
                int n5 = args.length;
                int n6 = 0;
                while (n6 < n5) {
                    ICPPTemplateArgument a = iCPPTemplateArgumentArray[n6];
                    PDOMCPPTemplateParameterMap.storeArgument(db, linkage, p, a);
                    p += 10L;
                    ++n6;
                }
            }
            ++n4;
        }
        assert (p == block + (long)dataSize);
        return block;
    }

    private static void storeArgument(Database db, PDOMLinkage linkage, long p, ICPPTemplateArgument arg) throws CoreException {
        if (arg.isNonTypeValue()) {
            linkage.storeType(p + 0L, arg.getTypeOfNonTypeValue());
            db.putRecPtr(p + 6L, PDOMValue.store(db, linkage, arg.getNonTypeValue()));
        } else {
            linkage.storeType(p + 0L, arg.getTypeValue());
        }
    }

    public static void clearMap(PDOMNode parent, int record) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        long p = record;
        int len = db.getShort(p);
        p += 2L;
        int i = 0;
        while (i < len) {
            int packSize = db.getShort(p += 4L);
            p += 2L;
            if (packSize == -1) {
                packSize = 1;
            }
            int j = 0;
            while (j < packSize) {
                linkage.storeType(p + 0L, null);
                PDOMValue.delete(db, db.getRecPtr(p + 6L));
                p += 10L;
                ++j;
            }
            ++i;
        }
        db.free(record);
    }

    public static CPPTemplateParameterMap getMap(PDOMNode parent, long rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        if (len == 0) {
            return CPPTemplateParameterMap.EMPTY;
        }
        rec += 2L;
        CPPTemplateParameterMap result = new CPPTemplateParameterMap(len);
        int i = 0;
        while (i < len) {
            int parPos = db.getInt(rec);
            short packSize = db.getShort(rec += 4L);
            rec += 2L;
            if (packSize == -1) {
                ICPPTemplateArgument arg = PDOMCPPTemplateParameterMap.readArgument(rec, linkage, db);
                rec += 10L;
                result.put(parPos, arg);
            } else {
                ICPPTemplateArgument[] packExpansion = new ICPPTemplateArgument[packSize];
                int j = 0;
                while (j < packExpansion.length) {
                    packExpansion[j] = PDOMCPPTemplateParameterMap.readArgument(rec, linkage, db);
                    rec += 10L;
                    ++j;
                }
                result.put(parPos, packExpansion);
            }
            ++i;
        }
        return result;
    }

    private static ICPPTemplateArgument readArgument(long rec, PDOMLinkage linkage, Database db) throws CoreException {
        CPPTemplateArgument arg;
        long nonTypeValRec;
        IType type = linkage.loadType(rec + 0L);
        if (type == null) {
            type = new CPPBasicType(IBasicType.Kind.eUnspecified, CPPBasicType.UNIQUE_TYPE_QUALIFIER);
        }
        if ((nonTypeValRec = db.getRecPtr(rec + 6L)) != 0L) {
            IValue val = PDOMValue.restore(db, linkage, nonTypeValRec);
            arg = new CPPTemplateArgument(val, type);
        } else {
            arg = new CPPTemplateArgument(type);
        }
        return arg;
    }
}

