/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIEventManager;
import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStopDebuggerRequest;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public abstract class AbstractEventManager
extends AbstractPDIManager
implements IPDIEventManager {
    private final List<IPDIEventListener> listenerList = Collections.synchronizedList(new ArrayList());
    private final List<EventRequestScheduledTask> requestList = Collections.synchronizedList(new ArrayList());
    private final RequestNotifier requestNotifier = new RequestNotifier();

    public AbstractEventManager(IPDISession session) {
        super(session, false);
        this.requestNotifier.addObserver(session.getEventRequestManager());
    }

    public void addEventListener(IPDIEventListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void fireEvent(IPDIEvent event) {
        this.fireEvents(new IPDIEvent[]{event});
    }

    public void fireEvents(final IPDIEvent[] events) {
        if (events.length > 0) {
            IPDIEventListener[] listeners;
            IPDIEventListener[] iPDIEventListenerArray = listeners = this.listenerList.toArray(new IPDIEventListener[0]);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                final IPDIEventListener listener = iPDIEventListenerArray[n2];
                Runnable runnable = new Runnable(){

                    public void run() {
                        listener.handleDebugEvents(events);
                    }
                };
                this.session.queueRunnable(runnable);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEventRequest(IPDIEventRequest request) {
        List<EventRequestScheduledTask> list = this.requestList;
        synchronized (list) {
            if (!(request instanceof IPDIStopDebuggerRequest) && !this.requestList.isEmpty()) {
                this.requestList.remove(0).cancelTimeout();
            }
            this.requestNotifier.notify(request);
            PDebugUtils.println(String.valueOf(Messages.AbstractEventManager_2) + request);
            switch (request.getStatus()) {
                case 5: {
                    this.fireEvent(this.session.getEventFactory().newErrorEvent(this.session.getEventFactory().newErrorInfo(this.session, request.getTasks(), 0, String.valueOf(request.getName()) + Messages.AbstractEventManager_3, Messages.AbstractEventManager_4)));
                    break;
                }
                case 4: {
                    this.fireEvent(this.session.getEventFactory().newErrorEvent(this.session.getEventFactory().newErrorInfo(this.session, request.getTasks(), 0, String.valueOf(request.getName()) + Messages.AbstractEventManager_5, Messages.AbstractEventManager_6)));
                    break;
                }
                case 1: {
                    int errorType = 0;
                    if (request.getResponseAction() == 2) {
                        errorType = 2;
                        try {
                            this.session.terminate(request.getTasks().copy());
                        }
                        catch (PDIException pDIException) {
                            this.session.getTaskManager().setPendingTasks(false, request.getTasks());
                            this.session.getTaskManager().setTerminateTasks(true, request.getTasks());
                        }
                    }
                    this.fireEvent(this.session.getEventFactory().newErrorEvent(this.session.getEventFactory().newErrorInfo(this.session, request.getTasks(), errorType, String.valueOf(request.getName()) + Messages.AbstractEventManager_7, request.getErrorMessage())));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventRequest(IPDIEventRequest request) {
        List<EventRequestScheduledTask> list = this.requestList;
        synchronized (list) {
            if (request instanceof IPDIStopDebuggerRequest) {
                request.done();
                this.notifyEventRequest(request);
                this.session.setStatus(5);
                return;
            }
            PDebugUtils.println(String.valueOf(Messages.AbstractEventManager_8) + request);
            this.requestList.add(new EventRequestScheduledTask(request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRegisteredEventRequests() {
        List<EventRequestScheduledTask> list = this.requestList;
        synchronized (list) {
            Iterator<EventRequestScheduledTask> iter = this.requestList.iterator();
            while (iter.hasNext()) {
                EventRequestScheduledTask task = iter.next();
                if (task.getRequest().getStatus() == 2) continue;
                task.cancelTimeout();
                iter.remove();
            }
        }
    }

    public void removeEventListener(IPDIEventListener listener) {
        this.listenerList.remove(listener);
    }

    public void shutdown() {
        this.requestNotifier.deleteObserver(this.session.getEventRequestManager());
        this.listenerList.clear();
        this.requestList.clear();
    }

    public void update(TaskSet tasks) throws PDIException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPDIEventRequest getCurrentRequest() {
        List<EventRequestScheduledTask> list = this.requestList;
        synchronized (list) {
            if (!this.requestList.isEmpty()) {
                return this.requestList.get(0).getRequest();
            }
            return null;
        }
    }

    public class EventRequestScheduledTask {
        Timer eventTimer = null;
        IPDIEventRequest request = null;

        public EventRequestScheduledTask(IPDIEventRequest request) {
            this.request = request;
            this.eventTimer = new Timer();
            this.scheduleTimeout();
        }

        public void cancelTimeout() {
            this.eventTimer.cancel();
        }

        public IPDIEventRequest getRequest() {
            return this.request;
        }

        public void scheduleTimeout() {
            this.eventTimer.schedule(new TimerTask(){

                public void run() {
                    PDebugUtils.println(String.valueOf(Messages.AbstractEventManager_0) + EventRequestScheduledTask.this.request);
                    EventRequestScheduledTask.this.request.error(Messages.AbstractEventManager_1);
                    AbstractEventManager.this.notifyEventRequest(EventRequestScheduledTask.this.request);
                }
            }, AbstractEventManager.this.session.getTimeout());
        }
    }

    public class RequestNotifier
    extends Observable {
        public void notify(IPDIEventRequest request) {
            this.setChanged();
            this.notifyObservers(request);
        }
    }
}

