/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.managedbuilder.gnu.ui.scannerdiscovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PerProjectSICollectorSkipCygTrans
extends PerProjectSICollector {
    public synchronized void updateScannerConfiguration(IProgressMonitor monitor) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo pathInfo;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.project, this.context)) instanceof IDiscoveredPathManager.IPerProjectDiscoveredPathInfo) {
            IDiscoveredPathManager.IPerProjectDiscoveredPathInfo projectPathInfo = (IDiscoveredPathManager.IPerProjectDiscoveredPathInfo)pathInfo;
            monitor.beginTask(MakeMessages.getString((String)"ScannerInfoCollector.Processing"), 100);
            monitor.subTask(MakeMessages.getString((String)"ScannerInfoCollector.Processing"));
            if (this.scannerConfigNeedsUpdate(projectPathInfo)) {
                monitor.worked(50);
                monitor.subTask(String.valueOf(MakeMessages.getString((String)"ScannerInfoCollector.Updating")) + this.project.getName());
                try {
                    ArrayList<IProject> resourceDelta = new ArrayList<IProject>(1);
                    resourceDelta.add(this.project);
                    MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(this.context, pathInfo, this.context.isDefaultContext(), resourceDelta);
                    monitor.worked(50);
                }
                catch (CoreException e) {
                    MakeCorePlugin.log((Throwable)e);
                }
            }
            monitor.done();
            this.scPersisted = true;
        }
    }

    private boolean scannerConfigNeedsUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedIncludes = this.includePathsNeedUpdate(discPathInfo);
        boolean addedSymbols = this.definedSymbolsNeedUpdate(discPathInfo);
        return addedIncludes | addedSymbols;
    }

    private boolean includePathsNeedUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedIncludes = false;
        List discoveredIncludes = (List)this.discoveredSI.get(ScannerInfoTypes.INCLUDE_PATHS);
        if (discoveredIncludes != null) {
            LinkedHashMap<String, Boolean> newPersistedIncludes;
            addedIncludes = this.addItemsWithOrder(this.sumDiscoveredIncludes, discoveredIncludes, true);
            LinkedHashMap<String, Boolean> persistedIncludes = discPathInfo.getIncludeMap();
            ArrayList persistedKeyList = new ArrayList(persistedIncludes.keySet());
            addedIncludes = this.addItemsWithOrder(persistedKeyList, this.sumDiscoveredIncludes, true);
            if (addedIncludes) {
                newPersistedIncludes = new LinkedHashMap<String, Boolean>(persistedKeyList.size());
                for (String include : persistedKeyList) {
                    if (persistedIncludes.containsKey(include)) {
                        newPersistedIncludes.put(include, (Boolean)persistedIncludes.get(include));
                        continue;
                    }
                    Boolean includePathExists = true;
                    URI projectLocationURI = discPathInfo.getProject().getLocationURI();
                    URI includeURI = EFSExtensionManager.getDefault().createNewURIFromPath(projectLocationURI, include);
                    try {
                        IFileStore fileStore = EFS.getStore((URI)includeURI);
                        IFileInfo info = fileStore.fetchInfo();
                        if (!info.exists()) {
                            includePathExists = false;
                        }
                    }
                    catch (CoreException e) {
                        MakeCorePlugin.log((Throwable)e);
                    }
                    newPersistedIncludes.put(include, includePathExists == false);
                }
            } else {
                newPersistedIncludes = persistedIncludes;
            }
            discPathInfo.setIncludeMap((LinkedHashMap)newPersistedIncludes);
        }
        return addedIncludes;
    }
}

