/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.photran.internal.core.preprocessor.c.ASTFileLocation;
import org.eclipse.photran.internal.core.preprocessor.c.ASTImageLocation;
import org.eclipse.photran.internal.core.preprocessor.c.ASTInclusionStatement;
import org.eclipse.photran.internal.core.preprocessor.c.ASTMacroExpansion;
import org.eclipse.photran.internal.core.preprocessor.c.ASTMacroExpansionLocation;
import org.eclipse.photran.internal.core.preprocessor.c.ASTMacroReferenceName;
import org.eclipse.photran.internal.core.preprocessor.c.ASTPreprocessorName;
import org.eclipse.photran.internal.core.preprocessor.c.DependencyTree;
import org.eclipse.photran.internal.core.preprocessor.c.ILocationCtx;
import org.eclipse.photran.internal.core.preprocessor.c.ISkippedIndexedFilesListener;
import org.eclipse.photran.internal.core.preprocessor.c.ImageLocationInfo;
import org.eclipse.photran.internal.core.preprocessor.c.IncludeFileContent;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtx;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtxContainer;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtxFile;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtxMacroExpansion;

public class LocationMap {
    private String fTranslationUnitPath;
    private IASTTranslationUnit fTranslationUnit;
    private LocationCtxFile fRootContext = null;
    private LocationCtx fCurrentContext = null;
    private int fLastChildInsertionOffset;
    private List<ISkippedIndexedFilesListener> fSkippedFilesListeners = new ArrayList<ISkippedIndexedFilesListener>();

    public void registerPredefinedMacro(IMacroBinding macro) {
        this.registerPredefinedMacro(macro, null, -1);
    }

    public void registerMacroFromIndex(IMacroBinding macro, IASTFileLocation nameLocation, int expansionOffset) {
        this.registerPredefinedMacro(macro, nameLocation, expansionOffset);
    }

    @Deprecated
    private void registerPredefinedMacro(IMacroBinding macro, IASTFileLocation nameloc, int expansionOffset) {
    }

    public ILocationCtx pushTranslationUnit(String filename, char[] buffer) {
        assert (this.fCurrentContext == null);
        this.fTranslationUnitPath = filename;
        this.fRootContext = new LocationCtxFile(null, filename, buffer, 0, 0, 0, null);
        this.fCurrentContext = this.fRootContext;
        this.fLastChildInsertionOffset = 0;
        return this.fCurrentContext;
    }

    public ILocationCtx pushPreInclusion(char[] buffer, int offset, boolean isMacroFile) {
        assert (this.fCurrentContext instanceof LocationCtxContainer);
        int sequenceNumber = this.getSequenceNumberForOffset(offset);
        this.fCurrentContext = new LocationCtxContainer((LocationCtxContainer)this.fCurrentContext, buffer, offset, offset, sequenceNumber);
        this.fLastChildInsertionOffset = 0;
        return this.fCurrentContext;
    }

    public ILocationCtx pushInclusion(int startOffset, int nameOffset, int nameEndOffset, int endOffset, char[] buffer, String filename, char[] name, boolean userInclude) {
        assert (this.fCurrentContext instanceof LocationCtxContainer);
        int startNumber = this.getSequenceNumberForOffset(startOffset);
        int nameNumber = this.getSequenceNumberForOffset(nameOffset);
        int nameEndNumber = this.getSequenceNumberForOffset(nameEndOffset);
        int endNumber = this.getSequenceNumberForOffset(endOffset);
        ASTInclusionStatement inclusionStatement = new ASTInclusionStatement(this.fTranslationUnit, startNumber, nameNumber, nameEndNumber, endNumber, name, filename, userInclude, true);
        this.fCurrentContext = new LocationCtxFile((LocationCtxContainer)this.fCurrentContext, filename, buffer, startOffset, endOffset, endNumber, inclusionStatement);
        this.fLastChildInsertionOffset = 0;
        return this.fCurrentContext;
    }

    public IASTName encounterImplicitMacroExpansion(IMacroBinding macro, ImageLocationInfo imageLocationInfo) {
        return new ASTMacroReferenceName(null, IASTPreprocessorMacroExpansion.NESTED_EXPANSION_NAME, 0, 0, macro, imageLocationInfo);
    }

    public IASTName encounterDefinedExpression(IMacroBinding macro, int startOffset, int endOffset) {
        int startNumber = this.getSequenceNumberForOffset(startOffset);
        int endNumber = this.getSequenceNumberForOffset(endOffset);
        return new ASTMacroReferenceName(null, IASTPreprocessorStatement.MACRO_NAME, startNumber, endNumber, macro, null);
    }

    public ILocationCtx pushMacroExpansion(int nameOffset, int nameEndOffset, int endOffset, int contextLength, IMacroBinding macro, IASTName[] implicitMacroReferences, ImageLocationInfo[] imageLocations) {
        assert (this.fCurrentContext instanceof LocationCtxContainer);
        int nameNumber = this.getSequenceNumberForOffset(nameOffset);
        int nameEndNumber = this.getSequenceNumberForOffset(nameEndOffset);
        int endNumber = this.getSequenceNumberForOffset(endOffset);
        ASTMacroExpansion expansion = new ASTMacroExpansion((IASTNode)this.fTranslationUnit, nameNumber, endNumber);
        ASTMacroReferenceName explicitRef = new ASTMacroReferenceName((IASTNode)expansion, IASTPreprocessorMacroExpansion.EXPANSION_NAME, nameNumber, nameEndNumber, macro, null);
        this.addMacroReference(explicitRef);
        LocationCtxMacroExpansion expansionCtx = new LocationCtxMacroExpansion(this, (LocationCtxContainer)this.fCurrentContext, nameOffset, endOffset, endNumber, contextLength, imageLocations, explicitRef);
        expansion.setContext(expansionCtx);
        this.fCurrentContext = expansionCtx;
        this.fLastChildInsertionOffset = 0;
        return this.fCurrentContext;
    }

    @Deprecated
    private void addMacroReference(ASTPreprocessorName name) {
    }

    public void popContext(ILocationCtx locationCtx) {
        assert (this.fCurrentContext == locationCtx);
        LocationCtx child = this.fCurrentContext;
        LocationCtx parent = (LocationCtx)this.fCurrentContext.getParent();
        if (parent != null) {
            this.fCurrentContext = parent;
            this.fLastChildInsertionOffset = child.fEndOffsetInParent;
            parent.addChildSequenceLength(child.getSequenceLength());
        }
    }

    @Deprecated
    public void encounterPoundInclude(int startOffset, int nameOffset, int nameEndOffset, int endOffset, char[] name, String filename, boolean userInclude, boolean active) {
    }

    @Deprecated
    public void encounteredComment(int offset, int endOffset, boolean isBlockComment) {
    }

    @Deprecated
    public void encounterProblem(int id, char[] arg, int offset, int endOffset) {
    }

    @Deprecated
    public void encounterPoundElse(int startOffset, int endOffset, boolean isActive) {
    }

    @Deprecated
    public void encounterPoundElif(int startOffset, int condOffset, int condEndOffset, int endOffset, boolean isActive, IASTName[] macrosInDefinedExpression) {
    }

    @Deprecated
    public void encounterPoundEndIf(int startOffset, int endOffset) {
    }

    @Deprecated
    public void encounterPoundError(int startOffset, int condOffset, int condEndOffset, int endOffset) {
    }

    @Deprecated
    public void encounterPoundPragma(int startOffset, int condOffset, int condEndOffset, int endOffset) {
    }

    @Deprecated
    public void encounterPoundIfdef(int startOffset, int condOffset, int condEndOffset, int endOffset, boolean taken, IMacroBinding macro) {
    }

    @Deprecated
    public void encounterPoundIfndef(int startOffset, int condOffset, int condEndOffset, int endOffset, boolean taken, IMacroBinding macro) {
    }

    @Deprecated
    public void encounterPoundIf(int startOffset, int condOffset, int condEndOffset, int endOffset, boolean isActive, IASTName[] macrosInDefinedExpression) {
    }

    @Deprecated
    public void encounterPoundDefine(int startOffset, int nameOffset, int nameEndOffset, int expansionOffset, int endOffset, IMacroBinding macrodef) {
    }

    @Deprecated
    public void encounterPoundUndef(IMacroBinding definition, int startOffset, int nameOffset, int nameEndOffset, int endOffset, char[] name) {
    }

    public void setRootNode(IASTTranslationUnit root) {
        this.fTranslationUnit = root;
        if (this.fTranslationUnit instanceof ISkippedIndexedFilesListener) {
            this.fSkippedFilesListeners.add((ISkippedIndexedFilesListener)root);
        }
    }

    public String getTranslationUnitPath() {
        return this.fTranslationUnitPath;
    }

    public int getCurrentLineNumber(int offset) {
        return this.fCurrentContext.getLineNumber(offset);
    }

    public String getCurrentFilePath() {
        return this.fCurrentContext.getFilePath();
    }

    int getSequenceNumberForOffset(int offset) {
        return this.fCurrentContext.getSequenceNumberForOffset(offset, offset < this.fLastChildInsertionOffset);
    }

    public String getContainingFilePath(int sequenceNumber) {
        LocationCtx ctx = this.fRootContext.findSurroundingContext(sequenceNumber, 1);
        return new String(ctx.getFilePath());
    }

    public ASTFileLocation getMappedFileLocation(int sequenceNumber, int length) {
        return this.fRootContext.findMappedFileLocation(sequenceNumber, length);
    }

    public IASTNodeLocation[] getLocations(int sequenceNumber, int length) {
        ArrayList<IASTNodeLocation> result = new ArrayList<IASTNodeLocation>();
        this.fRootContext.collectLocations(sequenceNumber, length, result);
        return result.toArray(new IASTNodeLocation[result.size()]);
    }

    public boolean isPartOfTranslationUnitFile(int sequenceNumber) {
        return this.fRootContext.isThisFile(sequenceNumber);
    }

    public IASTImageLocation getImageLocation(int sequenceNumber, int length) {
        ArrayList<IASTNodeLocation> result = new ArrayList<IASTNodeLocation>();
        this.fRootContext.collectLocations(sequenceNumber, length, result);
        if (result.size() != 1) {
            return null;
        }
        IASTNodeLocation loc = result.get(0);
        if (loc instanceof IASTFileLocation) {
            IASTFileLocation floc = (IASTFileLocation)loc;
            return new ASTImageLocation(1, floc.getFileName(), floc.getNodeOffset(), floc.getNodeLength());
        }
        if (loc instanceof ASTMacroExpansionLocation) {
            ASTMacroExpansionLocation mel = (ASTMacroExpansionLocation)loc;
            return mel.getImageLocation();
        }
        return null;
    }

    public IASTTranslationUnit.IDependencyTree getDependencyTree() {
        return new DependencyTree(this.fRootContext);
    }

    public void cleanup() {
    }

    public void skippedFile(int sequenceNumber, IncludeFileContent fi) {
        for (ISkippedIndexedFilesListener l : this.fSkippedFilesListeners) {
            l.skippedFile(sequenceNumber, fi);
        }
    }
}

