/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.upc;

import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICNodeFactory;
import org.eclipse.cdt.core.dom.lrparser.action.ISecondaryParserFactory;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.dom.lrparser.action.c99.C99BuildASTParserAction;
import org.eclipse.cdt.core.dom.parser.upc.IUPCNodeFactory;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTDeclSpecifier;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTForallStatement;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTKeywordExpression;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTSynchronizationStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPCParserAction
extends C99BuildASTParserAction {
    private IUPCNodeFactory nodeFactory;

    public UPCParserAction(ITokenStream parser, ScopedStack<Object> astStack, IUPCNodeFactory nodeFactory, ISecondaryParserFactory parserFactory) {
        super(parser, astStack, (ICNodeFactory)nodeFactory, parserFactory);
        this.nodeFactory = nodeFactory;
        nodeFactory.setUseC99SizeofExpressions();
    }

    protected boolean isCompletionToken(IToken token) {
        return token.getKind() == 3;
    }

    public void consumeExpressionUnarySizeofOperator(int upcOp) {
        this.nodeFactory.setUseUPCSizeofExpressions(upcOp);
        super.consumeExpressionUnaryOperator(8);
        this.nodeFactory.setUseC99SizeofExpressions();
    }

    public void consumeExpressionSizeofTypeId(int upcOp) {
        this.nodeFactory.setUseUPCSizeofExpressions(upcOp);
        super.consumeExpressionTypeId(0);
        this.nodeFactory.setUseC99SizeofExpressions();
    }

    public void consumeKeywordExpression(int keywordKind) {
        IUPCASTKeywordExpression expr = this.nodeFactory.newKeywordExpression(keywordKind);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push((Object)expr);
    }

    public void consumeStatementSynchronizationStatement(int statementKind, boolean hasBarrierExpr) {
        IASTExpression barrierExpression = hasBarrierExpr ? (IASTExpression)this.astStack.pop() : null;
        IUPCASTSynchronizationStatement statement = this.nodeFactory.newSyncronizationStatment(barrierExpression, statementKind);
        this.setOffsetAndLength((IASTNode)statement);
        this.astStack.push((Object)statement);
    }

    public void consumeStatementUPCForallLoop(boolean hasExpr1, boolean hasExpr2, boolean hasExpr3, boolean hasAffinity) {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        boolean affinityContinue = false;
        IASTExpression affinity = null;
        if (hasAffinity) {
            Object o = this.astStack.pop();
            if (o instanceof IASTExpression) {
                affinity = (IASTExpression)o;
            } else if (o instanceof IToken) {
                affinityContinue = true;
            }
        }
        IASTExpression expr3 = hasExpr3 ? (IASTExpression)this.astStack.pop() : null;
        IASTExpression expr2 = hasExpr2 ? (IASTExpression)this.astStack.pop() : null;
        IASTNullStatement initializer = this.nodeFactory.newNullStatement();
        if (hasExpr1) {
            Object node = this.astStack.pop();
            if (node instanceof IASTExpression) {
                initializer = this.nodeFactory.newExpressionStatement((IASTExpression)node);
            } else if (node instanceof IASTDeclaration) {
                initializer = this.nodeFactory.newDeclarationStatement((IASTDeclaration)node);
            }
        }
        IUPCASTForallStatement forStat = this.nodeFactory.newForallStatement((IASTStatement)initializer, expr2, expr3, body, affinity);
        forStat.setAffinityContinue(affinityContinue);
        this.setOffsetAndLength((IASTNode)forStat);
        this.astStack.push((Object)forStat);
    }

    public void consumeLayoutQualifier(boolean hasExpression, boolean hasStar) {
        UPCParserActionLayoutQualifier layoutQualifier = new UPCParserActionLayoutQualifier();
        layoutQualifier.hasStar = hasStar;
        if (hasExpression) {
            layoutQualifier.expression = (IASTExpression)this.astStack.pop();
        }
        this.astStack.push((Object)layoutQualifier);
    }

    public void setSpecifier(ICASTDeclSpecifier declSpec, Object specifier) {
        if (specifier instanceof IToken) {
            this.setTokenSpecifier((IUPCASTDeclSpecifier)declSpec, (IToken)specifier);
        } else {
            this.setLayoutQualifier((IUPCASTDeclSpecifier)declSpec, (UPCParserActionLayoutQualifier)specifier);
        }
    }

    protected void setTokenSpecifier(IUPCASTDeclSpecifier node, IToken token) {
        switch (token.getKind()) {
            case 46: {
                node.setReferenceType(2);
                break;
            }
            case 48: {
                node.setReferenceType(1);
                break;
            }
            case 47: {
                node.setSharedQualifier(1);
                break;
            }
            default: {
                super.setSpecifier((ICASTDeclSpecifier)node, (Object)token);
            }
        }
    }

    protected void setLayoutQualifier(IUPCASTDeclSpecifier node, UPCParserActionLayoutQualifier layoutQualifier) {
        if (layoutQualifier.hasStar) {
            node.setSharedQualifier(2);
        } else if (layoutQualifier.expression != null) {
            node.setSharedQualifier(4);
            node.setBlockSizeExpression(layoutQualifier.expression);
        } else {
            node.setSharedQualifier(3);
        }
    }

    private static class UPCParserActionLayoutQualifier {
        public boolean hasStar = false;
        public IASTExpression expression = null;

        private UPCParserActionLayoutQualifier() {
        }
    }
}

