/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementDeltaBuilder;
import org.eclipse.cdt.internal.core.model.ReconcileWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ptp.internal.rdt.core.model.RemoteModelWorkingCopy;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;

public class RemoteReconcileWorkingCopyOperation
extends ReconcileWorkingCopyOperation {
    boolean forceProblemDetection;
    boolean fComputeAST;

    public RemoteReconcileWorkingCopyOperation(ICElement workingCopy, boolean computeAST, boolean forceProblemDetection) {
        super(workingCopy, computeAST, forceProblemDetection);
        this.fComputeAST = computeAST;
        this.forceProblemDetection = forceProblemDetection;
    }

    protected void executeOperation() throws CModelException {
        if (!RemoteNature.hasRemoteNature(this.getWorkingCopy().getCProject().getProject())) {
            super.executeOperation();
            return;
        }
        if (this.fMonitor != null) {
            if (this.fMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fMonitor.beginTask("element.reconciling", 10);
        }
        WorkingCopy workingCopy = this.getWorkingCopy();
        boolean wasConsistent = workingCopy.isConsistent();
        CElementDeltaBuilder deltaBuilder = null;
        try {
            if (!wasConsistent || this.forceProblemDetection || this.fComputeAST) {
                deltaBuilder = new CElementDeltaBuilder((ICElement)workingCopy);
                RemoteModelWorkingCopy rmWorkingCopy = null;
                rmWorkingCopy = workingCopy.getFile() == null ? new RemoteModelWorkingCopy(workingCopy, false) : new RemoteModelWorkingCopy(workingCopy);
                rmWorkingCopy.makeConsistent(this.fMonitor, false);
                deltaBuilder.buildDeltas();
                if (deltaBuilder.getDelta() != null && (!wasConsistent || this.forceProblemDetection || deltaBuilder.getDelta().getAffectedChildren().length > 0)) {
                    this.addReconcileDelta((IWorkingCopy)workingCopy, (ICElementDelta)deltaBuilder.getDelta());
                }
            }
            if (this.fMonitor != null) {
                this.fMonitor.worked(2);
            }
        }
        finally {
            if (this.fMonitor != null) {
                this.fMonitor.done();
            }
        }
    }
}

