/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.internal.core.pdi.Location;

public class Locator
extends Location
implements IPDILocator {
    public Locator(String file, String function, int line, BigInteger address) {
        super(file, function, line, address);
    }

    public boolean equalAddress(BigInteger oAddress) {
        if (oAddress == null && this.getAddress() == null) {
            return true;
        }
        return oAddress != null && oAddress.equals(this.getAddress());
    }

    public boolean equalFile(String oFile) {
        return this.equalString(oFile, this.getFile());
    }

    public boolean equalFunction(String oFunction) {
        return this.equalString(oFunction, this.getFunction());
    }

    public boolean equalLine(int oLine) {
        return oLine == this.getLineNumber();
    }

    public boolean equals(IPDILocator locator) {
        if (locator == this) {
            return true;
        }
        String oFile = locator.getFile();
        String oFunction = locator.getFunction();
        int oLine = locator.getLineNumber();
        BigInteger oAddress = locator.getAddress();
        return this.equalFile(oFile) && this.equalFunction(oFunction) && this.equalLine(oLine) && this.equalAddress(oAddress);
    }

    private boolean equalString(String f1, String f2) {
        if (f1 != null && f1.length() > 0 && f2 != null && f2.length() > 0) {
            return f1.equals(f2);
        }
        return !(f1 != null && f1.length() != 0 || f2 != null && f2.length() != 0);
    }
}

