/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.DoubleAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleAttribute
extends AbstractAttribute<Double, DoubleAttribute, DoubleAttributeDefinition> {
    private Double value;

    public DoubleAttribute(DoubleAttributeDefinition description, Double initialValue) throws IllegalValueException {
        super(description);
        this.setValue(initialValue);
    }

    public DoubleAttribute(DoubleAttributeDefinition description, String initialValue) throws IllegalValueException {
        super(description);
        this.setValueAsString(initialValue);
    }

    @Override
    public synchronized Double getValue() {
        return this.value;
    }

    @Override
    public synchronized String getValueAsString() {
        return this.value.toString();
    }

    @Override
    public boolean isValid(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public synchronized void setValue(Double value) throws IllegalValueException {
        if (value < this.getMinValue() || value > this.getMaxValue()) {
            throw new IllegalValueException(Messages.DoubleAttribute_0);
        }
        this.value = value;
    }

    @Override
    public synchronized void setValueAsString(String string) throws IllegalValueException {
        try {
            Double value = Double.valueOf(string);
            if (value < this.getMinValue() || value > this.getMaxValue()) {
                throw new IllegalValueException(Messages.DoubleAttribute_1);
            }
            this.value = value;
        }
        catch (NumberFormatException e) {
            throw new IllegalValueException(e);
        }
    }

    private double getMinValue() {
        return ((DoubleAttributeDefinition)this.getDefinition()).getMinValue();
    }

    private double getMaxValue() {
        return ((DoubleAttributeDefinition)this.getDefinition()).getMaxValue();
    }

    @Override
    protected DoubleAttribute doCopy() {
        try {
            return new DoubleAttribute((DoubleAttributeDefinition)this.getDefinition(), this.value);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected synchronized int doCompareTo(DoubleAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    protected synchronized boolean doEquals(DoubleAttribute other) {
        return this.value.equals(other.value);
    }

    @Override
    protected synchronized int doHashCode() {
        return this.value.hashCode();
    }
}

