/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.debug.core.model.IJumpToLine;
import org.eclipse.ptp.debug.internal.ui.actions.IResumeAtLineTarget;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ResumeAtLineAdapter
implements IResumeAtLineTarget {
    /*
     * Enabled aggressive block sorting
     */
    public void resumeAtLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String errorMessage = null;
        if (!(part instanceof ITextEditor)) {
            errorMessage = Messages.ResumeAtLineAdapter_2;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ITextEditor textEditor = (ITextEditor)part;
        IEditorInput input = textEditor.getEditorInput();
        if (input == null) {
            errorMessage = Messages.ResumeAtLineAdapter_0;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            errorMessage = Messages.ResumeAtLineAdapter_1;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        final String fileName = this.getFileName(input);
        ITextSelection textSelection = (ITextSelection)selection;
        final int lineNumber = textSelection.getStartLine() + 1;
        if (!(target instanceof IAdaptable)) return;
        final IJumpToLine jumpToLine = (IJumpToLine)((IAdaptable)target).getAdapter(IJumpToLine.class);
        if (jumpToLine == null) return;
        if (!jumpToLine.canJumpToLine(fileName, lineNumber)) return;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    jumpToLine.jumpToLine(fileName, lineNumber);
                }
                catch (DebugException e) {
                    ResumeAtLineAdapter.this.failed(e);
                }
            }
        };
        this.runInBackground(r);
    }

    public boolean canResumeAtLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable && part instanceof IEditorPart) {
            String fileName;
            IJumpToLine jumpToLine = (IJumpToLine)((IAdaptable)target).getAdapter(IJumpToLine.class);
            if (jumpToLine == null) {
                return false;
            }
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            if (input == null) {
                return false;
            }
            if (!(editorPart instanceof ITextEditor)) {
                return false;
            }
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                return false;
            }
            try {
                fileName = this.getFileName(input);
            }
            catch (CoreException coreException) {
                return false;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            return jumpToLine.canJumpToLine(fileName, lineNumber);
        }
        return false;
    }

    private String getFileName(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getName();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getName();
        }
        return null;
    }

    private void runInBackground(Runnable r) {
        DebugPlugin.getDefault().asyncExec(r);
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(PTPDebugUIPlugin.getUniqueIdentifier(), 10002, Messages.ResumeAtLineAdapter_3, null);
        ms.add((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 10002, e.getMessage(), e));
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)ms);
        if (handler != null) {
            try {
                handler.handleStatus((IStatus)ms, (Object)this);
            }
            catch (CoreException coreException) {}
        }
    }
}

