/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.lpgextensions;

import java.util.Collections;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.ITrialUndoActionProvider;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.Rule;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.TrialUndoParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTrialUndoActionProvider<ACT, RULE_DATA>
extends PrsStream
implements ITrialUndoActionProvider<RULE_DATA> {
    public static final Action<Object, Object> EMPTY_ACTION = new Action();
    protected TrialUndoParser btParser;
    protected Action<ACT, RULE_DATA>[] ruleAction;
    protected ACT parserAction;
    protected Rule<RULE_DATA> activeRule;

    public AbstractTrialUndoActionProvider() {
    }

    public AbstractTrialUndoActionProvider(LexStream lexStream) {
        super(lexStream);
    }

    public void setParserAction(ACT parserAction) {
        this.parserAction = parserAction;
    }

    public int getRuleTokenCount() {
        return this.activeRule.getEndTokenOffset() - this.activeRule.getStartTokenOffset() + 1;
    }

    public List<IToken> getRuleTokens() {
        return Collections.unmodifiableList(this.getTokens().subList(this.getFirstRealToken(this.activeRule.getStartTokenOffset()), this.activeRule.getEndTokenOffset() + 1));
    }

    public void backtrack() {
        this.btParser.backtrack();
    }

    @Override
    public void setActiveRule(Rule<RULE_DATA> rule) {
        this.activeRule = rule;
    }

    @Override
    public Rule<RULE_DATA> getActiveRule() {
        return this.activeRule;
    }

    @Override
    public final boolean trialAction(int rule_number) {
        return this.ruleAction[rule_number].doTrial(this, this.parserAction);
    }

    @Override
    public final void undoAction(int rule_number) {
        this.ruleAction[rule_number].doUndo(this, this.parserAction);
    }

    @Override
    public final void finalAction(int rule_number) {
        this.ruleAction[rule_number].doFinal(this, this.parserAction);
    }

    public TrialUndoParser getParser() {
        return this.btParser;
    }

    private int getLeftSpan() {
        return this.getFirstRealToken(this.activeRule.getStartTokenOffset());
    }

    public IToken getLeftIToken() {
        return super.getIToken(this.getLeftSpan());
    }

    private int getRightSpan() {
        return this.activeRule.getEndTokenOffset();
    }

    public IToken getRightIToken() {
        return super.getIToken(this.getRightSpan());
    }

    public static <ACT, RULE_DATA> Action<ACT, RULE_DATA> emptyAction() {
        return new Action();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Action<ACT, RULE_DATA> {
        public void doFinal(ITrialUndoActionProvider<RULE_DATA> provider, ACT action) {
        }

        public boolean doTrial(ITrialUndoActionProvider<RULE_DATA> provider, ACT action) {
            return false;
        }

        public void doUndo(ITrialUndoActionProvider<RULE_DATA> provider, ACT action) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BadAction<ACT, RULE_DATA>
    extends Action<ACT, RULE_DATA> {
        BadAction() {
        }

        @Override
        public void doFinal(ITrialUndoActionProvider<RULE_DATA> provider, ACT action) {
            throw new Error(new BadActionException());
        }

        @Override
        public boolean doTrial(ITrialUndoActionProvider<RULE_DATA> provider, ACT action) {
            throw new Error(new BadActionException());
        }

        @Override
        public void doUndo(ITrialUndoActionProvider<RULE_DATA> provider, ACT action) {
            throw new Error(new BadActionException());
        }
    }

    public static class BadActionException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeclaredAction<ACT, RULE_DATA>
    extends Action<ACT, RULE_DATA> {
        protected boolean hasUndo = false;

        @Override
        public boolean doTrial(ITrialUndoActionProvider<RULE_DATA> provider, ACT action) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NullAction<ACT, RULE_DATA>
    extends Action<ACT, RULE_DATA> {
        NullAction() {
        }

        @Override
        public void doFinal(ITrialUndoActionProvider<RULE_DATA> provider, ACT action) {
        }
    }
}

