/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.ui.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.rm.ibm.pe.core.PEPreferenceManager;
import org.eclipse.ptp.rm.ibm.pe.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.preferences.AbstractRemoteRMPreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PEPreferencePage
extends AbstractRemoteRMPreferencePage {
    private Button loadLevelerOption;
    private Button libOverrideBrowse;
    private Button llModeLocal;
    private Button llModeMulticluster;
    private Button llModeDefault;
    private Text nodePollMinInterval;
    private Text nodePollMaxInterval;
    private Text jobPollInterval;
    private Text libOverridePath;
    private Group llModeGroup;
    private Composite llOverrideBox;
    private Combo traceOptions;
    private Label loadLevelerLabel;
    private Label traceLabel;
    private Label libOverrideLabel;
    private Label llModeLabel;
    private Label nodePollMinLabel;
    private Label nodePollMaxLabel;
    private Label jobPollLabel;
    private EventMonitor eventMonitor;

    public Preferences getPreferences() {
        return PEPreferenceManager.getPreferences();
    }

    public void savePreferences() {
        PEPreferenceManager.savePreferences();
    }

    protected Control createContents(Composite parent) {
        Preferences preferences = this.getPreferences();
        this.eventMonitor = new EventMonitor();
        Control preferencePane = super.createContents(parent);
        Group optionsGroup = new Group((Composite)preferencePane, 16);
        GridLayout layout = new GridLayout(2, true);
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setText(Messages.getString("PEDialogs.GroupLabel"));
        this.loadLevelerLabel = new Label((Composite)optionsGroup, 0);
        this.loadLevelerLabel.setText(Messages.getString("PEDialogs.LoadLevelerOptionLabel"));
        this.loadLevelerOption = new Button((Composite)optionsGroup, 32);
        String preferenceValue = preferences.getString("PE_useLoadLeveler");
        if (preferenceValue.equals("Y")) {
            this.loadLevelerOption.setSelection(true);
        }
        this.llModeLabel = new Label((Composite)optionsGroup, 0);
        this.llModeLabel.setText(Messages.getString("PEDialogs.LLRunMode"));
        this.llModeGroup = new Group((Composite)optionsGroup, 16);
        layout = new GridLayout(2, true);
        this.llModeGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.llModeGroup.setLayoutData((Object)gd);
        this.llModeLocal = new Button((Composite)this.llModeGroup, 16);
        this.llModeLocal.setText(Messages.getString("PEDialogs.llModeLocal"));
        this.llModeMulticluster = new Button((Composite)this.llModeGroup, 16);
        this.llModeMulticluster.setText(Messages.getString("PEDialogs.llModeMulticluster"));
        this.llModeDefault = new Button((Composite)this.llModeGroup, 16);
        this.llModeDefault.setText(Messages.getString("PEDialogs.llModeDefault"));
        this.llModeDefault.setSelection(false);
        this.llModeLocal.setSelection(false);
        this.llModeMulticluster.setSelection(false);
        preferenceValue = preferences.getString("PE_LoadLevelerMode");
        if (preferenceValue.equals("y")) {
            this.llModeMulticluster.setSelection(true);
        } else if (preferenceValue.equals("n")) {
            this.llModeLocal.setSelection(true);
        } else {
            this.llModeDefault.setSelection(true);
        }
        this.nodePollMinLabel = new Label((Composite)optionsGroup, 0);
        this.nodePollMinLabel.setText(Messages.getString("PEDialogs.minNodePollInterval"));
        this.nodePollMinInterval = new Text((Composite)optionsGroup, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.nodePollMinInterval.setLayoutData((Object)gd);
        preferenceValue = preferences.getString("PE_NodeMinPollInterval");
        this.nodePollMinInterval.setText(preferenceValue);
        this.nodePollMaxLabel = new Label((Composite)optionsGroup, 0);
        this.nodePollMaxLabel.setText(Messages.getString("PEDialogs.maxNodePollInterval"));
        this.nodePollMaxInterval = new Text((Composite)optionsGroup, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.nodePollMaxInterval.setLayoutData((Object)gd);
        preferenceValue = preferences.getString("PE_NodeMaxPollInterval");
        this.nodePollMaxInterval.setText(preferenceValue);
        this.jobPollLabel = new Label((Composite)optionsGroup, 0);
        this.jobPollLabel.setText(Messages.getString("PEDialogs.jobPollInterval"));
        this.jobPollInterval = new Text((Composite)optionsGroup, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.jobPollInterval.setLayoutData((Object)gd);
        preferenceValue = preferences.getString("PE_JobPollInterval");
        this.jobPollInterval.setText(preferenceValue);
        this.libOverrideLabel = new Label((Composite)optionsGroup, 0);
        this.libOverrideLabel.setText(Messages.getString("PEDialogs.libOverrideLabel"));
        this.llOverrideBox = new Composite((Composite)optionsGroup, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.llOverrideBox.setLayoutData((Object)gd);
        GridLayout libPathLayout = new GridLayout(2, false);
        libPathLayout.marginLeft = 0;
        libPathLayout.marginRight = 0;
        libPathLayout.marginWidth = 0;
        this.llOverrideBox.setLayout((Layout)libPathLayout);
        this.libOverridePath = new Text(this.llOverrideBox, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.libOverridePath.setLayoutData((Object)gd);
        this.libOverrideBrowse = new Button(this.llOverrideBox, 8);
        this.libOverrideBrowse.setText(Messages.getString("PEDialogs.browse"));
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        this.libOverrideBrowse.setLayoutData((Object)gd);
        preferenceValue = preferences.getString("PE_libraryOverride");
        this.libOverridePath.setText(preferenceValue);
        this.traceLabel = new Label((Composite)optionsGroup, 0);
        this.traceLabel.setText(Messages.getString("PEDialogs.TraceLevelLabel"));
        this.traceOptions = new Combo((Composite)optionsGroup, 8);
        this.traceOptions.add("None");
        this.traceOptions.add("Function");
        this.traceOptions.add("Detail");
        this.traceOptions.setText(preferences.getString("PE_traceLevel"));
        if (!this.loadLevelerOption.getSelection()) {
            this.setLLWidgetEnableState(false);
        }
        this.loadLevelerOption.addSelectionListener((SelectionListener)this.eventMonitor);
        this.llModeLocal.addSelectionListener((SelectionListener)this.eventMonitor);
        this.llModeMulticluster.addSelectionListener((SelectionListener)this.eventMonitor);
        this.llModeDefault.addSelectionListener((SelectionListener)this.eventMonitor);
        this.nodePollMinInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.nodePollMaxInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.jobPollInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.libOverridePath.addModifyListener((ModifyListener)this.eventMonitor);
        this.libOverrideBrowse.addSelectionListener((SelectionListener)this.eventMonitor);
        this.traceOptions.addSelectionListener((SelectionListener)this.eventMonitor);
        return preferencePane;
    }

    private void setLLWidgetEnableState(boolean state) {
        this.llModeLocal.setEnabled(state);
        this.llModeMulticluster.setEnabled(state);
        this.llModeDefault.setEnabled(state);
        this.nodePollMinInterval.setEnabled(state);
        this.nodePollMaxInterval.setEnabled(state);
        this.jobPollInterval.setEnabled(state);
        this.libOverridePath.setEnabled(state);
        this.libOverrideBrowse.setEnabled(state);
    }

    protected void updatePreferencePage() {
        super.updatePreferencePage();
        Preferences preferences = this.getPreferences();
        if (this.loadLevelerOption != null) {
            if (this.loadLevelerOption.getSelection()) {
                preferences.setValue("PE_useLoadLeveler", "Y");
                String widgetValue = this.llModeDefault.getSelection() ? "d" : (this.llModeLocal.getSelection() ? "n" : "y");
                preferences.setValue("PE_LoadLevelerMode", widgetValue);
                widgetValue = this.nodePollMinInterval.getText().trim();
                if (widgetValue.length() > 0) {
                    try {
                        Integer.valueOf(widgetValue).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setErrorMessage(Messages.getString("PEDialogs.invalidMinPollInterval"));
                        return;
                    }
                }
                preferences.setValue("PE_NodeMinPollInterval", widgetValue);
                widgetValue = this.nodePollMaxInterval.getText().trim();
                if (widgetValue.length() > 0) {
                    try {
                        Integer.valueOf(widgetValue).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setErrorMessage(Messages.getString("PEDialogs.invalidMaxPollInterval"));
                        return;
                    }
                }
                preferences.setValue("PE_NodeMaxPollInterval", widgetValue);
                widgetValue = this.jobPollInterval.getText().trim();
                if (widgetValue.length() > 0) {
                    try {
                        Integer.valueOf(widgetValue).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setErrorMessage(Messages.getString("PEDialogs.invalidJobPollInterval"));
                        return;
                    }
                }
                preferences.setValue("PE_JobPollInterval", widgetValue);
                widgetValue = this.libOverridePath.getText().trim();
                preferences.setValue("PE_libraryOverride", widgetValue);
            } else {
                preferences.setValue("PE_useLoadLeveler", "N");
            }
        }
        if (this.traceOptions != null) {
            preferences.setValue("PE_traceLevel", this.traceOptions.getText());
        }
    }

    private class EventMonitor
    implements SelectionListener,
    ModifyListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (PEPreferencePage.this.loadLevelerOption.getSelection()) {
                PEPreferencePage.this.setLLWidgetEnableState(true);
            } else {
                PEPreferencePage.this.setLLWidgetEnableState(false);
            }
            PEPreferencePage.this.updatePreferencePage();
        }

        public void modifyText(ModifyEvent e) {
            PEPreferencePage.this.updatePreferencePage();
        }
    }
}

