/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAddress;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueAddress;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValue;
import org.eclipse.ptp.debug.internal.core.pdi.aif.ValueIntegral;

public class AIFValueAddress
extends AIFValue
implements IAIFValueAddress {
    private String fAddr = "";

    public AIFValueAddress(IAIFTypeAddress type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        this.setSize(this.getType().sizeof());
        int i = 0;
        while (i < this.sizeof()) {
            this.fAddr = String.valueOf(this.fAddr) + Integer.toHexString(256 + (buffer.get() & 0xFF)).substring(1);
            ++i;
        }
    }

    public String getValueString() throws AIFException {
        return "0x" + this.fAddr;
    }

    public BigInteger getAddress() throws AIFException {
        return ValueIntegral.bigIntegerValue(this.getValueString());
    }
}

