/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.core.model.Enumeration;
import org.eclipse.cdt.internal.core.model.Enumerator;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionTemplate;
import org.eclipse.cdt.internal.core.model.FunctionTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.MethodTemplate;
import org.eclipse.cdt.internal.core.model.MethodTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.Namespace;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.Structure;
import org.eclipse.cdt.internal.core.model.StructureDeclaration;
import org.eclipse.cdt.internal.core.model.StructureTemplate;
import org.eclipse.cdt.internal.core.model.StructureTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.TypeDef;
import org.eclipse.cdt.internal.core.model.Using;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.core.model.VariableDeclaration;
import org.eclipse.cdt.internal.core.model.VariableTemplate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.model.SourceManipulation;
import org.eclipse.ptp.internal.rdt.core.model.SourceManipulationInfo;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;

public class ModelBuilder {
    private final IProgressMonitor fProgressMonitor;
    private final org.eclipse.cdt.internal.core.model.TranslationUnit fTranslationUnit;
    private HashMap<ISourceReference, int[]> fEqualElements;

    public ModelBuilder(org.eclipse.cdt.internal.core.model.TranslationUnit tu, IProgressMonitor monitor) {
        this.fTranslationUnit = tu;
        this.fProgressMonitor = monitor;
    }

    public void buildLocalModel(TranslationUnit remoteTU) throws CModelException {
        ICElement[] remoteChildren;
        IInclude[] includeDirectives;
        if (this.isCanceled() || remoteTU == null) {
            return;
        }
        this.fEqualElements = new HashMap();
        IInclude[] iIncludeArray = includeDirectives = remoteTU.getIncludes();
        int n = includeDirectives.length;
        int n2 = 0;
        while (n2 < n) {
            IInclude includeDirective = iIncludeArray[n2];
            this.createInclusion((Parent)this.fTranslationUnit, includeDirective);
            ++n2;
        }
        List<ICElement> macros = remoteTU.getChildrenOfType(79);
        for (ICElement macro : macros) {
            this.createMacro((Parent)this.fTranslationUnit, (IMacro)macro);
        }
        ICElement[] iCElementArray = remoteChildren = remoteTU.getChildren();
        int n3 = remoteChildren.length;
        int n4 = 0;
        while (n4 < n3) {
            ICElement child = iCElementArray[n4];
            switch (child.getElementType()) {
                case 75: 
                case 79: {
                    break;
                }
                default: {
                    this.createElement((Parent)this.fTranslationUnit, child);
                }
            }
            ++n4;
        }
        this.fEqualElements.clear();
        if (this.isCanceled()) {
            return;
        }
    }

    private void createElement(Parent parent, ICElement remoteChild) throws CModelException {
        switch (remoteChild.getElementType()) {
            case 65: 
            case 67: 
            case 69: 
            case 83: 
            case 85: 
            case 87: {
                this.createStructure(parent, (IStructure)remoteChild);
                break;
            }
            case 64: 
            case 66: 
            case 68: 
            case 82: 
            case 84: 
            case 86: {
                this.createStructureDeclaration(parent, (IStructureDeclaration)remoteChild);
                break;
            }
            case 63: {
                this.createEnumeration(parent, (IEnumeration)remoteChild);
                break;
            }
            case 71: 
            case 73: 
            case 88: 
            case 90: {
                this.createFunctionDeclaration(parent, (IFunctionDeclaration)remoteChild);
                break;
            }
            case 61: {
                this.createNamespace(parent, (INamespace)remoteChild);
                break;
            }
            case 70: 
            case 74: 
            case 89: 
            case 91: {
                this.createFunctionDefinition(parent, (IFunctionDeclaration)remoteChild);
                break;
            }
            case 80: {
                this.createTypeDef(parent, (ITypeDef)remoteChild);
                break;
            }
            case 72: 
            case 76: 
            case 77: 
            case 92: {
                this.createVariable(parent, (IVariableDeclaration)remoteChild);
                break;
            }
            case 62: {
                this.createUsing(parent, (IUsing)remoteChild);
                break;
            }
            case 78: 
            case 93: {
                System.out.println("local model builder: missed model element");
            }
        }
    }

    private Using createUsing(Parent parent, IUsing remoteChild) throws CModelException {
        Using element = new Using((ICElement)parent, remoteChild.getElementName(), remoteChild.isDirective());
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(remoteChild.isActive());
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
        }
        return element;
    }

    private FunctionDeclaration createFunctionDefinition(Parent parent, IFunctionDeclaration remoteChild) throws CModelException {
        Object element;
        boolean isTemplate = false;
        String simpleName = remoteChild.getElementName();
        String[] parameterTypes = remoteChild.getParameterTypes();
        String returnType = remoteChild.getReturnType();
        if (remoteChild.getElementType() == 91 || remoteChild.getElementType() == 70) {
            MethodTemplate methodElement;
            String methodName = simpleName;
            if (remoteChild.getElementType() == 91) {
                methodElement = new MethodTemplate((ICElement)parent, methodName);
                isTemplate = true;
            } else {
                methodElement = new Method((ICElement)parent, methodName);
            }
            element = methodElement;
            methodElement.setParameterTypes(parameterTypes);
            methodElement.setReturnType(returnType);
            methodElement.setConst(remoteChild.isConst());
            this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
            IMethod remoteMethod = (IMethod)remoteChild;
            methodElement.setVirtual(remoteMethod.isVirtual());
            methodElement.setInline(remoteMethod.isInline());
            methodElement.setFriend(remoteMethod.isFriend());
            methodElement.setVolatile(remoteMethod.isVolatile());
            methodElement.setVisibility(remoteMethod.getVisibility());
            methodElement.setPureVirtual(remoteMethod.isPureVirtual());
            methodElement.setConstructor(remoteMethod.isConstructor());
            methodElement.setDestructor(remoteMethod.isDestructor());
        } else {
            String functionName = simpleName;
            element = remoteChild.getElementType() == 89 ? new FunctionTemplate((ICElement)parent, functionName) : new Function((ICElement)parent, functionName);
            element.setParameterTypes(parameterTypes);
            element.setReturnType(returnType);
            this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
            element.setConst(remoteChild.isConst());
        }
        element.setActive(remoteChild.isActive());
        element.setStatic(remoteChild.isStatic());
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            if (!isTemplate) {
                this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            }
            this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
        }
        return element;
    }

    private VariableDeclaration createVariable(Parent parent, IVariableDeclaration remoteChild) throws CModelException {
        Variable element;
        String variableName = remoteChild.getElementName();
        boolean isTemplate = false;
        if (remoteChild.getElementType() == 72) {
            IField remoteField = (IField)remoteChild;
            Field newElement = new Field((ICElement)parent, variableName);
            this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)newElement);
            newElement.setMutable(remoteField.isMutable());
            newElement.setTypeName(remoteField.getTypeName());
            newElement.setVisibility(remoteField.getVisibility());
            newElement.setConst(remoteField.isConst());
            newElement.setVolatile(remoteField.isVolatile());
            element = newElement;
        } else {
            switch (remoteChild.getElementType()) {
                case 92: {
                    isTemplate = true;
                    VariableTemplate newElement = new VariableTemplate((ICElement)parent, variableName);
                    element = newElement;
                    break;
                }
                case 76: {
                    Variable newElement1;
                    element = newElement1 = new Variable((ICElement)parent, variableName);
                    break;
                }
                default: {
                    VariableDeclaration newElement2 = new VariableDeclaration((ICElement)parent, variableName);
                    element = newElement2;
                }
            }
            this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
            element.setTypeName(remoteChild.getTypeName());
            element.setConst(remoteChild.isConst());
            element.setVolatile(remoteChild.isVolatile());
        }
        element.setActive(remoteChild.isActive());
        element.setStatic(remoteChild.isStatic());
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            if (!isTemplate) {
                this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            }
            this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
        }
        return element;
    }

    private FunctionDeclaration createFunctionDeclaration(Parent parent, IFunctionDeclaration remoteChild) throws CModelException {
        MethodTemplateDeclaration element;
        boolean isTemplate = false;
        String functionName = remoteChild.getElementName();
        String[] parameterTypes = remoteChild.getParameterTypes();
        String returnType = remoteChild.getReturnType();
        if (remoteChild.getElementType() == 90 || remoteChild.getElementType() == 71) {
            MethodTemplateDeclaration methodElement;
            if (remoteChild.getElementType() == 90) {
                methodElement = new MethodTemplateDeclaration((ICElement)parent, functionName);
                isTemplate = true;
            } else {
                methodElement = new MethodDeclaration((ICElement)parent, functionName);
            }
            element = methodElement;
            IMethodDeclaration remoteMethodDecl = (IMethodDeclaration)remoteChild;
            methodElement.setParameterTypes(parameterTypes);
            methodElement.setReturnType(returnType);
            methodElement.setConst(remoteChild.isConst());
            this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
            methodElement.setVirtual(remoteMethodDecl.isVirtual());
            methodElement.setInline(remoteMethodDecl.isInline());
            methodElement.setFriend(remoteMethodDecl.isFriend());
            methodElement.setVolatile(remoteMethodDecl.isVolatile());
            methodElement.setVisibility(remoteMethodDecl.getVisibility());
            methodElement.setPureVirtual(remoteMethodDecl.isPureVirtual());
            methodElement.setConstructor(remoteMethodDecl.isConstructor());
            methodElement.setDestructor(remoteMethodDecl.isDestructor());
        } else {
            if (remoteChild.getElementType() == 88) {
                element = new FunctionTemplateDeclaration((ICElement)parent, functionName);
                isTemplate = true;
            } else {
                element = new FunctionDeclaration((ICElement)parent, functionName);
            }
            element.setParameterTypes(parameterTypes);
            element.setReturnType(returnType);
            this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
            element.setConst(remoteChild.isConst());
        }
        element.setActive(remoteChild.isActive());
        element.setStatic(remoteChild.isStatic());
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            if (!isTemplate) {
                this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            }
            this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
        }
        return element;
    }

    private TypeDef createTypeDef(Parent parent, ITypeDef remoteChild) throws CModelException {
        TypeDef element = new TypeDef((ICElement)parent, remoteChild.getElementName());
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(remoteChild.isActive());
        element.setTypeName(remoteChild.getTypeName());
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
        }
        return element;
    }

    private void createNamespace(Parent parent, INamespace remoteChild) throws CModelException {
        ICElement[] grandchildren;
        String nsName = remoteChild.getElementName();
        Namespace element = new Namespace((ICElement)parent, nsName);
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(remoteChild.isActive());
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            if (nsName.length() > 0) {
                this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            } else {
                element.setIdPos(remoteElement.getIdStartPos(), remoteElement.getIdLength());
            }
        }
        element.setTypeName("namespace");
        ICElement[] iCElementArray = grandchildren = remoteChild.getChildren();
        int n = grandchildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement grandchild = iCElementArray[n2];
            this.createElement((Parent)element, grandchild);
            ++n2;
        }
    }

    private Enumeration createEnumeration(Parent parent, IEnumeration remoteChild) throws CModelException {
        String enumName = remoteChild.getElementName();
        Enumeration element = new Enumeration((ICElement)parent, enumName);
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(remoteChild.isActive());
        parent.addChild((ICElement)element);
        List grandchildren = remoteChild.getChildrenOfType(81);
        Iterator iterator = grandchildren.iterator();
        while (iterator.hasNext()) {
            this.createEnumerator((Parent)element, (IEnumerator)iterator.next());
        }
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            if (enumName.length() > 0) {
                this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            } else {
                element.setIdPos(remoteElement.getIdStartPos(), remoteElement.getIdLength());
            }
        }
        element.setTypeName("enum");
        return element;
    }

    private Enumerator createEnumerator(Parent parent, IEnumerator remoteChild) throws CModelException {
        Enumerator element = new Enumerator((ICElement)parent, remoteChild.getElementName());
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(remoteChild.isActive());
        element.setConstantExpression(remoteChild.getConstantExpression());
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
        }
        return element;
    }

    private Structure createStructure(Parent parent, IStructure remoteChild) throws CModelException {
        ICElement[] grandchildren;
        String[] superClasses;
        Structure element;
        String type = remoteChild.getTypeName();
        boolean isTemplate = false;
        switch (remoteChild.getElementType()) {
            case 83: 
            case 85: 
            case 87: {
                isTemplate = true;
            }
        }
        String className = remoteChild.getElementName();
        if (!isTemplate) {
            Structure classElement;
            element = classElement = new Structure((ICElement)parent, remoteChild.getElementType(), className);
        } else {
            StructureTemplate classTemplate = new StructureTemplate((ICElement)parent, remoteChild.getElementType(), className);
            element = classTemplate;
        }
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(remoteChild.isActive());
        String[] stringArray = superClasses = remoteChild.getSuperClassesNames();
        int n = superClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String superClass = stringArray[n2];
            element.addSuperClass(superClass, remoteChild.getSuperClassAccess(superClass));
            ++n2;
        }
        element.setTypeName(type);
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            if (!isTemplate) {
                this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            }
            if (className.length() > 0) {
                this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            } else {
                element.setIdPos(remoteElement.getIdStartPos(), remoteElement.getIdLength());
            }
        }
        ICElement[] iCElementArray = grandchildren = remoteChild.getChildren();
        int n3 = grandchildren.length;
        n = 0;
        while (n < n3) {
            ICElement grandchild = iCElementArray[n];
            this.createElement((Parent)element, grandchild);
            ++n;
        }
        return element;
    }

    private StructureDeclaration createStructureDeclaration(Parent parent, IStructureDeclaration remoteChild) throws CModelException {
        String type = remoteChild.getTypeName();
        boolean isTemplate = false;
        switch (remoteChild.getElementType()) {
            case 82: 
            case 84: 
            case 86: {
                isTemplate = true;
            }
        }
        String className = remoteChild.getElementName();
        Object element = !isTemplate ? new StructureDeclaration((ICElement)parent, className, remoteChild.getElementType()) : new StructureTemplateDeclaration((ICElement)parent, remoteChild.getElementType(), className);
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(remoteChild.isActive());
        element.setTypeName(type);
        parent.addChild((ICElement)element);
        if (remoteChild instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)remoteChild;
            this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            if (className.length() > 0) {
                this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            } else {
                element.setIdPos(remoteElement.getIdStartPos(), remoteElement.getIdLength());
            }
        }
        return element;
    }

    private Include createInclusion(Parent parent, IInclude inclusion) throws CModelException {
        String name = inclusion.getElementName();
        Include element = new Include((ICElement)parent, name, inclusion.isStandard());
        element.setFullPathName(inclusion.getFullFileName());
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(inclusion.isActive());
        element.setResolved(inclusion.isResolved());
        parent.addChild((ICElement)element);
        if (inclusion instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)inclusion;
            this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
        }
        return element;
    }

    private Macro createMacro(Parent parent, IMacro macro) throws CModelException {
        String name = macro.getElementName();
        Macro element = new Macro((ICElement)parent, name);
        this.setIndex((org.eclipse.cdt.internal.core.model.SourceManipulation)element);
        element.setActive(macro.isActive());
        parent.addChild((ICElement)element);
        if (macro instanceof SourceManipulation) {
            SourceManipulation remoteElement = (SourceManipulation)macro;
            this.setIdentifierPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
            this.setBodyPosition((org.eclipse.cdt.internal.core.model.SourceManipulation)element, remoteElement);
        }
        return element;
    }

    private void setBodyPosition(org.eclipse.cdt.internal.core.model.SourceManipulation element, SourceManipulation remoteElement) throws CModelException {
        this.setBodyPosition(element, remoteElement.getSourceManipulationInfo());
    }

    private void setBodyPosition(org.eclipse.cdt.internal.core.model.SourceManipulation element, SourceManipulationInfo remoteInfo) {
        int nodeOffset = remoteInfo.getStartPos();
        int nodeLength = remoteInfo.getLength();
        int startLine = remoteInfo.getStartLine();
        int endLine = remoteInfo.getEndLine();
        element.setPos(nodeOffset, nodeLength);
        element.setLines(startLine, endLine);
    }

    private void setIdentifierPosition(org.eclipse.cdt.internal.core.model.SourceManipulation element, SourceManipulation remoteElement) throws CModelException {
        this.setIdentifierPosition(element, remoteElement.getSourceManipulationInfo());
    }

    private void setIdentifierPosition(org.eclipse.cdt.internal.core.model.SourceManipulation element, SourceManipulationInfo remoteInfo) {
        int nodeOffset = remoteInfo.getIdStartPos();
        int nodeLength = remoteInfo.getIdLength();
        element.setIdPos(nodeOffset, nodeLength);
    }

    private void setIndex(org.eclipse.cdt.internal.core.model.SourceManipulation element) {
        int[] idx = this.fEqualElements.get(element);
        if (idx == null) {
            idx = new int[1];
            this.fEqualElements.put((ISourceReference)element, idx);
        } else {
            idx[0] = idx[0] + 1;
            element.setIndex(idx[0]);
        }
    }

    private boolean isCanceled() {
        return this.fProgressMonitor != null && this.fProgressMonitor.isCanceled();
    }
}

