/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.internal.core.LocalConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConnectionManager
implements IRemoteConnectionManager {
    private final IRemoteConnection fLocalConnection;

    public LocalConnectionManager(IRemoteServices services) {
        this.fLocalConnection = new LocalConnection(services);
    }

    @Override
    public IRemoteConnection getConnection(String name) {
        return this.fLocalConnection;
    }

    @Override
    public IRemoteConnection getConnection(URI uri) {
        if (uri.getScheme().equals(EFS.getLocalFileSystem().getScheme())) {
            return this.fLocalConnection;
        }
        return null;
    }

    @Override
    public IRemoteConnection[] getConnections() {
        return new IRemoteConnection[]{this.fLocalConnection};
    }

    @Override
    public IRemoteConnection newConnection(String name, Map<String, String> attributes) throws RemoteConnectionException {
        return this.fLocalConnection;
    }

    @Override
    public void removeConnection(IRemoteConnection connection) {
    }
}

