/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ptp.internal.rdt.ui.search.actions.OpenDeclarationsJob;
import org.eclipse.ptp.internal.rdt.ui.search.actions.SelectionParseAction;
import org.eclipse.ptp.rdt.core.RDTLog;

public class OpenDeclarationsAction
extends SelectionParseAction {
    ITextSelection fTextSelection;

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.OpenDeclarations_label);
        this.setToolTipText(CEditorMessages.OpenDeclarations_tooltip);
        this.setDescription(CEditorMessages.OpenDeclarations_description);
    }

    public void run() {
        OpenDeclarationsJob job = this.createJob();
        if (job != null) {
            job.schedule();
        }
    }

    public void runSync() throws CoreException {
        OpenDeclarationsJob job = this.createJob();
        if (job != null) {
            job.performNavigation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private OpenDeclarationsJob createJob() {
        String text = this.computeSelectedWord();
        OpenDeclarationsJob job = null;
        ICElement elem = this.fEditor.getInputCElement();
        if (elem instanceof ITranslationUnit && this.fTextSelection != null) {
            job = new OpenDeclarationsJob(this, (ITranslationUnit)elem, this.fTextSelection, text, this.fEditor);
        }
        return job;
    }

    private String computeSelectedWord() {
        this.fTextSelection = this.getSelectedStringFromEditor();
        String text = null;
        if (this.fTextSelection != null) {
            if (this.fTextSelection.getLength() > 0) {
                text = this.fTextSelection.getText();
            } else {
                IDocument document = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                IRegion reg = CWordFinder.findWord((IDocument)document, (int)this.fTextSelection.getOffset());
                if (reg != null && reg.getLength() > 0) {
                    try {
                        text = document.get(reg.getOffset(), reg.getLength());
                    }
                    catch (BadLocationException e) {
                        RDTLog.logError((Throwable)e);
                    }
                }
            }
        }
        return text;
    }
}

